// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/servicemanagement/v1/servicemanager.proto

package servicemanagement

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_api22 "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf1 "github.com/golang/protobuf/ptypes/any"
import _ "google.golang.org/genproto/protobuf/field_mask"
import _ "github.com/golang/protobuf/ptypes/struct"
import _ "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type GetServiceConfigRequest_ConfigView int32

const (
	// Server response includes all fields except SourceInfo.
	GetServiceConfigRequest_BASIC GetServiceConfigRequest_ConfigView = 0
	// Server response includes all fields including SourceInfo.
	// SourceFiles are of type 'google.api.servicemanagement.v1.ConfigFile'
	// and are only available for configs created using the
	// SubmitConfigSource method.
	GetServiceConfigRequest_FULL GetServiceConfigRequest_ConfigView = 1
)

var GetServiceConfigRequest_ConfigView_name = map[int32]string{
	0: "BASIC",
	1: "FULL",
}
var GetServiceConfigRequest_ConfigView_value = map[string]int32{
	"BASIC": 0,
	"FULL":  1,
}

func (x GetServiceConfigRequest_ConfigView) String() string {
	return proto.EnumName(GetServiceConfigRequest_ConfigView_name, int32(x))
}
func (GetServiceConfigRequest_ConfigView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{7, 0}
}

// Request message for `ListServices` method.
type ListServicesRequest struct {
	// Include services produced by the specified project.
	ProducerProjectId string `protobuf:"bytes,1,opt,name=producer_project_id,json=producerProjectId" json:"producer_project_id,omitempty"`
	// Requested size of the next page of data.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token identifying which result to start with; returned by a previous list
	// call.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Include services consumed by the specified consumer.
	//
	// The Google Service Management implementation accepts the following
	// forms:
	// - project:<project_id>
	ConsumerId string `protobuf:"bytes,7,opt,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
}

func (m *ListServicesRequest) Reset()                    { *m = ListServicesRequest{} }
func (m *ListServicesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServicesRequest) ProtoMessage()               {}
func (*ListServicesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *ListServicesRequest) GetProducerProjectId() string {
	if m != nil {
		return m.ProducerProjectId
	}
	return ""
}

func (m *ListServicesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServicesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServicesRequest) GetConsumerId() string {
	if m != nil {
		return m.ConsumerId
	}
	return ""
}

// Response message for `ListServices` method.
type ListServicesResponse struct {
	// The returned services will only have the name field set.
	Services []*ManagedService `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
	// Token that can be passed to `ListServices` to resume a paginated query.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListServicesResponse) Reset()                    { *m = ListServicesResponse{} }
func (m *ListServicesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListServicesResponse) ProtoMessage()               {}
func (*ListServicesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *ListServicesResponse) GetServices() []*ManagedService {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *ListServicesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for `GetService` method.
type GetServiceRequest struct {
	// The name of the service.  See the `ServiceManager` overview for naming
	// requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
}

func (m *GetServiceRequest) Reset()                    { *m = GetServiceRequest{} }
func (m *GetServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServiceRequest) ProtoMessage()               {}
func (*GetServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *GetServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Request message for CreateService method.
type CreateServiceRequest struct {
	// Initial values for the service resource.
	Service *ManagedService `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
}

func (m *CreateServiceRequest) Reset()                    { *m = CreateServiceRequest{} }
func (m *CreateServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateServiceRequest) ProtoMessage()               {}
func (*CreateServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *CreateServiceRequest) GetService() *ManagedService {
	if m != nil {
		return m.Service
	}
	return nil
}

// Request message for DeleteService method.
type DeleteServiceRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
}

func (m *DeleteServiceRequest) Reset()                    { *m = DeleteServiceRequest{} }
func (m *DeleteServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteServiceRequest) ProtoMessage()               {}
func (*DeleteServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *DeleteServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Request message for UndeleteService method.
type UndeleteServiceRequest struct {
	// The name of the service. See the [overview](/service-management/overview)
	// for naming requirements. For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
}

func (m *UndeleteServiceRequest) Reset()                    { *m = UndeleteServiceRequest{} }
func (m *UndeleteServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*UndeleteServiceRequest) ProtoMessage()               {}
func (*UndeleteServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *UndeleteServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Response message for UndeleteService method.
type UndeleteServiceResponse struct {
	// Revived service resource.
	Service *ManagedService `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
}

func (m *UndeleteServiceResponse) Reset()                    { *m = UndeleteServiceResponse{} }
func (m *UndeleteServiceResponse) String() string            { return proto.CompactTextString(m) }
func (*UndeleteServiceResponse) ProtoMessage()               {}
func (*UndeleteServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *UndeleteServiceResponse) GetService() *ManagedService {
	if m != nil {
		return m.Service
	}
	return nil
}

// Request message for GetServiceConfig method.
type GetServiceConfigRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The id of the service configuration resource.
	ConfigId string `protobuf:"bytes,2,opt,name=config_id,json=configId" json:"config_id,omitempty"`
	// Specifies which parts of the Service Config should be returned in the
	// response.
	View GetServiceConfigRequest_ConfigView `protobuf:"varint,3,opt,name=view,enum=google.api.servicemanagement.v1.GetServiceConfigRequest_ConfigView" json:"view,omitempty"`
}

func (m *GetServiceConfigRequest) Reset()                    { *m = GetServiceConfigRequest{} }
func (m *GetServiceConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServiceConfigRequest) ProtoMessage()               {}
func (*GetServiceConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *GetServiceConfigRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *GetServiceConfigRequest) GetConfigId() string {
	if m != nil {
		return m.ConfigId
	}
	return ""
}

func (m *GetServiceConfigRequest) GetView() GetServiceConfigRequest_ConfigView {
	if m != nil {
		return m.View
	}
	return GetServiceConfigRequest_BASIC
}

// Request message for ListServiceConfigs method.
type ListServiceConfigsRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The token of the page to retrieve.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The max number of items to include in the response list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListServiceConfigsRequest) Reset()                    { *m = ListServiceConfigsRequest{} }
func (m *ListServiceConfigsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServiceConfigsRequest) ProtoMessage()               {}
func (*ListServiceConfigsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *ListServiceConfigsRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *ListServiceConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServiceConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for ListServiceConfigs method.
type ListServiceConfigsResponse struct {
	// The list of service configuration resources.
	ServiceConfigs []*google_api22.Service `protobuf:"bytes,1,rep,name=service_configs,json=serviceConfigs" json:"service_configs,omitempty"`
	// The token of the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListServiceConfigsResponse) Reset()                    { *m = ListServiceConfigsResponse{} }
func (m *ListServiceConfigsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListServiceConfigsResponse) ProtoMessage()               {}
func (*ListServiceConfigsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *ListServiceConfigsResponse) GetServiceConfigs() []*google_api22.Service {
	if m != nil {
		return m.ServiceConfigs
	}
	return nil
}

func (m *ListServiceConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for CreateServiceConfig method.
type CreateServiceConfigRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The service configuration resource.
	ServiceConfig *google_api22.Service `protobuf:"bytes,2,opt,name=service_config,json=serviceConfig" json:"service_config,omitempty"`
}

func (m *CreateServiceConfigRequest) Reset()                    { *m = CreateServiceConfigRequest{} }
func (m *CreateServiceConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateServiceConfigRequest) ProtoMessage()               {}
func (*CreateServiceConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *CreateServiceConfigRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *CreateServiceConfigRequest) GetServiceConfig() *google_api22.Service {
	if m != nil {
		return m.ServiceConfig
	}
	return nil
}

// Request message for SubmitConfigSource method.
type SubmitConfigSourceRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The source configuration for the service.
	ConfigSource *ConfigSource `protobuf:"bytes,2,opt,name=config_source,json=configSource" json:"config_source,omitempty"`
	// Optional. If set, this will result in the generation of a
	// `google.api.Service` configuration based on the `ConfigSource` provided,
	// but the generated config and the sources will NOT be persisted.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly" json:"validate_only,omitempty"`
}

func (m *SubmitConfigSourceRequest) Reset()                    { *m = SubmitConfigSourceRequest{} }
func (m *SubmitConfigSourceRequest) String() string            { return proto.CompactTextString(m) }
func (*SubmitConfigSourceRequest) ProtoMessage()               {}
func (*SubmitConfigSourceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *SubmitConfigSourceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *SubmitConfigSourceRequest) GetConfigSource() *ConfigSource {
	if m != nil {
		return m.ConfigSource
	}
	return nil
}

func (m *SubmitConfigSourceRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// Response message for SubmitConfigSource method.
type SubmitConfigSourceResponse struct {
	// The generated service configuration.
	ServiceConfig *google_api22.Service `protobuf:"bytes,1,opt,name=service_config,json=serviceConfig" json:"service_config,omitempty"`
}

func (m *SubmitConfigSourceResponse) Reset()                    { *m = SubmitConfigSourceResponse{} }
func (m *SubmitConfigSourceResponse) String() string            { return proto.CompactTextString(m) }
func (*SubmitConfigSourceResponse) ProtoMessage()               {}
func (*SubmitConfigSourceResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *SubmitConfigSourceResponse) GetServiceConfig() *google_api22.Service {
	if m != nil {
		return m.ServiceConfig
	}
	return nil
}

// Request message for 'CreateServiceRollout'
type CreateServiceRolloutRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The rollout resource. The `service_name` field is output only.
	Rollout *Rollout `protobuf:"bytes,2,opt,name=rollout" json:"rollout,omitempty"`
}

func (m *CreateServiceRolloutRequest) Reset()                    { *m = CreateServiceRolloutRequest{} }
func (m *CreateServiceRolloutRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateServiceRolloutRequest) ProtoMessage()               {}
func (*CreateServiceRolloutRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *CreateServiceRolloutRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *CreateServiceRolloutRequest) GetRollout() *Rollout {
	if m != nil {
		return m.Rollout
	}
	return nil
}

// Request message for 'ListServiceRollouts'
type ListServiceRolloutsRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The token of the page to retrieve.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The max number of items to include in the response list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Use `filter` to return subset of rollouts.
	// The following filters are supported:
	//   -- To limit the results to only those in
	//      [status](google.api.servicemanagement.v1.RolloutStatus) 'SUCCESS',
	//      use filter='status=SUCCESS'
	//   -- To limit the results to those in
	//      [status](google.api.servicemanagement.v1.RolloutStatus) 'CANCELLED'
	//      or 'FAILED', use filter='status=CANCELLED OR status=FAILED'
	Filter string `protobuf:"bytes,4,opt,name=filter" json:"filter,omitempty"`
}

func (m *ListServiceRolloutsRequest) Reset()                    { *m = ListServiceRolloutsRequest{} }
func (m *ListServiceRolloutsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServiceRolloutsRequest) ProtoMessage()               {}
func (*ListServiceRolloutsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *ListServiceRolloutsRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *ListServiceRolloutsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServiceRolloutsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServiceRolloutsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response message for ListServiceRollouts method.
type ListServiceRolloutsResponse struct {
	// The list of rollout resources.
	Rollouts []*Rollout `protobuf:"bytes,1,rep,name=rollouts" json:"rollouts,omitempty"`
	// The token of the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListServiceRolloutsResponse) Reset()                    { *m = ListServiceRolloutsResponse{} }
func (m *ListServiceRolloutsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListServiceRolloutsResponse) ProtoMessage()               {}
func (*ListServiceRolloutsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *ListServiceRolloutsResponse) GetRollouts() []*Rollout {
	if m != nil {
		return m.Rollouts
	}
	return nil
}

func (m *ListServiceRolloutsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for GetServiceRollout method.
type GetServiceRolloutRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The id of the rollout resource.
	RolloutId string `protobuf:"bytes,2,opt,name=rollout_id,json=rolloutId" json:"rollout_id,omitempty"`
}

func (m *GetServiceRolloutRequest) Reset()                    { *m = GetServiceRolloutRequest{} }
func (m *GetServiceRolloutRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServiceRolloutRequest) ProtoMessage()               {}
func (*GetServiceRolloutRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *GetServiceRolloutRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *GetServiceRolloutRequest) GetRolloutId() string {
	if m != nil {
		return m.RolloutId
	}
	return ""
}

// Request message for EnableService method.
type EnableServiceRequest struct {
	// Name of the service to enable. Specifying an unknown service name will
	// cause the request to fail.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The identity of consumer resource which service enablement will be
	// applied to.
	//
	// The Google Service Management implementation accepts the following
	// forms:
	// - "project:<project_id>"
	//
	// Note: this is made compatible with
	// google.api.servicecontrol.v1.Operation.consumer_id.
	ConsumerId string `protobuf:"bytes,2,opt,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
}

func (m *EnableServiceRequest) Reset()                    { *m = EnableServiceRequest{} }
func (m *EnableServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*EnableServiceRequest) ProtoMessage()               {}
func (*EnableServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func (m *EnableServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *EnableServiceRequest) GetConsumerId() string {
	if m != nil {
		return m.ConsumerId
	}
	return ""
}

// Request message for DisableService method.
type DisableServiceRequest struct {
	// Name of the service to disable. Specifying an unknown service name
	// will cause the request to fail.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The identity of consumer resource which service disablement will be
	// applied to.
	//
	// The Google Service Management implementation accepts the following
	// forms:
	// - "project:<project_id>"
	//
	// Note: this is made compatible with
	// google.api.servicecontrol.v1.Operation.consumer_id.
	ConsumerId string `protobuf:"bytes,2,opt,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
}

func (m *DisableServiceRequest) Reset()                    { *m = DisableServiceRequest{} }
func (m *DisableServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*DisableServiceRequest) ProtoMessage()               {}
func (*DisableServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{18} }

func (m *DisableServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *DisableServiceRequest) GetConsumerId() string {
	if m != nil {
		return m.ConsumerId
	}
	return ""
}

// Request message for GenerateConfigReport method.
type GenerateConfigReportRequest struct {
	// Service configuration for which we want to generate the report.
	// For this version of API, the supported types are
	// [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
	// [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
	// and [google.api.Service][google.api.Service]
	NewConfig *google_protobuf1.Any `protobuf:"bytes,1,opt,name=new_config,json=newConfig" json:"new_config,omitempty"`
	// Service configuration against which the comparison will be done.
	// For this version of API, the supported types are
	// [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
	// [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
	// and [google.api.Service][google.api.Service]
	OldConfig *google_protobuf1.Any `protobuf:"bytes,2,opt,name=old_config,json=oldConfig" json:"old_config,omitempty"`
}

func (m *GenerateConfigReportRequest) Reset()                    { *m = GenerateConfigReportRequest{} }
func (m *GenerateConfigReportRequest) String() string            { return proto.CompactTextString(m) }
func (*GenerateConfigReportRequest) ProtoMessage()               {}
func (*GenerateConfigReportRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{19} }

func (m *GenerateConfigReportRequest) GetNewConfig() *google_protobuf1.Any {
	if m != nil {
		return m.NewConfig
	}
	return nil
}

func (m *GenerateConfigReportRequest) GetOldConfig() *google_protobuf1.Any {
	if m != nil {
		return m.OldConfig
	}
	return nil
}

// Response message for GenerateConfigReport method.
type GenerateConfigReportResponse struct {
	// Name of the service this report belongs to.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// ID of the service configuration this report belongs to.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// list of ChangeReport, each corresponding to comparison between two
	// service configurations.
	ChangeReports []*ChangeReport `protobuf:"bytes,3,rep,name=change_reports,json=changeReports" json:"change_reports,omitempty"`
	// Errors / Linter warnings associated with the service definition this
	// report
	// belongs to.
	Diagnostics []*Diagnostic `protobuf:"bytes,4,rep,name=diagnostics" json:"diagnostics,omitempty"`
}

func (m *GenerateConfigReportResponse) Reset()                    { *m = GenerateConfigReportResponse{} }
func (m *GenerateConfigReportResponse) String() string            { return proto.CompactTextString(m) }
func (*GenerateConfigReportResponse) ProtoMessage()               {}
func (*GenerateConfigReportResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{20} }

func (m *GenerateConfigReportResponse) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *GenerateConfigReportResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *GenerateConfigReportResponse) GetChangeReports() []*ChangeReport {
	if m != nil {
		return m.ChangeReports
	}
	return nil
}

func (m *GenerateConfigReportResponse) GetDiagnostics() []*Diagnostic {
	if m != nil {
		return m.Diagnostics
	}
	return nil
}

func init() {
	proto.RegisterType((*ListServicesRequest)(nil), "google.api.servicemanagement.v1.ListServicesRequest")
	proto.RegisterType((*ListServicesResponse)(nil), "google.api.servicemanagement.v1.ListServicesResponse")
	proto.RegisterType((*GetServiceRequest)(nil), "google.api.servicemanagement.v1.GetServiceRequest")
	proto.RegisterType((*CreateServiceRequest)(nil), "google.api.servicemanagement.v1.CreateServiceRequest")
	proto.RegisterType((*DeleteServiceRequest)(nil), "google.api.servicemanagement.v1.DeleteServiceRequest")
	proto.RegisterType((*UndeleteServiceRequest)(nil), "google.api.servicemanagement.v1.UndeleteServiceRequest")
	proto.RegisterType((*UndeleteServiceResponse)(nil), "google.api.servicemanagement.v1.UndeleteServiceResponse")
	proto.RegisterType((*GetServiceConfigRequest)(nil), "google.api.servicemanagement.v1.GetServiceConfigRequest")
	proto.RegisterType((*ListServiceConfigsRequest)(nil), "google.api.servicemanagement.v1.ListServiceConfigsRequest")
	proto.RegisterType((*ListServiceConfigsResponse)(nil), "google.api.servicemanagement.v1.ListServiceConfigsResponse")
	proto.RegisterType((*CreateServiceConfigRequest)(nil), "google.api.servicemanagement.v1.CreateServiceConfigRequest")
	proto.RegisterType((*SubmitConfigSourceRequest)(nil), "google.api.servicemanagement.v1.SubmitConfigSourceRequest")
	proto.RegisterType((*SubmitConfigSourceResponse)(nil), "google.api.servicemanagement.v1.SubmitConfigSourceResponse")
	proto.RegisterType((*CreateServiceRolloutRequest)(nil), "google.api.servicemanagement.v1.CreateServiceRolloutRequest")
	proto.RegisterType((*ListServiceRolloutsRequest)(nil), "google.api.servicemanagement.v1.ListServiceRolloutsRequest")
	proto.RegisterType((*ListServiceRolloutsResponse)(nil), "google.api.servicemanagement.v1.ListServiceRolloutsResponse")
	proto.RegisterType((*GetServiceRolloutRequest)(nil), "google.api.servicemanagement.v1.GetServiceRolloutRequest")
	proto.RegisterType((*EnableServiceRequest)(nil), "google.api.servicemanagement.v1.EnableServiceRequest")
	proto.RegisterType((*DisableServiceRequest)(nil), "google.api.servicemanagement.v1.DisableServiceRequest")
	proto.RegisterType((*GenerateConfigReportRequest)(nil), "google.api.servicemanagement.v1.GenerateConfigReportRequest")
	proto.RegisterType((*GenerateConfigReportResponse)(nil), "google.api.servicemanagement.v1.GenerateConfigReportResponse")
	proto.RegisterEnum("google.api.servicemanagement.v1.GetServiceConfigRequest_ConfigView", GetServiceConfigRequest_ConfigView_name, GetServiceConfigRequest_ConfigView_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ServiceManager service

type ServiceManagerClient interface {
	// Lists managed services.
	//
	// Returns all public services. For authenticated users, also returns all
	// services the calling user has "servicemanagement.services.get" permission
	// for.
	//
	// **BETA:** If the caller specifies the `consumer_id`, it returns only the
	// services enabled on the consumer. The `consumer_id` must have the format
	// of "project:{PROJECT-ID}".
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Gets a managed service. Authentication is required unless the service is
	// public.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*ManagedService, error)
	// Creates a new managed service.
	// Please note one producer project can own no more than 20 services.
	//
	// Operation<response: ManagedService>
	CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes a managed service. This method will change the service to the
	// `Soft-Delete` state for 30 days. Within this period, service producers may
	// call [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService] to restore the service.
	// After 30 days, the service will be permanently deleted.
	//
	// Operation<response: google.protobuf.Empty>
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Revives a previously deleted managed service. The method restores the
	// service using the configuration at the time the service was deleted.
	// The target service must exist and must have been deleted within the
	// last 30 days.
	//
	// Operation<response: UndeleteServiceResponse>
	UndeleteService(ctx context.Context, in *UndeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Lists the history of the service configuration for a managed service,
	// from the newest to the oldest.
	ListServiceConfigs(ctx context.Context, in *ListServiceConfigsRequest, opts ...grpc.CallOption) (*ListServiceConfigsResponse, error)
	// Gets a service configuration (version) for a managed service.
	GetServiceConfig(ctx context.Context, in *GetServiceConfigRequest, opts ...grpc.CallOption) (*google_api22.Service, error)
	// Creates a new service configuration (version) for a managed service.
	// This method only stores the service configuration. To roll out the service
	// configuration to backend systems please call
	// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	CreateServiceConfig(ctx context.Context, in *CreateServiceConfigRequest, opts ...grpc.CallOption) (*google_api22.Service, error)
	// Creates a new service configuration (version) for a managed service based
	// on
	// user-supplied configuration source files (for example: OpenAPI
	// Specification). This method stores the source configurations as well as the
	// generated service configuration. To rollout the service configuration to
	// other services,
	// please call [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	//
	// Operation<response: SubmitConfigSourceResponse>
	SubmitConfigSource(ctx context.Context, in *SubmitConfigSourceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Lists the history of the service configuration rollouts for a managed
	// service, from the newest to the oldest.
	ListServiceRollouts(ctx context.Context, in *ListServiceRolloutsRequest, opts ...grpc.CallOption) (*ListServiceRolloutsResponse, error)
	// Gets a service configuration [rollout][google.api.servicemanagement.v1.Rollout].
	GetServiceRollout(ctx context.Context, in *GetServiceRolloutRequest, opts ...grpc.CallOption) (*Rollout, error)
	// Creates a new service configuration rollout. Based on rollout, the
	// Google Service Management will roll out the service configurations to
	// different backend services. For example, the logging configuration will be
	// pushed to Google Cloud Logging.
	//
	// Please note that any previous pending and running Rollouts and associated
	// Operations will be automatically cancelled so that the latest Rollout will
	// not be blocked by previous Rollouts.
	//
	// Operation<response: Rollout>
	CreateServiceRollout(ctx context.Context, in *CreateServiceRolloutRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Generates and returns a report (errors, warnings and changes from
	// existing configurations) associated with
	// GenerateConfigReportRequest.new_value
	//
	// If GenerateConfigReportRequest.old_value is specified,
	// GenerateConfigReportRequest will contain a single ChangeReport based on the
	// comparison between GenerateConfigReportRequest.new_value and
	// GenerateConfigReportRequest.old_value.
	// If GenerateConfigReportRequest.old_value is not specified, this method
	// will compare GenerateConfigReportRequest.new_value with the last pushed
	// service configuration.
	GenerateConfigReport(ctx context.Context, in *GenerateConfigReportRequest, opts ...grpc.CallOption) (*GenerateConfigReportResponse, error)
	// Enables a [service][google.api.servicemanagement.v1.ManagedService] for a project, so it can be used
	// for the project. See
	// [Cloud Auth Guide](https://cloud.google.com/docs/authentication) for
	// more information.
	//
	// Operation<response: EnableServiceResponse>
	EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Disables a [service][google.api.servicemanagement.v1.ManagedService] for a project, so it can no longer be
	// be used for the project. It prevents accidental usage that may cause
	// unexpected billing charges or security leaks.
	//
	// Operation<response: DisableServiceResponse>
	DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type serviceManagerClient struct {
	cc *grpc.ClientConn
}

func NewServiceManagerClient(cc *grpc.ClientConn) ServiceManagerClient {
	return &serviceManagerClient{cc}
}

func (c *serviceManagerClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/ListServices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*ManagedService, error) {
	out := new(ManagedService)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GetService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/CreateService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/DeleteService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) UndeleteService(ctx context.Context, in *UndeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/UndeleteService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) ListServiceConfigs(ctx context.Context, in *ListServiceConfigsRequest, opts ...grpc.CallOption) (*ListServiceConfigsResponse, error) {
	out := new(ListServiceConfigsResponse)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/ListServiceConfigs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GetServiceConfig(ctx context.Context, in *GetServiceConfigRequest, opts ...grpc.CallOption) (*google_api22.Service, error) {
	out := new(google_api22.Service)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GetServiceConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) CreateServiceConfig(ctx context.Context, in *CreateServiceConfigRequest, opts ...grpc.CallOption) (*google_api22.Service, error) {
	out := new(google_api22.Service)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/CreateServiceConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) SubmitConfigSource(ctx context.Context, in *SubmitConfigSourceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/SubmitConfigSource", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) ListServiceRollouts(ctx context.Context, in *ListServiceRolloutsRequest, opts ...grpc.CallOption) (*ListServiceRolloutsResponse, error) {
	out := new(ListServiceRolloutsResponse)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/ListServiceRollouts", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GetServiceRollout(ctx context.Context, in *GetServiceRolloutRequest, opts ...grpc.CallOption) (*Rollout, error) {
	out := new(Rollout)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GetServiceRollout", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) CreateServiceRollout(ctx context.Context, in *CreateServiceRolloutRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/CreateServiceRollout", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GenerateConfigReport(ctx context.Context, in *GenerateConfigReportRequest, opts ...grpc.CallOption) (*GenerateConfigReportResponse, error) {
	out := new(GenerateConfigReportResponse)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GenerateConfigReport", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/EnableService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/DisableService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ServiceManager service

type ServiceManagerServer interface {
	// Lists managed services.
	//
	// Returns all public services. For authenticated users, also returns all
	// services the calling user has "servicemanagement.services.get" permission
	// for.
	//
	// **BETA:** If the caller specifies the `consumer_id`, it returns only the
	// services enabled on the consumer. The `consumer_id` must have the format
	// of "project:{PROJECT-ID}".
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Gets a managed service. Authentication is required unless the service is
	// public.
	GetService(context.Context, *GetServiceRequest) (*ManagedService, error)
	// Creates a new managed service.
	// Please note one producer project can own no more than 20 services.
	//
	// Operation<response: ManagedService>
	CreateService(context.Context, *CreateServiceRequest) (*google_longrunning.Operation, error)
	// Deletes a managed service. This method will change the service to the
	// `Soft-Delete` state for 30 days. Within this period, service producers may
	// call [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService] to restore the service.
	// After 30 days, the service will be permanently deleted.
	//
	// Operation<response: google.protobuf.Empty>
	DeleteService(context.Context, *DeleteServiceRequest) (*google_longrunning.Operation, error)
	// Revives a previously deleted managed service. The method restores the
	// service using the configuration at the time the service was deleted.
	// The target service must exist and must have been deleted within the
	// last 30 days.
	//
	// Operation<response: UndeleteServiceResponse>
	UndeleteService(context.Context, *UndeleteServiceRequest) (*google_longrunning.Operation, error)
	// Lists the history of the service configuration for a managed service,
	// from the newest to the oldest.
	ListServiceConfigs(context.Context, *ListServiceConfigsRequest) (*ListServiceConfigsResponse, error)
	// Gets a service configuration (version) for a managed service.
	GetServiceConfig(context.Context, *GetServiceConfigRequest) (*google_api22.Service, error)
	// Creates a new service configuration (version) for a managed service.
	// This method only stores the service configuration. To roll out the service
	// configuration to backend systems please call
	// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	CreateServiceConfig(context.Context, *CreateServiceConfigRequest) (*google_api22.Service, error)
	// Creates a new service configuration (version) for a managed service based
	// on
	// user-supplied configuration source files (for example: OpenAPI
	// Specification). This method stores the source configurations as well as the
	// generated service configuration. To rollout the service configuration to
	// other services,
	// please call [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	//
	// Operation<response: SubmitConfigSourceResponse>
	SubmitConfigSource(context.Context, *SubmitConfigSourceRequest) (*google_longrunning.Operation, error)
	// Lists the history of the service configuration rollouts for a managed
	// service, from the newest to the oldest.
	ListServiceRollouts(context.Context, *ListServiceRolloutsRequest) (*ListServiceRolloutsResponse, error)
	// Gets a service configuration [rollout][google.api.servicemanagement.v1.Rollout].
	GetServiceRollout(context.Context, *GetServiceRolloutRequest) (*Rollout, error)
	// Creates a new service configuration rollout. Based on rollout, the
	// Google Service Management will roll out the service configurations to
	// different backend services. For example, the logging configuration will be
	// pushed to Google Cloud Logging.
	//
	// Please note that any previous pending and running Rollouts and associated
	// Operations will be automatically cancelled so that the latest Rollout will
	// not be blocked by previous Rollouts.
	//
	// Operation<response: Rollout>
	CreateServiceRollout(context.Context, *CreateServiceRolloutRequest) (*google_longrunning.Operation, error)
	// Generates and returns a report (errors, warnings and changes from
	// existing configurations) associated with
	// GenerateConfigReportRequest.new_value
	//
	// If GenerateConfigReportRequest.old_value is specified,
	// GenerateConfigReportRequest will contain a single ChangeReport based on the
	// comparison between GenerateConfigReportRequest.new_value and
	// GenerateConfigReportRequest.old_value.
	// If GenerateConfigReportRequest.old_value is not specified, this method
	// will compare GenerateConfigReportRequest.new_value with the last pushed
	// service configuration.
	GenerateConfigReport(context.Context, *GenerateConfigReportRequest) (*GenerateConfigReportResponse, error)
	// Enables a [service][google.api.servicemanagement.v1.ManagedService] for a project, so it can be used
	// for the project. See
	// [Cloud Auth Guide](https://cloud.google.com/docs/authentication) for
	// more information.
	//
	// Operation<response: EnableServiceResponse>
	EnableService(context.Context, *EnableServiceRequest) (*google_longrunning.Operation, error)
	// Disables a [service][google.api.servicemanagement.v1.ManagedService] for a project, so it can no longer be
	// be used for the project. It prevents accidental usage that may cause
	// unexpected billing charges or security leaks.
	//
	// Operation<response: DisableServiceResponse>
	DisableService(context.Context, *DisableServiceRequest) (*google_longrunning.Operation, error)
}

func RegisterServiceManagerServer(s *grpc.Server, srv ServiceManagerServer) {
	s.RegisterService(&_ServiceManager_serviceDesc, srv)
}

func _ServiceManager_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_CreateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).CreateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/CreateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).CreateService(ctx, req.(*CreateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/DeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_UndeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).UndeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/UndeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).UndeleteService(ctx, req.(*UndeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_ListServiceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).ListServiceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/ListServiceConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).ListServiceConfigs(ctx, req.(*ListServiceConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GetServiceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GetServiceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GetServiceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GetServiceConfig(ctx, req.(*GetServiceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_CreateServiceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).CreateServiceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/CreateServiceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).CreateServiceConfig(ctx, req.(*CreateServiceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_SubmitConfigSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitConfigSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).SubmitConfigSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/SubmitConfigSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).SubmitConfigSource(ctx, req.(*SubmitConfigSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_ListServiceRollouts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceRolloutsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).ListServiceRollouts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/ListServiceRollouts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).ListServiceRollouts(ctx, req.(*ListServiceRolloutsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GetServiceRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GetServiceRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GetServiceRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GetServiceRollout(ctx, req.(*GetServiceRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_CreateServiceRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).CreateServiceRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/CreateServiceRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).CreateServiceRollout(ctx, req.(*CreateServiceRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GenerateConfigReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateConfigReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GenerateConfigReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GenerateConfigReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GenerateConfigReport(ctx, req.(*GenerateConfigReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_EnableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).EnableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/EnableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).EnableService(ctx, req.(*EnableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_DisableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).DisableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/DisableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).DisableService(ctx, req.(*DisableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.servicemanagement.v1.ServiceManager",
	HandlerType: (*ServiceManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServices",
			Handler:    _ServiceManager_ListServices_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _ServiceManager_GetService_Handler,
		},
		{
			MethodName: "CreateService",
			Handler:    _ServiceManager_CreateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _ServiceManager_DeleteService_Handler,
		},
		{
			MethodName: "UndeleteService",
			Handler:    _ServiceManager_UndeleteService_Handler,
		},
		{
			MethodName: "ListServiceConfigs",
			Handler:    _ServiceManager_ListServiceConfigs_Handler,
		},
		{
			MethodName: "GetServiceConfig",
			Handler:    _ServiceManager_GetServiceConfig_Handler,
		},
		{
			MethodName: "CreateServiceConfig",
			Handler:    _ServiceManager_CreateServiceConfig_Handler,
		},
		{
			MethodName: "SubmitConfigSource",
			Handler:    _ServiceManager_SubmitConfigSource_Handler,
		},
		{
			MethodName: "ListServiceRollouts",
			Handler:    _ServiceManager_ListServiceRollouts_Handler,
		},
		{
			MethodName: "GetServiceRollout",
			Handler:    _ServiceManager_GetServiceRollout_Handler,
		},
		{
			MethodName: "CreateServiceRollout",
			Handler:    _ServiceManager_CreateServiceRollout_Handler,
		},
		{
			MethodName: "GenerateConfigReport",
			Handler:    _ServiceManager_GenerateConfigReport_Handler,
		},
		{
			MethodName: "EnableService",
			Handler:    _ServiceManager_EnableService_Handler,
		},
		{
			MethodName: "DisableService",
			Handler:    _ServiceManager_DisableService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/servicemanagement/v1/servicemanager.proto",
}

func init() {
	proto.RegisterFile("google/api/servicemanagement/v1/servicemanager.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 1417 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0x4f, 0x6f, 0xdc, 0x44,
	0x14, 0x67, 0x36, 0x69, 0x9b, 0xbc, 0x64, 0xb7, 0xed, 0x64, 0x69, 0xb6, 0x9b, 0x46, 0x4d, 0x9d,
	0x52, 0xa2, 0x94, 0xae, 0xd5, 0xf4, 0x0f, 0x74, 0x53, 0x0e, 0x4d, 0x02, 0x55, 0x44, 0x4b, 0xa3,
	0x4d, 0x4b, 0x51, 0x01, 0xad, 0x1c, 0x7b, 0x62, 0x4c, 0xbd, 0x33, 0x8b, 0xc7, 0x9b, 0x90, 0x46,
	0xbd, 0x54, 0x95, 0x90, 0xe0, 0x84, 0x0a, 0xf4, 0x5e, 0x21, 0x0e, 0x5c, 0x39, 0x20, 0x71, 0x40,
	0xf0, 0x19, 0x80, 0x6f, 0xc0, 0x67, 0xe0, 0x8c, 0x3c, 0x1e, 0x6f, 0x3c, 0xbb, 0xce, 0xda, 0x8e,
	0x80, 0xa3, 0xdf, 0xf8, 0xf7, 0xde, 0x6f, 0xde, 0xbc, 0xf7, 0xe6, 0x67, 0xc3, 0x65, 0x9b, 0x31,
	0xdb, 0x25, 0xba, 0xd1, 0x76, 0x74, 0x4e, 0xbc, 0x2d, 0xc7, 0x24, 0x2d, 0x83, 0x1a, 0x36, 0x69,
	0x11, 0xea, 0xeb, 0x5b, 0x17, 0x55, 0xa3, 0x57, 0x6b, 0x7b, 0xcc, 0x67, 0xf8, 0x74, 0x88, 0xaa,
	0x19, 0x6d, 0xa7, 0xd6, 0x87, 0xaa, 0x6d, 0x5d, 0xac, 0x9e, 0x8a, 0xb9, 0x35, 0x28, 0x65, 0xbe,
	0xe1, 0x3b, 0x8c, 0xf2, 0x10, 0x5e, 0xad, 0xf4, 0x07, 0x95, 0x2b, 0x7a, 0x1a, 0x1d, 0x8f, 0x70,
	0xd6, 0xf1, 0x4c, 0x12, 0xb9, 0x9a, 0x95, 0x00, 0x97, 0x51, 0xdb, 0xeb, 0x50, 0xea, 0x50, 0x5b,
	0x67, 0x6d, 0xe2, 0x29, 0xf1, 0x4e, 0xca, 0x97, 0xc4, 0xd3, 0x46, 0x67, 0x53, 0x37, 0xe8, 0x8e,
	0x5c, 0x9a, 0xe9, 0x5d, 0xda, 0x74, 0x88, 0x6b, 0x35, 0x5b, 0x06, 0x7f, 0x28, 0xdf, 0x38, 0xd5,
	0xfb, 0x06, 0xf7, 0xbd, 0x8e, 0xe9, 0xcb, 0xd5, 0x49, 0xb9, 0xea, 0xb5, 0x4d, 0x9d, 0xfb, 0x86,
	0xdf, 0x91, 0x31, 0xb5, 0x17, 0x08, 0x26, 0x6e, 0x39, 0xdc, 0x5f, 0x0f, 0x77, 0xc1, 0x1b, 0xe4,
	0xd3, 0x0e, 0xe1, 0x3e, 0xae, 0xc1, 0x44, 0xdb, 0x63, 0x56, 0xc7, 0x24, 0x5e, 0xb3, 0xed, 0xb1,
	0x4f, 0x88, 0xe9, 0x37, 0x1d, 0xab, 0x82, 0x66, 0xd0, 0xdc, 0x68, 0xe3, 0x78, 0xb4, 0xb4, 0x16,
	0xae, 0xac, 0x5a, 0x78, 0x0a, 0x46, 0xdb, 0x86, 0x4d, 0x9a, 0xdc, 0x79, 0x44, 0x2a, 0x87, 0x66,
	0xd0, 0xdc, 0xa1, 0xc6, 0x48, 0x60, 0x58, 0x77, 0x1e, 0x11, 0x3c, 0x0d, 0x20, 0x16, 0x7d, 0xf6,
	0x90, 0xd0, 0xca, 0x61, 0xe1, 0x43, 0xbc, 0x7e, 0x37, 0x30, 0xe0, 0xd3, 0x30, 0x66, 0x32, 0xca,
	0x3b, 0x2d, 0xe2, 0x05, 0x31, 0x8e, 0x88, 0x75, 0x88, 0x4c, 0xab, 0x96, 0xf6, 0x25, 0x82, 0xb2,
	0x4a, 0x92, 0xb7, 0x19, 0xe5, 0x04, 0xbf, 0x03, 0x23, 0x32, 0xfd, 0xbc, 0x82, 0x66, 0x86, 0xe6,
	0xc6, 0x16, 0xf4, 0x5a, 0xca, 0x99, 0xd7, 0x6e, 0x8b, 0x27, 0x4b, 0xfa, 0x6a, 0x74, 0x1d, 0xe0,
	0x73, 0x70, 0x94, 0x92, 0xcf, 0xfc, 0x66, 0x8c, 0x6a, 0x41, 0x50, 0x29, 0x06, 0xe6, 0xb5, 0x88,
	0xae, 0x76, 0x15, 0x8e, 0xdf, 0x24, 0x11, 0x97, 0x28, 0x5f, 0x67, 0x60, 0x5c, 0x3a, 0x6a, 0x52,
	0xa3, 0x45, 0x64, 0xa2, 0xc6, 0xa4, 0xed, 0x5d, 0xa3, 0x45, 0x34, 0x03, 0xca, 0xcb, 0x1e, 0x31,
	0x7c, 0xd2, 0x03, 0x5d, 0x85, 0x23, 0xf2, 0x35, 0x81, 0x3a, 0xc0, 0x1e, 0x22, 0xbc, 0x76, 0x0d,
	0xca, 0x2b, 0xc4, 0x25, 0x7d, 0x21, 0x32, 0xb0, 0x5b, 0x84, 0x13, 0xf7, 0xa8, 0x75, 0x40, 0xb0,
	0x05, 0x93, 0x7d, 0x60, 0x79, 0x44, 0xff, 0xe2, 0xee, 0xfe, 0x44, 0x30, 0xb9, 0x97, 0xf9, 0x65,
	0x46, 0x37, 0x1d, 0x3b, 0x3b, 0xc9, 0xa0, 0x44, 0x4d, 0x81, 0x09, 0x8a, 0x2c, 0x3c, 0xd9, 0x91,
	0xd0, 0xb0, 0x6a, 0xe1, 0xfb, 0x30, 0xbc, 0xe5, 0x90, 0xed, 0xca, 0xd0, 0x0c, 0x9a, 0x2b, 0x2d,
	0x2c, 0xa7, 0x72, 0xdc, 0x87, 0x47, 0x2d, 0x7c, 0x7a, 0xcf, 0x21, 0xdb, 0x0d, 0xe1, 0x50, 0x3b,
	0x03, 0xb0, 0x67, 0xc3, 0xa3, 0x70, 0x68, 0xe9, 0xc6, 0xfa, 0xea, 0xf2, 0xb1, 0x97, 0xf0, 0x08,
	0x0c, 0xbf, 0x7d, 0xef, 0xd6, 0xad, 0x63, 0x48, 0x7b, 0x04, 0x27, 0x63, 0xd5, 0x1d, 0xbe, 0xcd,
	0x73, 0x6c, 0x4c, 0x6d, 0xaf, 0x42, 0x6f, 0x7b, 0x29, 0xad, 0x39, 0xa4, 0xb6, 0xa6, 0xf6, 0x04,
	0x41, 0x35, 0x29, 0xb8, 0x3c, 0xbd, 0xeb, 0x70, 0x34, 0x8a, 0x1e, 0xa6, 0x2a, 0xea, 0xb3, 0x89,
	0x78, 0x86, 0xa2, 0x93, 0x2a, 0x71, 0xc5, 0x4b, 0xe6, 0x8e, 0xda, 0x85, 0xaa, 0xd2, 0x19, 0xb9,
	0x8f, 0xb6, 0x0e, 0x25, 0x95, 0xa6, 0x88, 0xb3, 0x0f, 0xcb, 0xa2, 0xc2, 0x52, 0xfb, 0x09, 0xc1,
	0xc9, 0xf5, 0xce, 0x46, 0xcb, 0xf1, 0x43, 0xc3, 0xba, 0x18, 0xdc, 0x39, 0x82, 0x37, 0xa0, 0x28,
	0xeb, 0x2a, 0x9c, 0xf9, 0x32, 0xf6, 0x85, 0xd4, 0x1a, 0x52, 0xe2, 0x8d, 0x9b, 0xb1, 0x27, 0x3c,
	0x0b, 0xc5, 0x2d, 0xc3, 0x75, 0x2c, 0xc3, 0x27, 0x4d, 0x46, 0xdd, 0x1d, 0x71, 0x6e, 0x23, 0x8d,
	0xf1, 0xc8, 0x78, 0x87, 0xba, 0x3b, 0xda, 0xfb, 0x50, 0x4d, 0x22, 0x2e, 0x8f, 0xae, 0x3f, 0x27,
	0x28, 0x73, 0x4e, 0x9e, 0x22, 0x98, 0x52, 0x67, 0x15, 0x73, 0x5d, 0xd6, 0xf1, 0x73, 0x64, 0x65,
	0x09, 0x8e, 0x78, 0x21, 0x48, 0xe6, 0x63, 0x2e, 0x35, 0x1f, 0x51, 0x90, 0x08, 0xa8, 0x3d, 0x53,
	0x8b, 0x53, 0xae, 0xff, 0x4f, 0xad, 0x81, 0x4f, 0xc0, 0xe1, 0x4d, 0xc7, 0xf5, 0x89, 0x57, 0x19,
	0x16, 0x38, 0xf9, 0x14, 0xdc, 0x46, 0x53, 0x89, 0xac, 0x64, 0xe2, 0x57, 0x60, 0x44, 0x6e, 0x20,
	0x6a, 0x96, 0xec, 0x5b, 0xef, 0x22, 0x33, 0xf7, 0xce, 0x87, 0x50, 0x89, 0xdd, 0x46, 0xb9, 0x8f,
	0x69, 0x1a, 0x40, 0x86, 0xdc, 0x9b, 0x8a, 0xa3, 0xd2, 0xb2, 0x6a, 0x69, 0x0f, 0xa0, 0xfc, 0x16,
	0x35, 0x36, 0xdc, 0xfc, 0x77, 0x42, 0xef, 0xad, 0x5e, 0xe8, 0xbb, 0xd5, 0x3f, 0x80, 0x97, 0x57,
	0x1c, 0xfe, 0x1f, 0x39, 0xff, 0x1c, 0xc1, 0xd4, 0x4d, 0x42, 0x03, 0x85, 0xd5, 0x1d, 0x27, 0x6d,
	0xe6, 0x75, 0x53, 0x73, 0x09, 0x80, 0x92, 0x6d, 0xb5, 0x33, 0xca, 0xd1, 0x31, 0x45, 0x1a, 0xaa,
	0x76, 0x83, 0xee, 0x34, 0x46, 0x29, 0xd9, 0x0e, 0x3d, 0x04, 0x20, 0xe6, 0x5a, 0xea, 0x88, 0xd9,
	0x07, 0xc4, 0x5c, 0x4b, 0xf6, 0xd2, 0xdf, 0x08, 0x4e, 0x25, 0x33, 0x91, 0xf5, 0x92, 0x61, 0xbb,
	0x25, 0x28, 0x74, 0x77, 0x59, 0x70, 0x2c, 0x7c, 0x17, 0x4a, 0xe6, 0xc7, 0x06, 0xb5, 0x49, 0xd3,
	0x13, 0xbe, 0x78, 0x65, 0x48, 0x14, 0x5a, 0x86, 0x99, 0x23, 0x60, 0x92, 0x41, 0xd1, 0x8c, 0x3d,
	0x71, 0x7c, 0x1b, 0xc6, 0x2c, 0xc7, 0xb0, 0x29, 0xe3, 0xbe, 0x63, 0xf2, 0xca, 0xb0, 0x70, 0x79,
	0x3e, 0xd5, 0xe5, 0x4a, 0x17, 0xd3, 0x88, 0xe3, 0x17, 0xfe, 0x98, 0x80, 0x92, 0x3c, 0xd9, 0xf0,
	0x46, 0xf7, 0xf0, 0x57, 0x08, 0xc6, 0xe3, 0x42, 0x0e, 0x5f, 0x4e, 0xf5, 0x9e, 0x20, 0x4e, 0xab,
	0x57, 0x72, 0xa2, 0xc2, 0x44, 0x6b, 0xe5, 0x27, 0xbf, 0xff, 0xf5, 0xac, 0x50, 0xc2, 0xe3, 0xb1,
	0x0f, 0x06, 0x8e, 0xbf, 0x45, 0x00, 0x7b, 0x1d, 0x84, 0x17, 0x72, 0x5c, 0xfd, 0x11, 0x9f, 0xbc,
	0x92, 0x46, 0x9b, 0x15, 0x4c, 0xa6, 0xf1, 0x54, 0x9c, 0x89, 0xbe, 0x1b, 0x2f, 0x83, 0xc7, 0xf8,
	0x29, 0x82, 0xa2, 0x32, 0x84, 0x71, 0xfa, 0xbe, 0x93, 0x04, 0x66, 0x75, 0x3a, 0x82, 0xc5, 0xbe,
	0x3e, 0x6a, 0x77, 0xa2, 0xaf, 0x0f, 0x6d, 0x5a, 0x90, 0x99, 0xd4, 0x94, 0xb4, 0xd4, 0x23, 0xd5,
	0x85, 0xbf, 0x40, 0x50, 0x54, 0x44, 0x65, 0x06, 0x1a, 0x49, 0x22, 0x34, 0x8d, 0x86, 0xcc, 0xc9,
	0xfc, 0xc0, 0x9c, 0x3c, 0x47, 0x70, 0xb4, 0x47, 0x69, 0xe2, 0xd7, 0x53, 0xe9, 0x24, 0x0b, 0xdb,
	0x34, 0x42, 0xaf, 0x09, 0x42, 0xe7, 0xb4, 0xb3, 0x03, 0x08, 0xd5, 0x3b, 0xd2, 0x35, 0xfe, 0x19,
	0x01, 0xee, 0x17, 0x52, 0xb8, 0x9e, 0xa7, 0x54, 0x55, 0xe9, 0x57, 0x5d, 0x3c, 0x10, 0x56, 0x16,
	0xfb, 0x79, 0xc1, 0xfe, 0x15, 0x3c, 0x3b, 0x80, 0xbd, 0x2e, 0x35, 0x1d, 0xfe, 0x15, 0xc1, 0xb1,
	0x5e, 0x45, 0x8b, 0xdf, 0x38, 0xa8, 0x08, 0xae, 0x26, 0x49, 0x0c, 0xed, 0x23, 0x41, 0xe8, 0x3e,
	0xd6, 0x33, 0x10, 0xd2, 0x77, 0xbb, 0x4a, 0xfd, 0xf1, 0x83, 0xb3, 0x58, 0x4b, 0x87, 0xe0, 0xef,
	0x10, 0x4c, 0x24, 0x88, 0x48, 0xbc, 0x98, 0xaf, 0x67, 0x32, 0x6c, 0x64, 0x51, 0x6c, 0xe4, 0x8a,
	0x96, 0x25, 0xb3, 0xf5, 0x1e, 0x0d, 0x86, 0xbf, 0x47, 0x80, 0xfb, 0x45, 0x5b, 0x86, 0x32, 0xd9,
	0x57, 0xa2, 0xa6, 0x95, 0xf1, 0x15, 0x41, 0x57, 0xd7, 0xe6, 0xb3, 0xd0, 0xe5, 0x22, 0x4a, 0x1d,
	0xcd, 0xe3, 0x5f, 0xd4, 0x1f, 0x03, 0x91, 0xca, 0xc1, 0xb9, 0x8a, 0xb2, 0x47, 0xb1, 0x55, 0xaf,
	0x1f, 0x0c, 0x2c, 0x4b, 0x5a, 0x36, 0x24, 0x1e, 0xd4, 0x90, 0x7a, 0x57, 0x40, 0xfd, 0x88, 0x94,
	0xef, 0xf4, 0xd0, 0x8c, 0xaf, 0xe5, 0x19, 0xef, 0x8a, 0x9a, 0xaa, 0x66, 0x56, 0x71, 0xda, 0x35,
	0x41, 0xf4, 0x12, 0xbe, 0x98, 0x85, 0xa8, 0xbe, 0xbb, 0x27, 0xc0, 0x1e, 0xe3, 0x1f, 0x50, 0xef,
	0x5f, 0x02, 0x49, 0xfc, 0x7a, 0xce, 0xd9, 0xaf, 0x72, 0xcf, 0x58, 0x23, 0x99, 0x32, 0x5b, 0x8f,
	0xf4, 0x39, 0xfe, 0x0d, 0x41, 0x39, 0x49, 0xda, 0x64, 0x20, 0x3b, 0x40, 0x9b, 0x55, 0xdf, 0x3c,
	0x20, 0x5a, 0x2d, 0x13, 0xed, 0x8c, 0x72, 0x9f, 0xd9, 0x09, 0x90, 0xa0, 0xce, 0xbf, 0x46, 0x50,
	0x54, 0x24, 0x6e, 0x86, 0xeb, 0x2d, 0x49, 0x12, 0xa7, 0xa5, 0xf8, 0x82, 0x60, 0xf5, 0xaa, 0x36,
	0x68, 0x96, 0xd5, 0x89, 0x70, 0x1c, 0xd0, 0x7a, 0x8e, 0xa0, 0xa4, 0xaa, 0x63, 0x7c, 0x35, 0x83,
	0x12, 0xe3, 0xf9, 0x89, 0xd5, 0x04, 0xb1, 0xb9, 0x81, 0xe3, 0xac, 0x6e, 0x85, 0x9e, 0xeb, 0x68,
	0x7e, 0xe9, 0x1b, 0x04, 0xb3, 0x26, 0x6b, 0xa5, 0x91, 0x59, 0x9a, 0x50, 0xb5, 0xdf, 0x5a, 0x20,
	0x8f, 0xd7, 0xd0, 0x83, 0x35, 0x89, 0xb3, 0x99, 0x6b, 0x50, 0xbb, 0xc6, 0x3c, 0x5b, 0xb7, 0x09,
	0x15, 0xe2, 0x59, 0xfe, 0x55, 0x35, 0xda, 0x0e, 0xdf, 0xf7, 0xcf, 0xea, 0x62, 0x9f, 0xf1, 0x45,
	0x61, 0xf8, 0xe6, 0x8d, 0xf5, 0xdb, 0x1b, 0x87, 0x85, 0x8f, 0x4b, 0xff, 0x04, 0x00, 0x00, 0xff,
	0xff, 0xc1, 0x4b, 0xa8, 0xee, 0x2b, 0x16, 0x00, 0x00,
}
