; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -O2 \
; RUN:   -ppc-gpr-icmps=all -ppc-asm-full-reg-names -mcpu=pwr8 < %s | FileCheck %s \
; RUN:  --implicit-check-not cmpw --implicit-check-not cmpd --implicit-check-not cmpl
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -O2 \
; RUN:   -ppc-gpr-icmps=all -ppc-asm-full-reg-names -mcpu=pwr8 < %s | FileCheck %s \
; RUN:  --implicit-check-not cmpw --implicit-check-not cmpd --implicit-check-not cmpl
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -O2 \
; RUN:   -ppc-asm-full-reg-names -mcpu=pwr10 < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -O2 \
; RUN:   -ppc-asm-full-reg-names -mcpu=pwr10 < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -O2 \
; RUN:   -ppc-gpr-icmps=all -ppc-asm-full-reg-names -mcpu=pwr10 < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK-P10-CMP \
; RUN:   --implicit-check-not cmpld --implicit-check-not cmplw
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -O2 \
; RUN:   -ppc-gpr-icmps=all -ppc-asm-full-reg-names -mcpu=pwr10 < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK-P10-CMP \
; RUN:   --implicit-check-not cmpld --implicit-check-not cmplw

define signext i32 @test(i8 zeroext %a, i8 zeroext %b) {
; CHECK-LABEL: test:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrlwi r3, r3, 31
; CHECK-NEXT:    clrlwi r4, r4, 31
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    clrldi r4, r4, 32
; CHECK-NEXT:    sub r3, r4, r3
; CHECK-NEXT:    rldicl r3, r3, 1, 63
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
;
; CHECK-P10-LABEL: test:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    clrlwi r3, r3, 31
; CHECK-P10-NEXT:    clrlwi r4, r4, 31
; CHECK-P10-NEXT:    cmplw r3, r4
; CHECK-P10-NEXT:    setbcr r3, gt
; CHECK-P10-NEXT:    blr
;
; CHECK-P10-CMP-LABEL: test:
; CHECK-P10-CMP:       # %bb.0: # %entry
; CHECK-P10-CMP-NEXT:    clrlwi r3, r3, 31
; CHECK-P10-CMP-NEXT:    clrlwi r4, r4, 31
; CHECK-P10-CMP-NEXT:    clrldi r3, r3, 32
; CHECK-P10-CMP-NEXT:    clrldi r4, r4, 32
; CHECK-P10-CMP-NEXT:    sub r3, r4, r3
; CHECK-P10-CMP-NEXT:    rldicl r3, r3, 1, 63
; CHECK-P10-CMP-NEXT:    xori r3, r3, 1
; CHECK-P10-CMP-NEXT:    blr
entry:
  %0 = and i8 %a, 1
  %1 = and i8 %b, 1
  %cmp = icmp ule i8 %0, %1
  %conv3 = zext i1 %cmp to i32
  ret i32 %conv3
}
