; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; Set pointer (and size_t) size to 32 bits.  This lets the declarations
; below and calls to them be recognized as special.

target datalayout = "p:32:32"

%size_t = type i32
%align_val_t = type %size_t
%nothrow_t = type { }


; operator new(size_t = unsigned int)
declare ptr @_Znwj(%size_t)

; operator new[](size_t = unsigned int)
declare ptr @_Znaj(%size_t)

; operator new(size_t = unsigned int, std::align_val_t)
declare ptr @_ZnwjSt11align_val_t(%size_t, %size_t)

; operator new[](size_t = unsigned int, std::align_val_t)
declare ptr @_ZnajSt11align_val_t(%size_t, %size_t)

; operator new(size_t = unsigned int, std::align_val_t, const std::nothrow_t&)
declare ptr @_ZnwjSt11align_val_tRKSt9nothrow_t(%size_t, %size_t, ptr)

; operator new[](size_t = unsigned int, std::align_val_t, const std::nothrow_t&)
declare ptr @_ZnajSt11align_val_tRKSt9nothrow_t(%size_t, %size_t, ptr)


; operator delete(ptr, size_t = unsigned int)
declare void @_ZdlPvj(ptr, %size_t)

; operator delete[](ptr, size_t = unsigned int)
declare void @_ZdaPvj(ptr, %size_t)

; operator delete(ptr, std::align_val_t)
declare void @_ZdlPvSt11align_val_t(ptr, %align_val_t)

; operator delete[](ptr, std::align_val_t)
declare void @_ZdaPvSt11align_val_t(ptr, %align_val_t)

; operator delete(ptr, size_t = unsigned int, std::align_val_t)
declare void @_ZdlPvjSt11align_val_t(ptr, %size_t, %align_val_t)

; operator delete[](ptr, size_t = unsigned int, std::align_val_t)
declare void @_ZdaPvjSt11align_val_t(ptr, %size_t, %align_val_t)

; operator delete(ptr, std::align_val_t, const std::nothrow_t&)
declare void @_ZdlPvSt11align_val_tRKSt9nothrow_t(ptr, %align_val_t, ptr)

; operator delete[](ptr, std::align_val_t, const std::nothrow_t&)
declare void @_ZdaPvSt11align_val_tRKSt9nothrow_t(ptr, %align_val_t, ptr)

declare void @llvm.assume(i1)


; Verify that pairs of matching calls to new/delete are eliminated.

define void @elim_new_delete_pairs() {
; CHECK-LABEL: @elim_new_delete_pairs(
; CHECK-NEXT:    ret void
;
  %nt = alloca %nothrow_t

  %nwj = call ptr @_Znwj(%size_t 32)
  call void @_ZdlPvj(ptr %nwj, %size_t 32)

  %naj = call ptr @_Znaj(%size_t 32)
  call void @_ZdaPvj(ptr %naj, %size_t 32)

  %nwja = call ptr @_ZnwjSt11align_val_t(%size_t 32, %size_t 8)
  call void @_ZdlPvSt11align_val_t(ptr %nwja, %size_t 8)

  %naja = call ptr @_ZnajSt11align_val_t(%size_t 32, %size_t 8)
  call void @_ZdaPvSt11align_val_t(ptr %naja, i32 8)

  %nwjat = call ptr @_ZnwjSt11align_val_tRKSt9nothrow_t(%size_t 32, %size_t 8, ptr %nt)
  call void @_ZdlPvSt11align_val_tRKSt9nothrow_t(ptr %nwjat, %size_t 8, ptr %nt)

  %najat = call ptr @_ZnajSt11align_val_tRKSt9nothrow_t(%size_t 32, %size_t 8, ptr %nt)
  call void @_ZdaPvSt11align_val_tRKSt9nothrow_t(ptr %najat, i32 8, ptr %nt)

  %nwja2 = call ptr @_ZnwjSt11align_val_t(%size_t 32, %size_t 8)
  call void @_ZdlPvjSt11align_val_t(ptr %nwja2, %size_t 32, %size_t 8)

  %naja2 = call ptr @_ZnajSt11align_val_t(%size_t 32, %size_t 8)
  call void @_ZdaPvjSt11align_val_t(ptr %naja2, %size_t 32, %size_t 8)

  ; Check that the alignment assume does not prevent the removal.
  %nwa3 = call ptr @_ZnajSt11align_val_t(%size_t 32, %size_t 16)

  call void @llvm.assume(i1 true) [ "align"(ptr %nwa3, i32 16) ]

  call void @_ZdaPvjSt11align_val_t(ptr %nwa3, %size_t 32, %size_t 16)

  ret void
}
