; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=dse -S | FileCheck %s

target datalayout = "e-p:64:64:64"

declare void @free(ptr nocapture) allockind("free")
declare noalias ptr @malloc(i64) allockind("alloc,uninitialized")

define void @test(ptr %Q, ptr %P) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    tail call void @free(ptr [[P:%.*]]) [[ATTR0:#.*]]
; CHECK-NEXT:    ret void
;
  %DEAD = load i32, ptr %Q            ; <i32> [#uses=1]
  store i32 %DEAD, ptr %P
  tail call void @free(ptr %P) nounwind
  ret void
}

define void @test2(ptr %P) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    tail call void @free(ptr [[P:%.*]]) [[ATTR0]]
; CHECK-NEXT:    ret void
;
  %Q = getelementptr {i32, i32}, ptr %P, i32 0, i32 1
  store i32 4, ptr %Q
  tail call void @free(ptr %P) nounwind
  ret void
}

define void @test3() {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[M:%.*]] = call ptr @malloc(i64 24)
; CHECK-NEXT:    call void @free(ptr [[M]]) [[ATTR0]]
; CHECK-NEXT:    ret void
;
  %m = call ptr @malloc(i64 24)
  store i8 0, ptr %m
  %m1 = getelementptr i8, ptr %m, i64 1
  store i8 1, ptr %m1
  call void @free(ptr %m) nounwind
  ret void
}

; PR11240
define void @test4(i1 %x) nounwind {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOC1:%.*]] = tail call noalias ptr @malloc(i64 4) [[ATTR0]]
; CHECK-NEXT:    br i1 [[X:%.*]], label [[SKIPINIT1:%.*]], label [[INIT1:%.*]]
; CHECK:       init1:
; CHECK-NEXT:    br label [[SKIPINIT1]]
; CHECK:       skipinit1:
; CHECK-NEXT:    tail call void @free(ptr [[ALLOC1]]) [[ATTR0]]
; CHECK-NEXT:    ret void
;
entry:
  %alloc1 = tail call noalias ptr @malloc(i64 4) nounwind
  br i1 %x, label %skipinit1, label %init1

init1:
  store i8 1, ptr %alloc1
  br label %skipinit1

skipinit1:
  tail call void @free(ptr %alloc1) nounwind
  ret void
}

define void @test5() {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    tail call void @free(ptr undef) [[ATTR0]]
; CHECK-NEXT:    br label [[BB]]
;
  br label %bb

bb:
  tail call void @free(ptr undef) nounwind
  br label %bb
}


%struct  = type { i32 , i32  }

; Test case inspired by PR48036.
define void @delete_field_after(ptr %ptr) {
;
; CHECK-LABEL: @delete_field_after(
; CHECK-NEXT:    [[PTR_F0:%.*]] = getelementptr [[STRUCT:%.*]], ptr [[PTR:%.*]], i32 1
; CHECK-NEXT:    [[PTR_F1:%.*]] = getelementptr [[STRUCT]], ptr [[PTR]], i32 0, i32 1
; CHECK-NEXT:    store i32 0, ptr [[PTR_F1]], align 4
; CHECK-NEXT:    call void @free(ptr [[PTR_F0]])
; CHECK-NEXT:    ret void
;
  %ptr.f0 = getelementptr %struct, ptr %ptr, i32 1
  %ptr.f1 = getelementptr %struct, ptr %ptr, i32 0, i32 1
  store i32 0, ptr %ptr.f1
  call void @free(ptr %ptr.f0)
  ret void
}

; Test case inspired by PR48036.
define void @delete_field_before(ptr %ptr) {
; CHECK-LABEL: @delete_field_before(
; CHECK-NEXT:    call void @free(ptr [[PTR:%.*]])
; CHECK-NEXT:    ret void
;
  %ptr.f1 = getelementptr %struct, ptr %ptr, i32 1, i32 1
  store i32 0, ptr %ptr.f1
  call void @free(ptr %ptr)
  ret void
}
