; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -passes=instsimplify | FileCheck %s

declare i16 @llvm.bswap.i16(i16)
declare <2 x i16> @llvm.bswap.v2i16(<2 x i16>)

define i1 @test1(i16 %arg) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    ret i1 false
;
  %a = or i16 %arg, 1
  %b = call i16 @llvm.bswap.i16(i16 %a)
  %res = icmp eq i16 %b, 0
  ret i1 %res
}

define i1 @test1v(<2 x i16> %arg) {
; CHECK-LABEL: @test1v(
; CHECK-NEXT:    ret i1 false
;
  %a = or <2 x i16> %arg, <i16 1, i16 0>
  %b = call <2 x i16> @llvm.bswap.v2i16(<2 x i16> %a)
  %c = extractelement <2 x i16> %b, i32 0
  %res = icmp eq i16 %c, 0
  ret i1 %res
}

define i1 @test2(i16 %arg) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    ret i1 false
;
  %a = or i16 %arg, 1024
  %b = call i16 @llvm.bswap.i16(i16 %a)
  %res = icmp eq i16 %b, 0
  ret i1 %res
}

define i1 @test2v(<2 x i16> %arg) {
; CHECK-LABEL: @test2v(
; CHECK-NEXT:    ret i1 false
;
  %a = or <2 x i16> %arg, <i16 0, i16 1024>
  %b = call <2 x i16> @llvm.bswap.v2i16(<2 x i16> %a)
  %c = extractelement <2 x i16> %b, i32 1
  %res = icmp eq i16 %c, 0
  ret i1 %res
}

define i1 @test3(i16 %arg) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    ret i1 false
;
  %a = and i16 %arg, 1
  %b = call i16 @llvm.bswap.i16(i16 %a)
  %and = and i16 %b, 1
  %res = icmp eq i16 %and, 1
  ret i1 %res
}

define i1 @test3v(<2 x i16> %arg) {
; CHECK-LABEL: @test3v(
; CHECK-NEXT:    ret i1 false
;
  %a = and <2 x i16> %arg, <i16 1, i16 -1>
  %b = call <2 x i16> @llvm.bswap.v2i16(<2 x i16> %a)
  %c = extractelement <2 x i16> %b, i32 0
  %and = and i16 %c, 1
  %res = icmp eq i16 %and, 1
  ret i1 %res
}

define i1 @test4(i16 %arg) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    ret i1 false
;
  %a = and i16 %arg, 511
  %b = call i16 @llvm.bswap.i16(i16 %a)
  %and = and i16 %b, 256
  %res = icmp eq i16 %and, 1
  ret i1 %res
}

define i1 @test4v(<2 x i16> %arg) {
; CHECK-LABEL: @test4v(
; CHECK-NEXT:    ret i1 false
;
  %a = and <2 x i16> %arg, <i16 511, i16 511>
  %b = call <2 x i16> @llvm.bswap.v2i16(<2 x i16> %a)
  %and = and <2 x i16> %b, <i16 255, i16 256>
  %ext = extractelement <2 x i16> %and, i32 1
  %res = icmp eq i16 %ext, 1
  ret i1 %res
}
