; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs < %s | FileCheck %s

declare i64 @llvm.riscv.vsetvli.i64(i64, i64, i64)
declare i64 @llvm.riscv.vsetvlimax.i64(i64, i64)

define void @test_vsetvli_e8m1(i64 %avl) nounwind {
; CHECK-LABEL: test_vsetvli_e8m1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, a0, e8,m1,ta,mu
; CHECK-NEXT:    ret
  call i64 @llvm.riscv.vsetvli.i64(i64 %avl, i64 0, i64 0)
  ret void
}

define void @test_vsetvli_e16mf4(i64 %avl) nounwind {
; CHECK-LABEL: test_vsetvli_e16mf4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, a0, e16,mf4,ta,mu
; CHECK-NEXT:    ret
  call i64 @llvm.riscv.vsetvli.i64(i64 %avl, i64 1, i64 6)
  ret void
}

define void @test_vsetvli_e32mf8_zero_avl() nounwind {
; CHECK-LABEL: test_vsetvli_e32mf8_zero_avl:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a0, 0, e16,mf4,ta,mu
; CHECK-NEXT:    ret
  call i64 @llvm.riscv.vsetvli.i64(i64 0, i64 1, i64 6)
  ret void
}

define void @test_vsetvlimax_e32m2() nounwind {
; CHECK-LABEL: test_vsetvlimax_e32m2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; CHECK-NEXT:    ret
  call i64 @llvm.riscv.vsetvlimax.i64(i64 2, i64 1)
  ret void
}

define void @test_vsetvlimax_e64m4() nounwind {
; CHECK-LABEL: test_vsetvlimax_e64m4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m4,ta,mu
; CHECK-NEXT:    ret
  call i64 @llvm.riscv.vsetvlimax.i64(i64 3, i64 2)
  ret void
}
