// SPDX-License-Identifier: GPL-2.0-only OR BSD-3-Clause
/* Copyright (C) 2019--2020 Intel Corporation */

#include "ccs-limits.h"
#include "ccs-regs.h"

const struct ccs_limit ccs_limits[] = {
	{ CCS_R_FRAME_FORMAT_MODEL_TYPE, 1, 0, "frame_format_model_type" },
	{ CCS_R_FRAME_FORMAT_MODEL_SUBTYPE, 1, 0, "frame_format_model_subtype" },
	{ CCS_R_FRAME_FORMAT_DESCRIPTOR(0), 30, 0, "frame_format_descriptor" },
	{ CCS_R_FRAME_FORMAT_DESCRIPTOR_4(0), 32, 0, "frame_format_descriptor_4" },
	{ CCS_R_ANALOG_GAIN_CAPABILITY, 2, 0, "analog_gain_capability" },
	{ CCS_R_ANALOG_GAIN_CODE_MIN, 2, 0, "analog_gain_code_min" },
	{ CCS_R_ANALOG_GAIN_CODE_MAX, 2, 0, "analog_gain_code_max" },
	{ CCS_R_ANALOG_GAIN_CODE_STEP, 2, 0, "analog_gain_code_step" },
	{ CCS_R_ANALOG_GAIN_TYPE, 2, 0, "analog_gain_type" },
	{ CCS_R_ANALOG_GAIN_M0, 2, 0, "analog_gain_m0" },
	{ CCS_R_ANALOG_GAIN_C0, 2, 0, "analog_gain_c0" },
	{ CCS_R_ANALOG_GAIN_M1, 2, 0, "analog_gain_m1" },
	{ CCS_R_ANALOG_GAIN_C1, 2, 0, "analog_gain_c1" },
	{ CCS_R_ANALOG_LINEAR_GAIN_MIN, 2, 0, "analog_linear_gain_min" },
	{ CCS_R_ANALOG_LINEAR_GAIN_MAX, 2, 0, "analog_linear_gain_max" },
	{ CCS_R_ANALOG_LINEAR_GAIN_STEP_SIZE, 2, 0, "analog_linear_gain_step_size" },
	{ CCS_R_ANALOG_EXPONENTIAL_GAIN_MIN, 2, 0, "analog_exponential_gain_min" },
	{ CCS_R_ANALOG_EXPONENTIAL_GAIN_MAX, 2, 0, "analog_exponential_gain_max" },
	{ CCS_R_ANALOG_EXPONENTIAL_GAIN_STEP_SIZE, 2, 0, "analog_exponential_gain_step_size" },
	{ CCS_R_DATA_FORMAT_MODEL_TYPE, 1, 0, "data_format_model_type" },
	{ CCS_R_DATA_FORMAT_MODEL_SUBTYPE, 1, 0, "data_format_model_subtype" },
	{ CCS_R_DATA_FORMAT_DESCRIPTOR(0), 32, 0, "data_format_descriptor" },
	{ CCS_R_INTEGRATION_TIME_CAPABILITY, 2, 0, "integration_time_capability" },
	{ CCS_R_COARSE_INTEGRATION_TIME_MIN, 2, 0, "coarse_integration_time_min" },
	{ CCS_R_COARSE_INTEGRATION_TIME_MAX_MARGIN, 2, 0, "coarse_integration_time_max_margin" },
	{ CCS_R_FINE_INTEGRATION_TIME_MIN, 2, 0, "fine_integration_time_min" },
	{ CCS_R_FINE_INTEGRATION_TIME_MAX_MARGIN, 2, 0, "fine_integration_time_max_margin" },
	{ CCS_R_DIGITAL_GAIN_CAPABILITY, 1, 0, "digital_gain_capability" },
	{ CCS_R_DIGITAL_GAIN_MIN, 2, 0, "digital_gain_min" },
	{ CCS_R_DIGITAL_GAIN_MAX, 2, 0, "digital_gain_max" },
	{ CCS_R_DIGITAL_GAIN_STEP_SIZE, 2, 0, "digital_gain_step_size" },
	{ CCS_R_PEDESTAL_CAPABILITY, 1, 0, "Pedestal_capability" },
	{ CCS_R_ADC_CAPABILITY, 1, 0, "ADC_capability" },
	{ CCS_R_ADC_BIT_DEPTH_CAPABILITY, 4, 0, "ADC_bit_depth_capability" },
	{ CCS_R_MIN_EXT_CLK_FREQ_MHZ, 4, 0, "min_ext_clk_freq_mhz" },
	{ CCS_R_MAX_EXT_CLK_FREQ_MHZ, 4, 0, "max_ext_clk_freq_mhz" },
	{ CCS_R_MIN_PRE_PLL_CLK_DIV, 2, 0, "min_pre_pll_clk_div" },
	{ CCS_R_MAX_PRE_PLL_CLK_DIV, 2, 0, "max_pre_pll_clk_div" },
	{ CCS_R_MIN_PLL_IP_CLK_FREQ_MHZ, 4, 0, "min_pll_ip_clk_freq_mhz" },
	{ CCS_R_MAX_PLL_IP_CLK_FREQ_MHZ, 4, 0, "max_pll_ip_clk_freq_mhz" },
	{ CCS_R_MIN_PLL_MULTIPLIER, 2, 0, "min_pll_multiplier" },
	{ CCS_R_MAX_PLL_MULTIPLIER, 2, 0, "max_pll_multiplier" },
	{ CCS_R_MIN_PLL_OP_CLK_FREQ_MHZ, 4, 0, "min_pll_op_clk_freq_mhz" },
	{ CCS_R_MAX_PLL_OP_CLK_FREQ_MHZ, 4, 0, "max_pll_op_clk_freq_mhz" },
	{ CCS_R_MIN_VT_SYS_CLK_DIV, 2, 0, "min_vt_sys_clk_div" },
	{ CCS_R_MAX_VT_SYS_CLK_DIV, 2, 0, "max_vt_sys_clk_div" },
	{ CCS_R_MIN_VT_SYS_CLK_FREQ_MHZ, 4, 0, "min_vt_sys_clk_freq_mhz" },
	{ CCS_R_MAX_VT_SYS_CLK_FREQ_MHZ, 4, 0, "max_vt_sys_clk_freq_mhz" },
	{ CCS_R_MIN_VT_PIX_CLK_FREQ_MHZ, 4, 0, "min_vt_pix_clk_freq_mhz" },
	{ CCS_R_MAX_VT_PIX_CLK_FREQ_MHZ, 4, 0, "max_vt_pix_clk_freq_mhz" },
	{ CCS_R_MIN_VT_PIX_CLK_DIV, 2, 0, "min_vt_pix_clk_div" },
	{ CCS_R_MAX_VT_PIX_CLK_DIV, 2, 0, "max_vt_pix_clk_div" },
	{ CCS_R_CLOCK_CALCULATION, 1, 0, "clock_calculation" },
	{ CCS_R_NUM_OF_VT_LANES, 1, 0, "num_of_vt_lanes" },
	{ CCS_R_NUM_OF_OP_LANES, 1, 0, "num_of_op_lanes" },
	{ CCS_R_OP_BITS_PER_LANE, 1, 0, "op_bits_per_lane" },
	{ CCS_R_MIN_FRAME_LENGTH_LINES, 2, 0, "min_frame_length_lines" },
	{ CCS_R_MAX_FRAME_LENGTH_LINES, 2, 0, "max_frame_length_lines" },
	{ CCS_R_MIN_LINE_LENGTH_PCK, 2, 0, "min_line_length_pck" },
	{ CCS_R_MAX_LINE_LENGTH_PCK, 2, 0, "max_line_length_pck" },
	{ CCS_R_MIN_LINE_BLANKING_PCK, 2, 0, "min_line_blanking_pck" },
	{ CCS_R_MIN_FRAME_BLANKING_LINES, 2, 0, "min_frame_blanking_lines" },
	{ CCS_R_MIN_LINE_LENGTH_PCK_STEP_SIZE, 1, 0, "min_line_length_pck_step_size" },
	{ CCS_R_TIMING_MODE_CAPABILITY, 1, 0, "timing_mode_capability" },
	{ CCS_R_FRAME_MARGIN_MAX_VALUE, 2, 0, "frame_margin_max_value" },
	{ CCS_R_FRAME_MARGIN_MIN_VALUE, 1, 0, "frame_margin_min_value" },
	{ CCS_R_GAIN_DELAY_TYPE, 1, 0, "gain_delay_type" },
	{ CCS_R_MIN_OP_SYS_CLK_DIV, 2, 0, "min_op_sys_clk_div" },
	{ CCS_R_MAX_OP_SYS_CLK_DIV, 2, 0, "max_op_sys_clk_div" },
	{ CCS_R_MIN_OP_SYS_CLK_FREQ_MHZ, 4, 0, "min_op_sys_clk_freq_mhz" },
	{ CCS_R_MAX_OP_SYS_CLK_FREQ_MHZ, 4, 0, "max_op_sys_clk_freq_mhz" },
	{ CCS_R_MIN_OP_PIX_CLK_DIV, 2, 0, "min_op_pix_clk_div" },
	{ CCS_R_MAX_OP_PIX_CLK_DIV, 2, 0, "max_op_pix_clk_div" },
	{ CCS_R_MIN_OP_PIX_CLK_FREQ_MHZ, 4, 0, "min_op_pix_clk_freq_mhz" },
	{ CCS_R_MAX_OP_PIX_CLK_FREQ_MHZ, 4, 0, "max_op_pix_clk_freq_mhz" },
	{ CCS_R_X_ADDR_MIN, 2, 0, "x_addr_min" },
	{ CCS_R_Y_ADDR_MIN, 2, 0, "y_addr_min" },
	{ CCS_R_X_ADDR_MAX, 2, 0, "x_addr_max" },
	{ CCS_R_Y_ADDR_MAX, 2, 0, "y_addr_max" },
	{ CCS_R_MIN_X_OUTPUT_SIZE, 2, 0, "min_x_output_size" },
	{ CCS_R_MIN_Y_OUTPUT_SIZE, 2, 0, "min_y_output_size" },
	{ CCS_R_MAX_X_OUTPUT_SIZE, 2, 0, "max_x_output_size" },
	{ CCS_R_MAX_Y_OUTPUT_SIZE, 2, 0, "max_y_output_size" },
	{ CCS_R_X_ADDR_START_DIV_CONSTANT, 1, 0, "x_addr_start_div_constant" },
	{ CCS_R_Y_ADDR_START_DIV_CONSTANT, 1, 0, "y_addr_start_div_constant" },
	{ CCS_R_X_ADDR_END_DIV_CONSTANT, 1, 0, "x_addr_end_div_constant" },
	{ CCS_R_Y_ADDR_END_DIV_CONSTANT, 1, 0, "y_addr_end_div_constant" },
	{ CCS_R_X_SIZE_DIV, 1, 0, "x_size_div" },
	{ CCS_R_Y_SIZE_DIV, 1, 0, "y_size_div" },
	{ CCS_R_X_OUTPUT_DIV, 1, 0, "x_output_div" },
	{ CCS_R_Y_OUTPUT_DIV, 1, 0, "y_output_div" },
	{ CCS_R_NON_FLEXIBLE_RESOLUTION_SUPPORT, 1, 0, "non_flexible_resolution_support" },
	{ CCS_R_MIN_OP_PRE_PLL_CLK_DIV, 2, 0, "min_op_pre_pll_clk_div" },
	{ CCS_R_MAX_OP_PRE_PLL_CLK_DIV, 2, 0, "max_op_pre_pll_clk_div" },
	{ CCS_R_MIN_OP_PLL_IP_CLK_FREQ_MHZ, 4, 0, "min_op_pll_ip_clk_freq_mhz" },
	{ CCS_R_MAX_OP_PLL_IP_CLK_FREQ_MHZ, 4, 0, "max_op_pll_ip_clk_freq_mhz" },
	{ CCS_R_MIN_OP_PLL_MULTIPLIER, 2, 0, "min_op_pll_multiplier" },
	{ CCS_R_MAX_OP_PLL_MULTIPLIER, 2, 0, "max_op_pll_multiplier" },
	{ CCS_R_MIN_OP_PLL_OP_CLK_FREQ_MHZ, 4, 0, "min_op_pll_op_clk_freq_mhz" },
	{ CCS_R_MAX_OP_PLL_OP_CLK_FREQ_MHZ, 4, 0, "max_op_pll_op_clk_freq_mhz" },
	{ CCS_R_CLOCK_TREE_PLL_CAPABILITY, 1, 0, "clock_tree_pll_capability" },
	{ CCS_R_CLOCK_CAPA_TYPE_CAPABILITY, 1, 0, "clock_capa_type_capability" },
	{ CCS_R_MIN_EVEN_INC, 2, 0, "min_even_inc" },
	{ CCS_R_MIN_ODD_INC, 2, 0, "min_odd_inc" },
	{ CCS_R_MAX_EVEN_INC, 2, 0, "max_even_inc" },
	{ CCS_R_MAX_ODD_INC, 2, 0, "max_odd_inc" },
	{ CCS_R_AUX_SUBSAMP_CAPABILITY, 1, 0, "aux_subsamp_capability" },
	{ CCS_R_AUX_SUBSAMP_MONO_CAPABILITY, 1, 0, "aux_subsamp_mono_capability" },
	{ CCS_R_MONOCHROME_CAPABILITY, 1, 0, "monochrome_capability" },
	{ CCS_R_PIXEL_READOUT_CAPABILITY, 1, 0, "pixel_readout_capability" },
	{ CCS_R_MIN_EVEN_INC_MONO, 2, 0, "min_even_inc_mono" },
	{ CCS_R_MAX_EVEN_INC_MONO, 2, 0, "max_even_inc_mono" },
	{ CCS_R_MIN_ODD_INC_MONO, 2, 0, "min_odd_inc_mono" },
	{ CCS_R_MAX_ODD_INC_MONO, 2, 0, "max_odd_inc_mono" },
	{ CCS_R_MIN_EVEN_INC_BC2, 2, 0, "min_even_inc_bc2" },
	{ CCS_R_MAX_EVEN_INC_BC2, 2, 0, "max_even_inc_bc2" },
	{ CCS_R_MIN_ODD_INC_BC2, 2, 0, "min_odd_inc_bc2" },
	{ CCS_R_MAX_ODD_INC_BC2, 2, 0, "max_odd_inc_bc2" },
	{ CCS_R_MIN_EVEN_INC_MONO_BC2, 2, 0, "min_even_inc_mono_bc2" },
	{ CCS_R_MAX_EVEN_INC_MONO_BC2, 2, 0, "max_even_inc_mono_bc2" },
	{ CCS_R_MIN_ODD_INC_MONO_BC2, 2, 0, "min_odd_inc_mono_bc2" },
	{ CCS_R_MAX_ODD_INC_MONO_BC2, 2, 0, "max_odd_inc_mono_bc2" },
	{ CCS_R_SCALING_CAPABILITY, 2, 0, "scaling_capability" },
	{ CCS_R_SCALER_M_MIN, 2, 0, "scaler_m_min" },
	{ CCS_R_SCALER_M_MAX, 2, 0, "scaler_m_max" },
	{ CCS_R_SCALER_N_MIN, 2, 0, "scaler_n_min" },
	{ CCS_R_SCALER_N_MAX, 2, 0, "scaler_n_max" },
	{ CCS_R_DIGITAL_CROP_CAPABILITY, 1, 0, "digital_crop_capability" },
	{ CCS_R_HDR_CAPABILITY_1, 1, 0, "hdr_capability_1" },
	{ CCS_R_MIN_HDR_BIT_DEPTH, 1, 0, "min_hdr_bit_depth" },
	{ CCS_R_HDR_RESOLUTION_SUB_TYPES, 1, 0, "hdr_resolution_sub_types" },
	{ CCS_R_HDR_RESOLUTION_SUB_TYPE(0), 2, 0, "hdr_resolution_sub_type" },
	{ CCS_R_HDR_CAPABILITY_2, 1, 0, "hdr_capability_2" },
	{ CCS_R_MAX_HDR_BIT_DEPTH, 1, 0, "max_hdr_bit_depth" },
	{ CCS_R_USL_SUPPORT_CAPABILITY, 1, 0, "usl_support_capability" },
	{ CCS_R_USL_CLOCK_MODE_D_CAPABILITY, 1, 0, "usl_clock_mode_d_capability" },
	{ CCS_R_MIN_OP_SYS_CLK_DIV_REV, 1, 0, "min_op_sys_clk_div_rev" },
	{ CCS_R_MAX_OP_SYS_CLK_DIV_REV, 1, 0, "max_op_sys_clk_div_rev" },
	{ CCS_R_MIN_OP_PIX_CLK_DIV_REV, 1, 0, "min_op_pix_clk_div_rev" },
	{ CCS_R_MAX_OP_PIX_CLK_DIV_REV, 1, 0, "max_op_pix_clk_div_rev" },
	{ CCS_R_MIN_OP_SYS_CLK_FREQ_REV_MHZ, 4, 0, "min_op_sys_clk_freq_rev_mhz" },
	{ CCS_R_MAX_OP_SYS_CLK_FREQ_REV_MHZ, 4, 0, "max_op_sys_clk_freq_rev_mhz" },
	{ CCS_R_MIN_OP_PIX_CLK_FREQ_REV_MHZ, 4, 0, "min_op_pix_clk_freq_rev_mhz" },
	{ CCS_R_MAX_OP_PIX_CLK_FREQ_REV_MHZ, 4, 0, "max_op_pix_clk_freq_rev_mhz" },
	{ CCS_R_MAX_BITRATE_REV_D_MODE_MBPS, 4, 0, "max_bitrate_rev_d_mode_mbps" },
	{ CCS_R_MAX_SYMRATE_REV_C_MODE_MSPS, 4, 0, "max_symrate_rev_c_mode_msps" },
	{ CCS_R_COMPRESSION_CAPABILITY, 1, 0, "compression_capability" },
	{ CCS_R_TEST_MODE_CAPABILITY, 2, 0, "test_mode_capability" },
	{ CCS_R_PN9_DATA_FORMAT1, 1, 0, "pn9_data_format1" },
	{ CCS_R_PN9_DATA_FORMAT2, 1, 0, "pn9_data_format2" },
	{ CCS_R_PN9_DATA_FORMAT3, 1, 0, "pn9_data_format3" },
	{ CCS_R_PN9_DATA_FORMAT4, 1, 0, "pn9_data_format4" },
	{ CCS_R_PN9_MISC_CAPABILITY, 1, 0, "pn9_misc_capability" },
	{ CCS_R_TEST_PATTERN_CAPABILITY, 1, 0, "test_pattern_capability" },
	{ CCS_R_PATTERN_SIZE_DIV_M1, 1, 0, "pattern_size_div_m1" },
	{ CCS_R_FIFO_SUPPORT_CAPABILITY, 1, 0, "fifo_support_capability" },
	{ CCS_R_PHY_CTRL_CAPABILITY, 1, 0, "phy_ctrl_capability" },
	{ CCS_R_CSI_DPHY_LANE_MODE_CAPABILITY, 1, 0, "csi_dphy_lane_mode_capability" },
	{ CCS_R_CSI_SIGNALING_MODE_CAPABILITY, 1, 0, "csi_signaling_mode_capability" },
	{ CCS_R_FAST_STANDBY_CAPABILITY, 1, 0, "fast_standby_capability" },
	{ CCS_R_CSI_ADDRESS_CONTROL_CAPABILITY, 1, 0, "csi_address_control_capability" },
	{ CCS_R_DATA_TYPE_CAPABILITY, 1, 0, "data_type_capability" },
	{ CCS_R_CSI_CPHY_LANE_MODE_CAPABILITY, 1, 0, "csi_cphy_lane_mode_capability" },
	{ CCS_R_EMB_DATA_CAPABILITY, 1, 0, "emb_data_capability" },
	{ CCS_R_MAX_PER_LANE_BITRATE_LANE_D_MODE_MBPS(0), 16, 0, "max_per_lane_bitrate_lane_d_mode_mbps 0" },
	{ CCS_R_MAX_PER_LANE_BITRATE_LANE_D_MODE_MBPS(4), 16, CCS_L_FL_SAME_REG, "max_per_lane_bitrate_lane_d_mode_mbps 4" },
	{ CCS_R_TEMP_SENSOR_CAPABILITY, 1, 0, "temp_sensor_capability" },
	{ CCS_R_MAX_PER_LANE_BITRATE_LANE_C_MODE_MBPS(0), 16, 0, "max_per_lane_bitrate_lane_c_mode_mbps 0" },
	{ CCS_R_MAX_PER_LANE_BITRATE_LANE_C_MODE_MBPS(4), 16, CCS_L_FL_SAME_REG, "max_per_lane_bitrate_lane_c_mode_mbps 4" },
	{ CCS_R_DPHY_EQUALIZATION_CAPABILITY, 1, 0, "dphy_equalization_capability" },
	{ CCS_R_CPHY_EQUALIZATION_CAPABILITY, 1, 0, "cphy_equalization_capability" },
	{ CCS_R_DPHY_PREAMBLE_CAPABILITY, 1, 0, "dphy_preamble_capability" },
	{ CCS_R_DPHY_SSC_CAPABILITY, 1, 0, "dphy_ssc_capability" },
	{ CCS_R_CPHY_CALIBRATION_CAPABILITY, 1, 0, "cphy_calibration_capability" },
	{ CCS_R_DPHY_CALIBRATION_CAPABILITY, 1, 0, "dphy_calibration_capability" },
	{ CCS_R_PHY_CTRL_CAPABILITY_2, 1, 0, "phy_ctrl_capability_2" },
	{ CCS_R_LRTE_CPHY_CAPABILITY, 1, 0, "lrte_cphy_capability" },
	{ CCS_R_LRTE_DPHY_CAPABILITY, 1, 0, "lrte_dphy_capability" },
	{ CCS_R_ALPS_CAPABILITY_DPHY, 1, 0, "alps_capability_dphy" },
	{ CCS_R_ALPS_CAPABILITY_CPHY, 1, 0, "alps_capability_cphy" },
	{ CCS_R_SCRAMBLING_CAPABILITY, 1, 0, "scrambling_capability" },
	{ CCS_R_DPHY_MANUAL_CONSTANT, 1, 0, "dphy_manual_constant" },
	{ CCS_R_CPHY_MANUAL_CONSTANT, 1, 0, "cphy_manual_constant" },
	{ CCS_R_CSI2_INTERFACE_CAPABILITY_MISC, 1, 0, "CSI2_interface_capability_misc" },
	{ CCS_R_PHY_CTRL_CAPABILITY_3, 1, 0, "PHY_ctrl_capability_3" },
	{ CCS_R_DPHY_SF, 1, 0, "dphy_sf" },
	{ CCS_R_CPHY_SF, 1, 0, "cphy_sf" },
	{ CCS_R_DPHY_LIMITS_1, 1, 0, "dphy_limits_1" },
	{ CCS_R_DPHY_LIMITS_2, 1, 0, "dphy_limits_2" },
	{ CCS_R_DPHY_LIMITS_3, 1, 0, "dphy_limits_3" },
	{ CCS_R_DPHY_LIMITS_4, 1, 0, "dphy_limits_4" },
	{ CCS_R_DPHY_LIMITS_5, 1, 0, "dphy_limits_5" },
	{ CCS_R_DPHY_LIMITS_6, 1, 0, "dphy_limits_6" },
	{ CCS_R_CPHY_LIMITS_1, 1, 0, "cphy_limits_1" },
	{ CCS_R_CPHY_LIMITS_2, 1, 0, "cphy_limits_2" },
	{ CCS_R_CPHY_LIMITS_3, 1, 0, "cphy_limits_3" },
	{ CCS_R_MIN_FRAME_LENGTH_LINES_BIN, 2, 0, "min_frame_length_lines_bin" },
	{ CCS_R_MAX_FRAME_LENGTH_LINES_BIN, 2, 0, "max_frame_length_lines_bin" },
	{ CCS_R_MIN_LINE_LENGTH_PCK_BIN, 2, 0, "min_line_length_pck_bin" },
	{ CCS_R_MAX_LINE_LENGTH_PCK_BIN, 2, 0, "max_line_length_pck_bin" },
	{ CCS_R_MIN_LINE_BLANKING_PCK_BIN, 2, 0, "min_line_blanking_pck_bin" },
	{ CCS_R_FINE_INTEGRATION_TIME_MIN_BIN, 2, 0, "fine_integration_time_min_bin" },
	{ CCS_R_FINE_INTEGRATION_TIME_MAX_MARGIN_BIN, 2, 0, "fine_integration_time_max_margin_bin" },
	{ CCS_R_BINNING_CAPABILITY, 1, 0, "binning_capability" },
	{ CCS_R_BINNING_WEIGHTING_CAPABILITY, 1, 0, "binning_weighting_capability" },
	{ CCS_R_BINNING_SUB_TYPES, 1, 0, "binning_sub_types" },
	{ CCS_R_BINNING_SUB_TYPE(0), 64, 0, "binning_sub_type" },
	{ CCS_R_BINNING_WEIGHTING_MONO_CAPABILITY, 1, 0, "binning_weighting_mono_capability" },
	{ CCS_R_BINNING_SUB_TYPES_MONO, 1, 0, "binning_sub_types_mono" },
	{ CCS_R_BINNING_SUB_TYPE_MONO(0), 64, 0, "binning_sub_type_mono" },
	{ CCS_R_DATA_TRANSFER_IF_CAPABILITY, 1, 0, "data_transfer_if_capability" },
	{ CCS_R_SHADING_CORRECTION_CAPABILITY, 1, 0, "shading_correction_capability" },
	{ CCS_R_GREEN_IMBALANCE_CAPABILITY, 1, 0, "green_imbalance_capability" },
	{ CCS_R_MODULE_SPECIFIC_CORRECTION_CAPABILITY, 1, 0, "module_specific_correction_capability" },
	{ CCS_R_DEFECT_CORRECTION_CAPABILITY, 2, 0, "defect_correction_capability" },
	{ CCS_R_DEFECT_CORRECTION_CAPABILITY_2, 2, 0, "defect_correction_capability_2" },
	{ CCS_R_NF_CAPABILITY, 1, 0, "nf_capability" },
	{ CCS_R_OB_READOUT_CAPABILITY, 1, 0, "ob_readout_capability" },
	{ CCS_R_COLOR_FEEDBACK_CAPABILITY, 1, 0, "color_feedback_capability" },
	{ CCS_R_CFA_PATTERN_CAPABILITY, 1, 0, "CFA_pattern_capability" },
	{ CCS_R_CFA_PATTERN_CONVERSION_CAPABILITY, 1, 0, "CFA_pattern_conversion_capability" },
	{ CCS_R_FLASH_MODE_CAPABILITY, 1, 0, "flash_mode_capability" },
	{ CCS_R_SA_STROBE_MODE_CAPABILITY, 1, 0, "sa_strobe_mode_capability" },
	{ CCS_R_RESET_MAX_DELAY, 1, 0, "reset_max_delay" },
	{ CCS_R_RESET_MIN_TIME, 1, 0, "reset_min_time" },
	{ CCS_R_PDAF_CAPABILITY_1, 1, 0, "pdaf_capability_1" },
	{ CCS_R_PDAF_CAPABILITY_2, 1, 0, "pdaf_capability_2" },
	{ CCS_R_BRACKETING_LUT_CAPABILITY_1, 1, 0, "bracketing_lut_capability_1" },
	{ CCS_R_BRACKETING_LUT_CAPABILITY_2, 1, 0, "bracketing_lut_capability_2" },
	{ CCS_R_BRACKETING_LUT_SIZE, 1, 0, "bracketing_lut_size" },
	{ 0 } /* Guardian */
};
