/*
 * Decompiled with CFR 0.152.
 */
package wrappers;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import wrappers.ApacheInterface;
import wrappers.JdbcInterface;
import wrappers.MariadbInterface;
import wrappers.MysqlInterface;
import wrappers.OracleInterface;
import wrappers.PostgresqlInterface;

public class Client {
    static boolean DEBUG = true;
    static final Console c = System.console();
    static JdbcInterface jdi = null;

    public static void main(String[] args) {
        int i = 0;
        int fsize = 0;
        boolean scrollable = false;
        String[] parms = new String[4];
        if (args.length > 0) {
            try {
                i = Integer.parseInt(args[i]);
            }
            catch (NumberFormatException e) {
                i = 0;
            }
        }
        switch (i) {
            case 1: {
                jdi = new ApacheInterface(DEBUG);
                break;
            }
            case 2: {
                jdi = new MysqlInterface(DEBUG);
                break;
            }
            case 3: {
                jdi = new MariadbInterface(DEBUG);
                break;
            }
            case 4: {
                jdi = new OracleInterface(DEBUG);
                break;
            }
            case 5: {
                jdi = new PostgresqlInterface(DEBUG);
                break;
            }
            default: {
                jdi = new JdbcInterface(DEBUG);
            }
        }
        parms[0] = Client.getLine("Driver: ", false);
        parms[1] = Client.getLine("URL: ", false);
        parms[2] = Client.getLine("User: ", false);
        parms[3] = Client.getLine("Password: ", true);
        String s = Client.getLine("Fsize: ", false);
        fsize = s != null ? Integer.parseInt(s) : 0;
        s = Client.getLine("Scrollable: ", false);
        scrollable = s != null ? s.toLowerCase().charAt(0) != 'n' : false;
        int rc = jdi.JdbcConnect(parms, fsize, scrollable);
        if (rc == 0) {
            String query;
            System.out.println("Successfully connected to " + parms[1]);
            s = jdi.GetQuoteString();
            System.out.println("Qstr = '" + s + "'");
            while ((query = Client.getLine("Query: ", false)) != null) {
                int n = jdi.Execute(query);
                System.out.println("Returned n = " + n);
                int ncol = jdi.GetResult();
                if (ncol > 0) {
                    Client.PrintResult(ncol);
                    continue;
                }
                System.out.println("Affected rows = " + n);
            }
            rc = jdi.JdbcDisconnect();
            System.out.println("Disconnect returned " + rc);
        } else {
            System.out.println(String.valueOf(jdi.GetErrmsg()) + " rc=" + rc);
        }
    }

    private static void PrintResult(int ncol) {
        Date date = new Date(0L);
        Time time = new Time(0L);
        Timestamp tsp = new Timestamp(0L);
        int i = 1;
        while (i <= ncol) {
            String columnName = jdi.ColumnName(i);
            if (columnName == null) {
                return;
            }
            if (i > 1) {
                System.out.print("\t");
            }
            System.out.print(columnName);
            ++i;
        }
        System.out.println();
        while (jdi.ReadNext() > 0) {
            i = 1;
            while (i <= ncol) {
                if (i > 1) {
                    System.out.print("\t");
                }
                if (DEBUG) {
                    System.out.print("(" + jdi.ColumnType(i, null) + ")");
                }
                switch (jdi.ColumnType(i, null)) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 1111: {
                        System.out.print(jdi.StringField(i, null));
                        break;
                    }
                    case 4: {
                        System.out.print(jdi.IntField(i, null));
                        break;
                    }
                    case -5: {
                        System.out.print(jdi.BigintField(i, null));
                        break;
                    }
                    case 92: {
                        time.setTime((long)jdi.TimeField(i, null) * 1000L);
                        System.out.print(time);
                        break;
                    }
                    case 91: {
                        date.setTime((long)jdi.DateField(i, null) * 1000L);
                        System.out.print(date);
                        break;
                    }
                    case 93: {
                        tsp.setTime((long)jdi.TimestampField(i, null) * 1000L);
                        System.out.print(tsp);
                        break;
                    }
                    case 5: {
                        System.out.print(jdi.IntField(i, null));
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        System.out.print(jdi.DoubleField(i, null));
                        break;
                    }
                    case 16: {
                        System.out.print(jdi.BooleanField(i, null));
                    }
                    default: {
                        Object job = jdi.ObjectField(i, null);
                        System.out.print(job.toString());
                    }
                }
                ++i;
            }
            System.out.println();
        }
    }

    private static String getLine(String p, boolean b) {
        String response;
        if (c != null) {
            response = b ? new String(c.readPassword(p, new Object[0])) : c.readLine(p, new Object[0]);
        } else {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(p);
            try {
                response = in.readLine();
            }
            catch (IOException e) {
                response = "";
            }
        }
        return response.isEmpty() ? null : response;
    }
}

