/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.MariaDbConnection;

public class CallableParameterMetaData
implements ParameterMetaData {
    private static Pattern PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?([\\w\\d]+)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    private static Pattern RETURN_PATTERN = Pattern.compile("\\s*(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*(CHARSET\\s+)?(\\w+)?\\s*", 2);
    private List<CallParameter> params = null;
    private MariaDbConnection con;
    private String database;
    private String name;
    private boolean valid;
    private boolean isFunction;

    public CallableParameterMetaData(MariaDbConnection con, String database, String name, boolean isFunction) {
        this.con = con;
        this.database = database != null ? database.replace("`", "") : null;
        this.name = name.replace("`", "");
        this.isFunction = isFunction;
    }

    public void readMetadataFromDbIfRequired() throws SQLException {
        if (this.valid) {
            return;
        }
        this.readMetadata();
        this.valid = true;
    }

    int mapMariaDbTypeToJdbc(String str) {
        switch (str = str.toUpperCase()) {
            case "BIT": {
                return -7;
            }
            case "TINYINT": {
                return -6;
            }
            case "SMALLINT": {
                return 5;
            }
            case "MEDIUMINT": {
                return 4;
            }
            case "INT": {
                return 4;
            }
            case "INTEGER": {
                return 4;
            }
            case "LONG": {
                return 4;
            }
            case "BIGINT": {
                return -5;
            }
            case "INT24": {
                return 4;
            }
            case "REAL": {
                return 8;
            }
            case "FLOAT": {
                return 6;
            }
            case "DECIMAL": {
                return 3;
            }
            case "NUMERIC": {
                return 2;
            }
            case "DOUBLE": {
                return 8;
            }
            case "CHAR": {
                return 1;
            }
            case "VARCHAR": {
                return 12;
            }
            case "DATE": {
                return 91;
            }
            case "TIME": {
                return 92;
            }
            case "YEAR": {
                return 5;
            }
            case "TIMESTAMP": {
                return 93;
            }
            case "DATETIME": {
                return 93;
            }
            case "TINYBLOB": {
                return -2;
            }
            case "BLOB": {
                return -4;
            }
            case "MEDIUMBLOB": {
                return -4;
            }
            case "LONGBLOB": {
                return -4;
            }
            case "TINYTEXT": {
                return 12;
            }
            case "TEXT": {
                return -1;
            }
            case "MEDIUMTEXT": {
                return -1;
            }
            case "LONGTEXT": {
                return -1;
            }
            case "ENUM": {
                return 12;
            }
            case "SET": {
                return 12;
            }
            case "GEOMETRY": {
                return -4;
            }
            case "VARBINARY": {
                return -3;
            }
        }
        return 1111;
    }

    private String[] queryMetaInfos(boolean isFunction) throws SQLException {
        PreparedStatement preparedStatement = this.database != null ? this.con.prepareStatement("select param_list, returns, db, type from mysql.proc where db=? and name=?") : this.con.prepareStatement("select param_list, returns, db, type from mysql.proc where db=DATABASE() and name=?");
        ResultSet rs = null;
        try {
            if (this.database == null) {
                preparedStatement.setString(1, this.name);
            } else {
                preparedStatement.setString(1, this.database);
                preparedStatement.setString(2, this.name);
            }
            rs = preparedStatement.executeQuery();
            if (!rs.next()) {
                throw new SQLException((isFunction ? "function" : "procedure") + " `" + this.name + "` does not exist");
            }
            String paramList = rs.getString(1);
            String functionReturn = rs.getString(2);
            this.database = rs.getString(3);
            this.isFunction = "FUNCTION".equals(rs.getString(4));
            String[] stringArray = new String[]{paramList, functionReturn};
            return stringArray;
        }
        catch (SQLSyntaxErrorException sqlSyntaxErrorException) {
            throw new SQLException("Access to metaData informations not granted for current user. Consider grant select access to mysql.proc  or avoid using parameter by name", sqlSyntaxErrorException);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            preparedStatement.close();
        }
    }

    private void parseFunctionReturnParam(String functionReturn) throws SQLException {
        if (functionReturn == null || functionReturn.length() == 0) {
            throw new SQLException(this.name + "is not a function returning value");
        }
        Matcher matcher = RETURN_PATTERN.matcher(functionReturn);
        if (!matcher.matches()) {
            throw new SQLException("can not parse return value definition :" + functionReturn);
        }
        CallParameter callParameter = this.params.get(0);
        callParameter.isOutput = true;
        callParameter.isSigned = matcher.group(1) == null;
        callParameter.typeName = matcher.group(2).trim();
        callParameter.sqlType = this.mapMariaDbTypeToJdbc(callParameter.typeName);
        String scale = matcher.group(3);
        if (scale != null) {
            scale = scale.replace("(", "").replace(")", "").replace(" ", "");
            callParameter.scale = Integer.valueOf(scale);
        }
    }

    private void parseParamList(boolean isFunction, String paramList) throws SQLException {
        this.params = new ArrayList<CallParameter>();
        if (isFunction) {
            this.params.add(new CallParameter());
        }
        Matcher matcher2 = PARAMETER_PATTERN.matcher(paramList);
        while (matcher2.find()) {
            CallParameter callParameter = new CallParameter();
            String direction = matcher2.group(1);
            if (direction != null) {
                direction = direction.trim();
            }
            callParameter.name = matcher2.group(2).trim();
            callParameter.isSigned = matcher2.group(3) == null;
            callParameter.typeName = matcher2.group(4).trim().toUpperCase();
            if (direction == null || direction.equalsIgnoreCase("IN")) {
                callParameter.isInput = true;
            } else if (direction.equalsIgnoreCase("OUT")) {
                callParameter.isOutput = true;
            } else if (direction.equalsIgnoreCase("INOUT")) {
                callParameter.isOutput = true;
                callParameter.isInput = true;
            } else {
                throw new SQLException("unknown parameter direction " + direction + "for " + callParameter.name);
            }
            callParameter.sqlType = this.mapMariaDbTypeToJdbc(callParameter.typeName);
            String scale = matcher2.group(5);
            if (scale != null) {
                if ((scale = scale.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                    scale = scale.substring(0, scale.indexOf(","));
                }
                callParameter.scale = Integer.valueOf(scale);
            }
            this.params.add(callParameter);
        }
    }

    public void readMetadata() throws SQLException {
        if (this.valid) {
            return;
        }
        String[] metaInfos = this.queryMetaInfos(this.isFunction);
        String paramList = metaInfos[0];
        String functionReturn = metaInfos[1];
        this.parseParamList(this.isFunction, paramList);
        if (this.isFunction) {
            this.parseFunctionReturnParam(functionReturn);
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.params.size();
    }

    CallParameter getParam(int index) throws SQLException {
        if (index < 1 || index > this.params.size()) {
            throw new SQLException("invalid parameter index " + index);
        }
        this.readMetadataFromDbIfRequired();
        return this.params.get(index - 1);
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getParam((int)param).isNullable;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParam((int)param).isSigned;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParam((int)param).precision;
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParam((int)param).scale;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParam((int)param).sqlType;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParam((int)param).typeName;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParam((int)param).className;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        CallParameter callParameter = this.getParam(param);
        if (callParameter.isInput && callParameter.isOutput) {
            return 2;
        }
        if (callParameter.isInput) {
            return 1;
        }
        if (callParameter.isOutput) {
            return 4;
        }
        return 0;
    }

    public String getName(int param) throws SQLException {
        return this.getParam((int)param).name;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String getDatabase() throws SQLException {
        this.readMetadataFromDbIfRequired();
        return this.database;
    }
}

