/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.api.x;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;

public interface Statement<STMT_T, RES_T> {
    public RES_T execute();

    public CompletableFuture<RES_T> executeAsync();

    default public STMT_T clearBindings() {
        throw new UnsupportedOperationException("This statement doesn't support bound parameters");
    }

    default public STMT_T bind(String argName, Object value) {
        throw new UnsupportedOperationException("This statement doesn't support bound parameters");
    }

    default public STMT_T bind(Map<String, Object> values) {
        this.clearBindings();
        values.entrySet().forEach(e2 -> this.bind((String)e2.getKey(), e2.getValue()));
        return (STMT_T)this;
    }

    default public STMT_T bind(List<Object> values) {
        this.clearBindings();
        IntStream.range(0, values.size()).forEach(i2 -> this.bind(String.valueOf(i2), values.get(i2)));
        return (STMT_T)this;
    }

    default public STMT_T bind(Object ... values) {
        return this.bind(Arrays.asList(values));
    }
}

