/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.sql.ANYDATA;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    boolean atLeastOneOrdinalParameter = false;
    boolean atLeastOneNamedParameter = false;
    String[] namedParameters = new String[8];
    int parameterCount = 0;
    final String errMsgMixedBind = "Ordinal binding and Named binding cannot be combined!";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    OracleCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        this(physicalConnection, string, n2, n3, 1003, 1007);
    }

    OracleCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3, int n4, int n5) throws SQLException {
        super(physicalConnection, string, 1, n3, n4, n5);
        this.statementType = 2;
    }

    void registerOutParameterInternal(int n2, int n3, int n4, int n5, String string) throws SQLException {
        int n6 = n2 - 1;
        if (n6 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n3 == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n7 = this.getInternalType(n3);
        this.resetBatch();
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        switch (n3) {
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 70: {
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                this.currentRowFormOfUse[n6] = 2;
                break;
            }
            case 2011: {
                n5 = 0;
                this.currentRowFormOfUse[n6] = 2;
                break;
            }
            case 2009: {
                n5 = 0;
                string = "SYS.XMLTYPE";
                break;
            }
            default: {
                n5 = 0;
            }
        }
        this.currentRowBindAccessors[n6] = this.allocateAccessor(n7, n3, n6 + 1, n5, this.currentRowFormOfUse[n6], string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "empty Object name");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.registerOutParameterInternal(n2, n3, 0, 0, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameterBytes(int n2, int n3, int n4, int n5) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.registerOutParameterInternal(n2, n3, n4, n5, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameterChars(int n2, int n3, int n4, int n5) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.registerOutParameterInternal(n2, n3, n4, n5, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n2, int n3, int n4, int n5) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.registerOutParameterInternal(n2, n3, n4, n5, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(String string, int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.registerOutParameterInternal(string, n2, n3, n4, null);
        }
    }

    @Override
    boolean isOracleBatchStyle() {
        return false;
    }

    @Override
    void resetBatch() {
        this.batch = 1;
    }

    @Override
    public void setExecuteBatch(int n2) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.validRows;
        }
    }

    @Override
    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.registerOutParameter(n2, n3, 0, -1);
    }

    @Override
    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.registerOutParameter(n2, n3, n4, -1);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNullValue();
    }

    @Override
    public String getString(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getString(this.currentRank);
    }

    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getOracleObject(this.currentRank);
    }

    @Override
    public ROWID getROWID(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getROWID(this.currentRank);
    }

    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getNUMBER(this.currentRank);
    }

    @Override
    public DATE getDATE(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDATE(this.currentRank);
    }

    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getINTERVALYM(this.currentRank);
    }

    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getINTERVALDS(this.currentRank);
    }

    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTIMESTAMP(this.currentRank);
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTIMESTAMPTZ(this.currentRank);
    }

    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTIMESTAMPLTZ(this.currentRank);
    }

    @Override
    public REF getREF(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getREF(this.currentRank);
    }

    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getARRAY(this.currentRank);
    }

    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getSTRUCT(this.currentRank);
    }

    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getOPAQUE(this.currentRank);
    }

    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCHAR(this.currentRank);
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCharacterStream(this.currentRank);
    }

    @Override
    public RAW getRAW(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getRAW(this.currentRank);
    }

    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBLOB(this.currentRank);
    }

    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCLOB(this.currentRank);
    }

    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBFILE(this.currentRank);
    }

    @Override
    public BFILE getBfile(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBFILE(this.currentRank);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBoolean(this.currentRank);
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getByte(this.currentRank);
    }

    @Override
    public short getShort(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getShort(this.currentRank);
    }

    @Override
    public int getInt(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getInt(this.currentRank);
    }

    @Override
    public long getLong(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getLong(this.currentRank);
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getFloat(this.currentRank);
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDouble(this.currentRank);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBigDecimal(this.currentRank);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBytes(this.currentRank);
    }

    @Override
    public byte[] privateGetBytes(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.privateGetBytes(this.currentRank);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDate(this.currentRank);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTime(this.currentRank);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTimestamp(this.currentRank);
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getAsciiStream(this.currentRank);
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getUnicodeStream(this.currentRank);
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBinaryStream(this.currentRank);
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getObject(this.currentRank);
    }

    @Override
    public Object getAnyDataEmbeddedObject(int n2) throws SQLException {
        Datum datum;
        Object object = null;
        Object object2 = this.getObject(n2);
        if (object2 instanceof ANYDATA && (datum = ((ANYDATA)object2).accessDatum()) != null) {
            object = datum.toJdbc();
        }
        return object;
    }

    @Override
    public Object getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCustomDatum(this.currentRank, customDatumFactory);
    }

    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getObject(this.currentRank, oracleDataFactory);
    }

    @Override
    public Object getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getORAData(this.currentRank, oRADataFactory);
    }

    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCursor(this.currentRank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.clearParameters();
        }
    }

    public Object getObject(int n2, Map map) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getObject(this.currentRank, map);
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getREF(this.currentRank);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBLOB(this.currentRank);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCLOB(this.currentRank);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getARRAY(this.currentRank);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBigDecimal(this.currentRank);
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDate(this.currentRank, calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTime(this.currentRank, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTimestamp(this.currentRank, calendar);
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.currentRowBindAccessors != null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Stored procedure with out or inout parameters cannot be batched");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        super.addBatch();
    }

    @Override
    protected void alwaysOnClose() throws SQLException {
        this.sqlObject.resetNamedParameters();
        this.namedParameters = new String[8];
        this.parameterCount = 0;
        this.atLeastOneOrdinalParameter = false;
        this.atLeastOneNamedParameter = false;
        super.alwaysOnClose();
    }

    @Override
    public void registerOutParameter(String string, int n2) throws SQLException {
        this.registerOutParameterInternal(string, n2, 0, -1, null);
    }

    @Override
    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        this.registerOutParameterInternal(string, n2, n3, -1, null);
    }

    @Override
    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        this.registerOutParameterInternal(string, n2, 0, -1, string2);
    }

    void registerOutParameterInternal(String string, int n2, int n3, int n4, String string2) throws SQLException {
        int n5 = this.addNamedPara(string);
        this.registerOutParameterInternal(n5, n2, n3, n4, string2);
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getURL(this.currentRank);
    }

    @Override
    public void setStringForClob(String string, String string2) throws SQLException {
        int n2 = this.addNamedPara(string);
        if (string2 == null || string2.length() == 0) {
            this.setNull(n2, 2005);
            return;
        }
        this.setStringForClob(n2, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringForClob(int n2, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            this.setNull(n2, 2005);
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setStringForClobCritical(n2, string);
        }
    }

    @Override
    public void setBytesForBlob(String string, byte[] byArray) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBytesForBlob(n2, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytesForBlob(int n2, byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            this.setNull(n2, 2004);
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBytesForBlobCritical(n2, byArray);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getString(this.currentRank);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBoolean(this.currentRank);
    }

    @Override
    public byte getByte(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getByte(this.currentRank);
    }

    @Override
    public short getShort(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getShort(this.currentRank);
    }

    @Override
    public int getInt(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getInt(this.currentRank);
    }

    @Override
    public long getLong(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getLong(this.currentRank);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getFloat(this.currentRank);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDouble(this.currentRank);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBytes(this.currentRank);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDate(this.currentRank);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTime(this.currentRank);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTimestamp(this.currentRank);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getObject(this.currentRank);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBigDecimal(this.currentRank);
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        int n3;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n3 = 0; n3 < this.parameterCount && string2 != this.namedParameters[n3]; ++n3) {
        }
        Accessor accessor = null;
        if (++n3 <= 0 || n3 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n3 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n3;
        if (this.streamList != null) {
            this.closeUsedStreams(n3);
        }
        return accessor.getBigDecimal(this.currentRank, n2);
    }

    public Object getObject(String string, Map map) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getObject(this.currentRank, map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getREF(this.currentRank);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBLOB(this.currentRank);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCLOB(this.currentRank);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getARRAY(this.currentRank);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDate(this.currentRank, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTime(this.currentRank, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTimestamp(this.currentRank, calendar);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getURL(this.currentRank);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerIndexTableOutParameter(int n2, int n3, int n4, int n5) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n6 = n2 - 1;
            if (n6 < 0 || n2 > this.numberOfBindPositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n7 = this.getInternalType(n4);
            this.resetBatch();
            this.currentRowNeedToPrepareBinds = true;
            if (this.currentRowBindAccessors == null) {
                this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
            }
            this.currentRowBindAccessors[n6] = this.allocateIndexTableAccessor(n4, n7, n5, n3, this.currentRowFormOfUse[n6], true);
            this.hasIbtBind = true;
        }
    }

    PlsqlIndexTableAccessor allocateIndexTableAccessor(int n2, int n3, int n4, int n5, short s2, boolean bl) throws SQLException {
        return new PlsqlIndexTableAccessor(this, n2, n3, n4, n5, s2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPlsqlIndexTable(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum[] datumArray = this.getOraclePlsqlIndexTable(n2);
            PlsqlIndexTableAccessor plsqlIndexTableAccessor = (PlsqlIndexTableAccessor)this.outBindAccessors[n2 - 1];
            int n3 = plsqlIndexTableAccessor.elementInternalType;
            Object[] objectArray = null;
            switch (n3) {
                case 9: {
                    objectArray = new String[datumArray.length];
                    break;
                }
                case 6: {
                    objectArray = new BigDecimal[datumArray.length];
                    break;
                }
                default: {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid column type");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = datumArray[i2] != null && datumArray[i2].getLength() != 0L ? datumArray[i2].toJdbc() : null;
            }
            return objectArray;
        }
    }

    @Override
    public Object getPlsqlIndexTable(int n2, Class clazz) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum[] datumArray = this.getOraclePlsqlIndexTable(n2);
            if (clazz == null || !clazz.isPrimitive()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string = clazz.getName();
            if (string.equals("byte")) {
                byte[] byArray = new byte[datumArray.length];
                for (int i2 = 0; i2 < datumArray.length; ++i2) {
                    byArray[i2] = datumArray[i2] != null ? datumArray[i2].byteValue() : (byte)0;
                }
                return byArray;
            }
            if (string.equals("char")) {
                char[] cArray = new char[datumArray.length];
                for (int i3 = 0; i3 < datumArray.length; ++i3) {
                    cArray[i3] = datumArray[i3] != null && datumArray[i3].getLength() != 0L ? (char)datumArray[i3].intValue() : (char)'\u0000';
                }
                return cArray;
            }
            if (string.equals("double")) {
                double[] dArray = new double[datumArray.length];
                for (int i4 = 0; i4 < datumArray.length; ++i4) {
                    dArray[i4] = datumArray[i4] != null && datumArray[i4].getLength() != 0L ? datumArray[i4].doubleValue() : 0.0;
                }
                return dArray;
            }
            if (string.equals("float")) {
                float[] fArray = new float[datumArray.length];
                for (int i5 = 0; i5 < datumArray.length; ++i5) {
                    fArray[i5] = datumArray[i5] != null && datumArray[i5].getLength() != 0L ? datumArray[i5].floatValue() : 0.0f;
                }
                return fArray;
            }
            if (string.equals("int")) {
                int[] nArray = new int[datumArray.length];
                for (int i6 = 0; i6 < datumArray.length; ++i6) {
                    nArray[i6] = datumArray[i6] != null && datumArray[i6].getLength() != 0L ? datumArray[i6].intValue() : 0;
                }
                return nArray;
            }
            if (string.equals("long")) {
                long[] lArray = new long[datumArray.length];
                for (int i7 = 0; i7 < datumArray.length; ++i7) {
                    lArray[i7] = datumArray[i7] != null && datumArray[i7].getLength() != 0L ? datumArray[i7].longValue() : 0L;
                }
                return lArray;
            }
            if (string.equals("short")) {
                short[] sArray = new short[datumArray.length];
                for (int i8 = 0; i8 < datumArray.length; ++i8) {
                    sArray[i8] = datumArray[i8] != null && datumArray[i8].getLength() != 0L ? (short)datumArray[i8].intValue() : (short)0;
                }
                return sArray;
            }
            if (string.equals("boolean")) {
                boolean[] blArray = new boolean[datumArray.length];
                for (int i9 = 0; i9 < datumArray.length; ++i9) {
                    blArray[i9] = datumArray[i9] != null && datumArray[i9].getLength() != 0L ? datumArray[i9].booleanValue() : false;
                }
                return blArray;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            return accessor.getOraclePlsqlIndexTable(this.currentRank);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) {
                this.needToParse = true;
            }
            return super.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) {
                this.needToParse = true;
            }
            return super.executeUpdate();
        }
    }

    @Override
    void releaseBuffers() {
        if (this.outBindAccessors != null) {
            int n2 = this.outBindAccessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.outBindAccessors[i2] == null) continue;
                this.outBindAccessors[i2].rowSpaceByte = null;
                this.outBindAccessors[i2].rowSpaceChar = null;
            }
        }
        super.releaseBuffers();
    }

    @Override
    void doLocalInitialization() {
        if (this.outBindAccessors != null) {
            int n2 = this.outBindAccessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.outBindAccessors[i2] == null) continue;
                this.outBindAccessors[i2].rowSpaceByte = this.bindBytes;
                this.outBindAccessors[i2].rowSpaceChar = this.bindChars;
            }
        }
    }

    @Override
    public void setArray(int n2, Array array) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setArrayInternal(n2, array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBigDecimalInternal(n2, bigDecimal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBlobInternal(n2, blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBooleanInternal(n2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int n2, byte by) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setByteInternal(n2, by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBytesInternal(n2, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setClobInternal(n2, clob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int n2, Date date) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setDateInternal(n2, date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setDateInternal(n2, date, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setDoubleInternal(n2, d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setFloatInternal(n2, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setIntInternal(n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int n2, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setLongInternal(n2, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setNClobInternal(n2, nClob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setNStringInternal(n2, string);
        }
    }

    @Override
    public void setObject(int n2, Object object) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setObjectInternal(n2, object);
    }

    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setObjectInternal(n2, object, n3);
    }

    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setRefInternal(n2, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setRowIdInternal(n2, rowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int n2, short s2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setShortInternal(n2, s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setSQLXMLInternal(n2, sQLXML);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setStringInternal(n2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int n2, Time time) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setTimeInternal(n2, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setTimeInternal(n2, time, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setTimestampInternal(n2, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setTimestampInternal(n2, timestamp, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setURLInternal(n2, uRL);
        }
    }

    @Override
    public void setARRAY(int n2, ARRAY aRRAY) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setARRAYInternal(n2, aRRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBFILE(int n2, BFILE bFILE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBFILEInternal(n2, bFILE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBfile(int n2, BFILE bFILE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBfileInternal(n2, bFILE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(int n2, float f2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryFloatInternal(n2, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(int n2, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryFloatInternal(n2, bINARY_FLOAT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(int n2, double d2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryDoubleInternal(n2, d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(int n2, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryDoubleInternal(n2, bINARY_DOUBLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBLOB(int n2, BLOB bLOB) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBLOBInternal(n2, bLOB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCHAR(int n2, CHAR cHAR) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setCHARInternal(n2, cHAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCLOB(int n2, CLOB cLOB) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setCLOBInternal(n2, cLOB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursor(int n2, ResultSet resultSet) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setCursorInternal(n2, resultSet);
        }
    }

    @Override
    public void setCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCustomDatumInternal(n2, customDatum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDATE(int n2, DATE dATE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setDATEInternal(n2, dATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixedCHAR(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setFixedCHARInternal(n2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setINTERVALDSInternal(n2, iNTERVALDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setINTERVALYMInternal(n2, iNTERVALYM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setNUMBERInternal(n2, nUMBER);
        }
    }

    @Override
    public void setOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setOPAQUEInternal(n2, oPAQUE);
    }

    @Override
    public void setOracleObject(int n2, Datum datum) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setOracleObjectInternal(n2, datum);
    }

    @Override
    public void setORAData(int n2, ORAData oRAData) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setORADataInternal(n2, oRAData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRAW(int n2, RAW rAW) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setRAWInternal(n2, rAW);
        }
    }

    @Override
    public void setREF(int n2, REF rEF) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setREFInternal(n2, rEF);
    }

    @Override
    public void setRefType(int n2, REF rEF) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setRefTypeInternal(n2, rEF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setROWID(int n2, ROWID rOWID) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setROWIDInternal(n2, rOWID);
        }
    }

    @Override
    public void setSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setSTRUCTInternal(n2, sTRUCT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setTIMESTAMPLTZInternal(n2, tIMESTAMPLTZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setTIMESTAMPTZInternal(n2, tIMESTAMPTZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setTIMESTAMPInternal(n2, tIMESTAMP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBlobInternal(n2, inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (l2 < 0L) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBlobInternal(n2, inputStream, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setClobInternal(n2, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (l2 < 0L) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.atLeastOneOrdinalParameter = true;
            this.setClobInternal(n2, reader, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setNClobInternal(n2, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setNClobInternal(n2, reader, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setAsciiStreamInternal(n2, inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setAsciiStreamInternal(n2, inputStream, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setAsciiStreamInternal(n2, inputStream, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryStreamInternal(n2, inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryStreamInternal(n2, inputStream, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryStreamInternal(n2, inputStream, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setCharacterStreamInternal(n2, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setCharacterStreamInternal(n2, reader, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setCharacterStreamInternal(n2, reader, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setNCharacterStreamInternal(n2, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setNCharacterStreamInternal(n2, reader, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setUnicodeStreamInternal(n2, inputStream, n3);
        }
    }

    @Override
    public void setArray(String string, Array array) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setArrayInternal(n2, array);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBigDecimalInternal(n2, bigDecimal);
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBlobInternal(n2, blob);
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBooleanInternal(n2, bl);
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setByteInternal(n2, by);
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBytesInternal(n2, byArray);
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setClobInternal(n2, clob);
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setDateInternal(n2, date);
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setDateInternal(n2, date, calendar);
    }

    @Override
    public void setDouble(String string, double d2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setDoubleInternal(n2, d2);
    }

    @Override
    public void setFloat(String string, float f2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setFloatInternal(n2, f2);
    }

    @Override
    public void setInt(String string, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setIntInternal(n3, n2);
    }

    @Override
    public void setLong(String string, long l2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setLongInternal(n2, l2);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setNClobInternal(n2, nClob);
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setNStringInternal(n2, string2);
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setObjectInternal(n2, object);
    }

    @Override
    public void setObject(String string, Object object, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setObjectInternal(n3, object, n2);
    }

    @Override
    public void setRef(String string, Ref ref) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setRefInternal(n2, ref);
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setRowIdInternal(n2, rowId);
    }

    @Override
    public void setShort(String string, short s2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setShortInternal(n2, s2);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setSQLXMLInternal(n2, sQLXML);
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setStringInternal(n2, string2);
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTimeInternal(n2, time);
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTimeInternal(n2, time, calendar);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTimestampInternal(n2, timestamp);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTimestampInternal(n2, timestamp, calendar);
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setURLInternal(n2, uRL);
    }

    @Override
    public void setARRAY(String string, ARRAY aRRAY) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setARRAYInternal(n2, aRRAY);
    }

    @Override
    public void setBFILE(String string, BFILE bFILE) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBFILEInternal(n2, bFILE);
    }

    @Override
    public void setBfile(String string, BFILE bFILE) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBfileInternal(n2, bFILE);
    }

    @Override
    public void setBinaryFloat(String string, float f2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryFloatInternal(n2, f2);
    }

    @Override
    public void setBinaryFloat(String string, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryFloatInternal(n2, bINARY_FLOAT);
    }

    @Override
    public void setBinaryDouble(String string, double d2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryDoubleInternal(n2, d2);
    }

    @Override
    public void setBinaryDouble(String string, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryDoubleInternal(n2, bINARY_DOUBLE);
    }

    @Override
    public void setBLOB(String string, BLOB bLOB) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBLOBInternal(n2, bLOB);
    }

    @Override
    public void setCHAR(String string, CHAR cHAR) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setCHARInternal(n2, cHAR);
    }

    @Override
    public void setCLOB(String string, CLOB cLOB) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setCLOBInternal(n2, cLOB);
    }

    @Override
    public void setCursor(String string, ResultSet resultSet) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setCursorInternal(n2, resultSet);
    }

    @Override
    public void setCustomDatum(String string, CustomDatum customDatum) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setCustomDatumInternal(n2, customDatum);
    }

    @Override
    public void setDATE(String string, DATE dATE) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setDATEInternal(n2, dATE);
    }

    @Override
    public void setFixedCHAR(String string, String string2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setFixedCHARInternal(n2, string2);
    }

    @Override
    public void setINTERVALDS(String string, INTERVALDS iNTERVALDS) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setINTERVALDSInternal(n2, iNTERVALDS);
    }

    @Override
    public void setINTERVALYM(String string, INTERVALYM iNTERVALYM) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setINTERVALYMInternal(n2, iNTERVALYM);
    }

    @Override
    public void setNUMBER(String string, NUMBER nUMBER) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setNUMBERInternal(n2, nUMBER);
    }

    @Override
    public void setOPAQUE(String string, OPAQUE oPAQUE) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setOPAQUEInternal(n2, oPAQUE);
    }

    @Override
    public void setOracleObject(String string, Datum datum) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setOracleObjectInternal(n2, datum);
    }

    @Override
    public void setORAData(String string, ORAData oRAData) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setORADataInternal(n2, oRAData);
    }

    @Override
    public void setRAW(String string, RAW rAW) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setRAWInternal(n2, rAW);
    }

    @Override
    public void setREF(String string, REF rEF) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setREFInternal(n2, rEF);
    }

    @Override
    public void setRefType(String string, REF rEF) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setRefTypeInternal(n2, rEF);
    }

    @Override
    public void setROWID(String string, ROWID rOWID) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setROWIDInternal(n2, rOWID);
    }

    @Override
    public void setSTRUCT(String string, STRUCT sTRUCT) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setSTRUCTInternal(n2, sTRUCT);
    }

    @Override
    public void setTIMESTAMPLTZ(String string, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTIMESTAMPLTZInternal(n2, tIMESTAMPLTZ);
    }

    @Override
    public void setTIMESTAMPTZ(String string, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTIMESTAMPTZInternal(n2, tIMESTAMPTZ);
    }

    @Override
    public void setTIMESTAMP(String string, TIMESTAMP tIMESTAMP) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTIMESTAMPInternal(n2, tIMESTAMP);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBlobInternal(n2, inputStream);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        if (l2 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = this.addNamedPara(string);
        this.setBlobInternal(n2, inputStream, l2);
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setClobInternal(n2, reader);
    }

    @Override
    public void setClob(String string, Reader reader, long l2) throws SQLException {
        if (l2 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = this.addNamedPara(string);
        this.setClobInternal(n2, reader, l2);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setNClobInternal(n2, reader);
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setNClobInternal(n2, reader, l2);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setAsciiStreamInternal(n2, inputStream);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setAsciiStreamInternal(n3, inputStream, n2);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setAsciiStreamInternal(n2, inputStream, l2);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryStreamInternal(n2, inputStream);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setBinaryStreamInternal(n3, inputStream, n2);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryStreamInternal(n2, inputStream, l2);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setCharacterStreamInternal(n2, reader);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setCharacterStreamInternal(n3, reader, n2);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setCharacterStreamInternal(n2, reader, l2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setNCharacterStreamInternal(n2, reader);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setNCharacterStreamInternal(n2, reader, l2);
    }

    @Override
    public void setUnicodeStream(String string, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setUnicodeStreamInternal(n3, inputStream, n2);
    }

    @Override
    public void setNull(String string, int n2, String string2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setNullInternal(n3, n2, string2);
    }

    @Override
    public void setNull(String string, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setNullInternal(n3, n2);
    }

    @Override
    public void setStructDescriptor(String string, StructDescriptor structDescriptor) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setStructDescriptorInternal(n2, structDescriptor);
    }

    @Override
    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        int n4 = this.addNamedPara(string);
        this.setObjectInternal(n4, object, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlsqlIndexTable(int n2, Object object, int n3, int n4, int n5, int n6) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.atLeastOneOrdinalParameter = true;
            this.setPlsqlIndexTableInternal(n2, object, n3, n4, n5, n6);
        }
    }

    int addNamedPara(String string) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (int i2 = 0; i2 < this.parameterCount; ++i2) {
            if (string2 != this.namedParameters[i2]) continue;
            return i2 + 1;
        }
        if (this.parameterCount >= this.namedParameters.length) {
            String[] stringArray = new String[this.namedParameters.length * 2];
            System.arraycopy(this.namedParameters, 0, stringArray, 0, this.namedParameters.length);
            this.namedParameters = stringArray;
        }
        this.namedParameters[this.parameterCount++] = string2;
        this.atLeastOneNamedParameter = true;
        return this.parameterCount;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCharacterStream(this.currentRank);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getUnicodeStream(this.currentRank);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBinaryStream(this.currentRank);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getROWID(this.currentRank);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getROWID(this.currentRank);
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getNClob(this.currentRank);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getNClob(this.currentRank);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getSQLXML(this.currentRank);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getSQLXML(this.currentRank);
    }

    @Override
    public String getNString(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getNString(this.currentRank);
    }

    @Override
    public String getNString(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getNString(this.currentRank);
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getNCharacterStream(this.currentRank);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        int n2;
        if (!this.atLeastOneNamedParameter) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getNCharacterStream(this.currentRank);
    }
}

