/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import org.apache.commons.dbcp2.LifetimeExceededException;
import org.apache.commons.dbcp2.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.pool2.SwallowedExceptionListener;

public class SwallowedExceptionLogger
implements SwallowedExceptionListener {
    private final Log log;
    private final boolean logExpiredConnections;

    public SwallowedExceptionLogger(Log log) {
        this(log, true);
    }

    public SwallowedExceptionLogger(Log log, boolean logExpiredConnections) {
        this.log = log;
        this.logExpiredConnections = logExpiredConnections;
    }

    @Override
    public void onSwallowException(Exception e2) {
        if (this.logExpiredConnections || !(e2 instanceof LifetimeExceededException)) {
            this.log.warn(Utils.getMessage("swallowedExceptionLogger.onSwallowedException"), e2);
        }
    }
}

