/*
 * Copyright (C) 2007-2008 Marylene Ysmal <wiidevel@stacktic.org>
 *
 * transfermii_gui.c (TransferMii)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */ 

#include <gtk/gtk.h>
#include <stdio.h>

#include "pageAbout.h"
#include "pageLocal.h"
#include "pageWiimote.h"

static void onQuitButton(GtkWidget *widget, gpointer data);
void updateStatusBar(char *msg);

GtkWidget *statusBar;

int main(int argc, char **argv){
	GtkWidget *window;
	GtkWidget *notebook;

	/* Pages widgets */
	GtkWidget *wAbout;
	GtkWidget *wLocal;
	GtkWidget *wWiimote;
	
	GtkWidget *pagesLabel;
	GtkWidget *mainVBox;

	GtkWidget *buttonBox;
	GtkWidget *quitButton;

	gtk_init(&argc, &argv);

	/* Main window initialisation */
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "Transfermii !");
	gtk_window_set_default_size(GTK_WINDOW(window), 600, 400);
	
	g_signal_connect(G_OBJECT(window), "destroy",
			 G_CALLBACK(onQuitButton), 
			 NULL);
	
	/* Notebook initialisation */
	notebook=gtk_notebook_new();
	gtk_container_set_border_width(GTK_CONTAINER(notebook), 10);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),GTK_POS_TOP);

	mainVBox=gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), mainVBox);
	gtk_box_pack_start(GTK_BOX(mainVBox), notebook, TRUE, TRUE, 0);

    		
	/* Adding pages to the notebook */
	pagesLabel=gtk_label_new("Wiimote");
	wWiimote=createPageWiimote();
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), wWiimote, pagesLabel);
		
	pagesLabel=gtk_label_new("Local Files");
	wLocal=createPageLocal();
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), wLocal, pagesLabel);

	pagesLabel=gtk_label_new("About");
	wAbout=createPageAbout();
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), wAbout, pagesLabel);

	
	/* Bottom buttons */
	buttonBox=gtk_hbutton_box_new();
    	gtk_container_set_border_width(GTK_CONTAINER(buttonBox), 5);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonBox),GTK_BUTTONBOX_END);

	quitButton=gtk_button_new_with_label("Quit");
	g_signal_connect_swapped(G_OBJECT(quitButton), "clicked", 
				 G_CALLBACK(onQuitButton), NULL);
	gtk_container_add(GTK_CONTAINER(buttonBox), quitButton);

	gtk_box_pack_start(GTK_BOX(mainVBox), buttonBox, FALSE, FALSE, 0);

	/* Status Bar */
	statusBar=gtk_statusbar_new();
	gtk_box_pack_start(GTK_BOX(mainVBox), statusBar, FALSE, FALSE, 0);
	gtk_statusbar_push(GTK_STATUSBAR(statusBar), 0, "Welcome");

	gtk_widget_show_all(window);
	gtk_main();
	
        return 0;
}

void onQuitButton(GtkWidget *widget, gpointer data)
{
	extern bool wm_auto_update;
	if(wm_update) {
		GtkWidget *msgDialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, 
							      GTK_MESSAGE_QUESTION, 
							      GTK_BUTTONS_YES_NO, 
							      "Update the wiimote before leaving ?");
		if(gtk_dialog_run(GTK_DIALOG(msgDialog)) == GTK_RESPONSE_YES)
			wm_auto_update=TRUE;	
		gtk_widget_destroy(msgDialog); 
	}
	gtk_main_quit();
}

void updateStatusBar(char *msg){
	gtk_statusbar_pop(GTK_STATUSBAR(statusBar), 0);
	gtk_statusbar_push(GTK_STATUSBAR(statusBar), 0, msg);
}
