#include <iostream>

#include "CommandlineOptions.hh"

#include "Chirotope.hh"
#include "Symmetry.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing the dual of a chirotope \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  Chirotope chirotope;
  if (chirotope.read_string(std::cin)) {
    chirotope.print_dualstring(MessageStreams::result());
    SymmetryGroup symmetries(chirotope.no());
    if (symmetries.read_generators(std::cin)) {
      symmetries.write_sorted_generators(MessageStreams::result());
      MessageStreams::result() << std::endl;
    }
    else {
      MessageStreams::verbose() << "no valid symmetry generators found." << std::endl;
    }
    return 0;
  }
  else {
    return 1;
  }
}

// eof chiro2dual.cc
