/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2020 Marvell International Ltd.
 *
 * Configuration and status register (CSR) definitions for
 * OCTEON PEXP.
 */

#ifndef __CVMX_PEXP_DEFS_H__
#define __CVMX_PEXP_DEFS_H__

#define CVMX_PEXP_NPEI_BAR1_INDEXX(offset)	(0x00011F0000008000ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_BIST_STATUS		(0x00011F0000008580ull)
#define CVMX_PEXP_NPEI_BIST_STATUS2		(0x00011F0000008680ull)
#define CVMX_PEXP_NPEI_CTL_PORT0		(0x00011F0000008250ull)
#define CVMX_PEXP_NPEI_CTL_PORT1		(0x00011F0000008260ull)
#define CVMX_PEXP_NPEI_CTL_STATUS		(0x00011F0000008570ull)
#define CVMX_PEXP_NPEI_CTL_STATUS2		(0x00011F000000BC00ull)
#define CVMX_PEXP_NPEI_DATA_OUT_CNT		(0x00011F00000085F0ull)
#define CVMX_PEXP_NPEI_DBG_DATA			(0x00011F0000008510ull)
#define CVMX_PEXP_NPEI_DBG_SELECT		(0x00011F0000008500ull)
#define CVMX_PEXP_NPEI_DMA0_INT_LEVEL		(0x00011F00000085C0ull)
#define CVMX_PEXP_NPEI_DMA1_INT_LEVEL		(0x00011F00000085D0ull)
#define CVMX_PEXP_NPEI_DMAX_COUNTS(offset)	(0x00011F0000008450ull + ((offset) & 7) * 16)
#define CVMX_PEXP_NPEI_DMAX_DBELL(offset)	(0x00011F00000083B0ull + ((offset) & 7) * 16)
#define CVMX_PEXP_NPEI_DMAX_IBUFF_SADDR(offset) (0x00011F0000008400ull + ((offset) & 7) * 16)
#define CVMX_PEXP_NPEI_DMAX_NADDR(offset)	(0x00011F00000084A0ull + ((offset) & 7) * 16)
#define CVMX_PEXP_NPEI_DMA_CNTS			(0x00011F00000085E0ull)
#define CVMX_PEXP_NPEI_DMA_CONTROL		(0x00011F00000083A0ull)
#define CVMX_PEXP_NPEI_DMA_PCIE_REQ_NUM		(0x00011F00000085B0ull)
#define CVMX_PEXP_NPEI_DMA_STATE1		(0x00011F00000086C0ull)
#define CVMX_PEXP_NPEI_DMA_STATE1_P1		(0x00011F0000008680ull)
#define CVMX_PEXP_NPEI_DMA_STATE2		(0x00011F00000086D0ull)
#define CVMX_PEXP_NPEI_DMA_STATE2_P1		(0x00011F0000008690ull)
#define CVMX_PEXP_NPEI_DMA_STATE3_P1		(0x00011F00000086A0ull)
#define CVMX_PEXP_NPEI_DMA_STATE4_P1		(0x00011F00000086B0ull)
#define CVMX_PEXP_NPEI_DMA_STATE5_P1		(0x00011F00000086C0ull)
#define CVMX_PEXP_NPEI_INT_A_ENB		(0x00011F0000008560ull)
#define CVMX_PEXP_NPEI_INT_A_ENB2		(0x00011F000000BCE0ull)
#define CVMX_PEXP_NPEI_INT_A_SUM		(0x00011F0000008550ull)
#define CVMX_PEXP_NPEI_INT_ENB			(0x00011F0000008540ull)
#define CVMX_PEXP_NPEI_INT_ENB2			(0x00011F000000BCD0ull)
#define CVMX_PEXP_NPEI_INT_INFO			(0x00011F0000008590ull)
#define CVMX_PEXP_NPEI_INT_SUM			(0x00011F0000008530ull)
#define CVMX_PEXP_NPEI_INT_SUM2			(0x00011F000000BCC0ull)
#define CVMX_PEXP_NPEI_LAST_WIN_RDATA0		(0x00011F0000008600ull)
#define CVMX_PEXP_NPEI_LAST_WIN_RDATA1		(0x00011F0000008610ull)
#define CVMX_PEXP_NPEI_MEM_ACCESS_CTL		(0x00011F00000084F0ull)
#define CVMX_PEXP_NPEI_MEM_ACCESS_SUBIDX(offset)                                                   \
	(0x00011F0000008280ull + ((offset) & 31) * 16 - 16 * 12)
#define CVMX_PEXP_NPEI_MSI_ENB0			      (0x00011F000000BC50ull)
#define CVMX_PEXP_NPEI_MSI_ENB1			      (0x00011F000000BC60ull)
#define CVMX_PEXP_NPEI_MSI_ENB2			      (0x00011F000000BC70ull)
#define CVMX_PEXP_NPEI_MSI_ENB3			      (0x00011F000000BC80ull)
#define CVMX_PEXP_NPEI_MSI_RCV0			      (0x00011F000000BC10ull)
#define CVMX_PEXP_NPEI_MSI_RCV1			      (0x00011F000000BC20ull)
#define CVMX_PEXP_NPEI_MSI_RCV2			      (0x00011F000000BC30ull)
#define CVMX_PEXP_NPEI_MSI_RCV3			      (0x00011F000000BC40ull)
#define CVMX_PEXP_NPEI_MSI_RD_MAP		      (0x00011F000000BCA0ull)
#define CVMX_PEXP_NPEI_MSI_W1C_ENB0		      (0x00011F000000BCF0ull)
#define CVMX_PEXP_NPEI_MSI_W1C_ENB1		      (0x00011F000000BD00ull)
#define CVMX_PEXP_NPEI_MSI_W1C_ENB2		      (0x00011F000000BD10ull)
#define CVMX_PEXP_NPEI_MSI_W1C_ENB3		      (0x00011F000000BD20ull)
#define CVMX_PEXP_NPEI_MSI_W1S_ENB0		      (0x00011F000000BD30ull)
#define CVMX_PEXP_NPEI_MSI_W1S_ENB1		      (0x00011F000000BD40ull)
#define CVMX_PEXP_NPEI_MSI_W1S_ENB2		      (0x00011F000000BD50ull)
#define CVMX_PEXP_NPEI_MSI_W1S_ENB3		      (0x00011F000000BD60ull)
#define CVMX_PEXP_NPEI_MSI_WR_MAP		      (0x00011F000000BC90ull)
#define CVMX_PEXP_NPEI_PCIE_CREDIT_CNT		      (0x00011F000000BD70ull)
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV		      (0x00011F000000BCB0ull)
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV_B1		      (0x00011F0000008650ull)
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV_B2		      (0x00011F0000008660ull)
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV_B3		      (0x00011F0000008670ull)
#define CVMX_PEXP_NPEI_PKTX_CNTS(offset)	      (0x00011F000000A400ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKTX_INSTR_BADDR(offset)	      (0x00011F000000A800ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKTX_INSTR_BAOFF_DBELL(offset) (0x00011F000000AC00ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKTX_INSTR_FIFO_RSIZE(offset)  (0x00011F000000B000ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKTX_INSTR_HEADER(offset)      (0x00011F000000B400ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKTX_IN_BP(offset)	      (0x00011F000000B800ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKTX_SLIST_BADDR(offset)	      (0x00011F0000009400ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKTX_SLIST_BAOFF_DBELL(offset) (0x00011F0000009800ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKTX_SLIST_FIFO_RSIZE(offset)  (0x00011F0000009C00ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKT_CNT_INT		      (0x00011F0000009110ull)
#define CVMX_PEXP_NPEI_PKT_CNT_INT_ENB		      (0x00011F0000009130ull)
#define CVMX_PEXP_NPEI_PKT_DATA_OUT_ES		      (0x00011F00000090B0ull)
#define CVMX_PEXP_NPEI_PKT_DATA_OUT_NS		      (0x00011F00000090A0ull)
#define CVMX_PEXP_NPEI_PKT_DATA_OUT_ROR		      (0x00011F0000009090ull)
#define CVMX_PEXP_NPEI_PKT_DPADDR		      (0x00011F0000009080ull)
#define CVMX_PEXP_NPEI_PKT_INPUT_CONTROL	      (0x00011F0000009150ull)
#define CVMX_PEXP_NPEI_PKT_INSTR_ENB		      (0x00011F0000009000ull)
#define CVMX_PEXP_NPEI_PKT_INSTR_RD_SIZE	      (0x00011F0000009190ull)
#define CVMX_PEXP_NPEI_PKT_INSTR_SIZE		      (0x00011F0000009020ull)
#define CVMX_PEXP_NPEI_PKT_INT_LEVELS		      (0x00011F0000009100ull)
#define CVMX_PEXP_NPEI_PKT_IN_BP		      (0x00011F00000086B0ull)
#define CVMX_PEXP_NPEI_PKT_IN_DONEX_CNTS(offset)      (0x00011F000000A000ull + ((offset) & 31) * 16)
#define CVMX_PEXP_NPEI_PKT_IN_INSTR_COUNTS	      (0x00011F00000086A0ull)
#define CVMX_PEXP_NPEI_PKT_IN_PCIE_PORT		      (0x00011F00000091A0ull)
#define CVMX_PEXP_NPEI_PKT_IPTR			      (0x00011F0000009070ull)
#define CVMX_PEXP_NPEI_PKT_OUTPUT_WMARK		      (0x00011F0000009160ull)
#define CVMX_PEXP_NPEI_PKT_OUT_BMODE		      (0x00011F00000090D0ull)
#define CVMX_PEXP_NPEI_PKT_OUT_ENB		      (0x00011F0000009010ull)
#define CVMX_PEXP_NPEI_PKT_PCIE_PORT		      (0x00011F00000090E0ull)
#define CVMX_PEXP_NPEI_PKT_PORT_IN_RST		      (0x00011F0000008690ull)
#define CVMX_PEXP_NPEI_PKT_SLIST_ES		      (0x00011F0000009050ull)
#define CVMX_PEXP_NPEI_PKT_SLIST_ID_SIZE	      (0x00011F0000009180ull)
#define CVMX_PEXP_NPEI_PKT_SLIST_NS		      (0x00011F0000009040ull)
#define CVMX_PEXP_NPEI_PKT_SLIST_ROR		      (0x00011F0000009030ull)
#define CVMX_PEXP_NPEI_PKT_TIME_INT		      (0x00011F0000009120ull)
#define CVMX_PEXP_NPEI_PKT_TIME_INT_ENB		      (0x00011F0000009140ull)
#define CVMX_PEXP_NPEI_RSL_INT_BLOCKS		      (0x00011F0000008520ull)
#define CVMX_PEXP_NPEI_SCRATCH_1		      (0x00011F0000008270ull)
#define CVMX_PEXP_NPEI_STATE1			      (0x00011F0000008620ull)
#define CVMX_PEXP_NPEI_STATE2			      (0x00011F0000008630ull)
#define CVMX_PEXP_NPEI_STATE3			      (0x00011F0000008640ull)
#define CVMX_PEXP_NPEI_WINDOW_CTL		      (0x00011F0000008380ull)
#define CVMX_PEXP_NQM_VFX_ACQ(offset)		      (0x0001450000000030ull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_AQA(offset)		      (0x0001450000000024ull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_ASQ(offset)		      (0x0001450000000028ull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_CAP(offset)		      (0x0001450000000000ull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_CC(offset)		      (0x0001450000000014ull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_CQX_HDBL(offset, block_id)                                               \
	(0x0001450000001004ull + (((offset) & 31) + ((block_id) & 2047) * 0x4000ull) * 8)
#define CVMX_PEXP_NQM_VFX_CSTS(offset)	   (0x000145000000001Cull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_INTMC(offset)	   (0x0001450000000010ull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_INTMS(offset)	   (0x000145000000000Cull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_MSIX_PBA(offset) (0x0001450000010200ull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_NSSR(offset)	   (0x0001450000000020ull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_NQM_VFX_SQX_TDBL(offset, block_id)                                               \
	(0x0001450000001000ull + (((offset) & 31) + ((block_id) & 2047) * 0x4000ull) * 8)
#define CVMX_PEXP_NQM_VFX_VECX_MSIX_ADDR(offset, block_id)                                         \
	(0x0001450000010000ull + (((offset) & 31) + ((block_id) & 2047) * 0x2000ull) * 16)
#define CVMX_PEXP_NQM_VFX_VECX_MSIX_CTL(offset, block_id)                                          \
	(0x0001450000010008ull + (((offset) & 31) + ((block_id) & 2047) * 0x2000ull) * 16)
#define CVMX_PEXP_NQM_VFX_VS(offset)		 (0x0001450000000008ull + ((offset) & 2047) * 0x20000ull)
#define CVMX_PEXP_SLITB_MSIXX_TABLE_ADDR(offset) (0x00011F0000004000ull + ((offset) & 127) * 16)
#define CVMX_PEXP_SLITB_MSIXX_TABLE_DATA(offset) (0x00011F0000004008ull + ((offset) & 127) * 16)
#define CVMX_PEXP_SLITB_MSIX_MACX_PFX_TABLE_ADDR(offset, block_id)                                 \
	(0x00011F0000002000ull + ((offset) & 1) * 4096 + ((block_id) & 3) * 0x10ull)
#define CVMX_PEXP_SLITB_MSIX_MACX_PFX_TABLE_DATA(offset, block_id)                                 \
	(0x00011F0000002008ull + ((offset) & 1) * 4096 + ((block_id) & 3) * 0x10ull)
#define CVMX_PEXP_SLITB_PFX_PKT_CNT_INT(offset)	 (0x00011F0000008000ull + ((offset) & 7) * 16)
#define CVMX_PEXP_SLITB_PFX_PKT_INT(offset)	 (0x00011F0000008300ull + ((offset) & 7) * 16)
#define CVMX_PEXP_SLITB_PFX_PKT_IN_INT(offset)	 (0x00011F0000008200ull + ((offset) & 7) * 16)
#define CVMX_PEXP_SLITB_PFX_PKT_RING_RST(offset) (0x00011F0000008400ull + ((offset) & 7) * 16)
#define CVMX_PEXP_SLITB_PFX_PKT_TIME_INT(offset) (0x00011F0000008100ull + ((offset) & 7) * 16)
#define CVMX_PEXP_SLITB_PKTX_PF_VF_MBOX_SIGX(offset, block_id)                                     \
	(0x00011F0000011000ull + (((offset) & 1) + ((block_id) & 127) * 0x4000ull) * 8)
#define CVMX_PEXP_SLI_BIST_STATUS CVMX_PEXP_SLI_BIST_STATUS_FUNC()
static inline u64 CVMX_PEXP_SLI_BIST_STATUS_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010580ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010580ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028580ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028580ull;
	}
	return 0x00011F0000028580ull;
}

static inline u64 CVMX_PEXP_SLI_CTL_PORTX(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010050ull + (offset) * 16;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010050ull + (offset) * 16;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010050ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000106E0ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000286E0ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000286E0ull + (offset) * 16;
	}
	return 0x00011F00000286E0ull + (offset) * 16;
}

#define CVMX_PEXP_SLI_CTL_STATUS CVMX_PEXP_SLI_CTL_STATUS_FUNC()
static inline u64 CVMX_PEXP_SLI_CTL_STATUS_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010570ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010570ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028570ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028570ull;
	}
	return 0x00011F0000028570ull;
}

#define CVMX_PEXP_SLI_DATA_OUT_CNT CVMX_PEXP_SLI_DATA_OUT_CNT_FUNC()
static inline u64 CVMX_PEXP_SLI_DATA_OUT_CNT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000105F0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000105F0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000285F0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000285F0ull;
	}
	return 0x00011F00000285F0ull;
}

#define CVMX_PEXP_SLI_DBG_DATA	 (0x00011F0000010310ull)
#define CVMX_PEXP_SLI_DBG_SELECT (0x00011F0000010300ull)
static inline u64 CVMX_PEXP_SLI_DMAX_CNT(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010400ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010400ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028400ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028400ull + (offset) * 16;
	}
	return 0x00011F0000028400ull + (offset) * 16;
}

static inline u64 CVMX_PEXP_SLI_DMAX_INT_LEVEL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000103E0ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000103E0ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000283E0ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000283E0ull + (offset) * 16;
	}
	return 0x00011F00000283E0ull + (offset) * 16;
}

static inline u64 CVMX_PEXP_SLI_DMAX_TIM(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010420ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010420ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028420ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028420ull + (offset) * 16;
	}
	return 0x00011F0000028420ull + (offset) * 16;
}

#define CVMX_PEXP_SLI_INT_ENB_CIU	    (0x00011F0000013CD0ull)
#define CVMX_PEXP_SLI_INT_ENB_PORTX(offset) (0x00011F0000010340ull + ((offset) & 3) * 16)
#define CVMX_PEXP_SLI_INT_SUM		    (0x00011F0000010330ull)
#define CVMX_PEXP_SLI_LAST_WIN_RDATA0	    (0x00011F0000010600ull)
#define CVMX_PEXP_SLI_LAST_WIN_RDATA1	    (0x00011F0000010610ull)
#define CVMX_PEXP_SLI_LAST_WIN_RDATA2	    (0x00011F00000106C0ull)
#define CVMX_PEXP_SLI_LAST_WIN_RDATA3	    (0x00011F00000106D0ull)
#define CVMX_PEXP_SLI_MACX_PFX_DMA_VF_INT(offset, block_id)                                        \
	(0x00011F0000027280ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MACX_PFX_DMA_VF_INT_ENB(offset, block_id)                                    \
	(0x00011F0000027500ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MACX_PFX_FLR_VF_INT(offset, block_id)                                        \
	(0x00011F0000027400ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MACX_PFX_INT_ENB(offset, block_id)                                           \
	(0x00011F0000027080ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MACX_PFX_INT_SUM(offset, block_id)                                           \
	(0x00011F0000027000ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MACX_PFX_MBOX_INT(offset, block_id)                                          \
	(0x00011F0000027380ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MACX_PFX_PKT_VF_INT(offset, block_id)                                        \
	(0x00011F0000027300ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MACX_PFX_PKT_VF_INT_ENB(offset, block_id)                                    \
	(0x00011F0000027580ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MACX_PFX_PP_VF_INT(offset, block_id)                                         \
	(0x00011F0000027200ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MACX_PFX_PP_VF_INT_ENB(offset, block_id)                                     \
	(0x00011F0000027480ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_MAC_CREDIT_CNT CVMX_PEXP_SLI_MAC_CREDIT_CNT_FUNC()
static inline u64 CVMX_PEXP_SLI_MAC_CREDIT_CNT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013D70ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013D70ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023D70ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023D70ull;
	}
	return 0x00011F0000023D70ull;
}

#define CVMX_PEXP_SLI_MAC_CREDIT_CNT2 CVMX_PEXP_SLI_MAC_CREDIT_CNT2_FUNC()
static inline u64 CVMX_PEXP_SLI_MAC_CREDIT_CNT2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013E10ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013E10ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023E10ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023E10ull;
	}
	return 0x00011F0000023E10ull;
}

#define CVMX_PEXP_SLI_MEM_ACCESS_CTL CVMX_PEXP_SLI_MEM_ACCESS_CTL_FUNC()
static inline u64 CVMX_PEXP_SLI_MEM_ACCESS_CTL_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000102F0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000102F0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000282F0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000282F0ull;
	}
	return 0x00011F00000282F0ull;
}

static inline u64 CVMX_PEXP_SLI_MEM_ACCESS_SUBIDX(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000100E0ull + (offset) * 16 - 16 * 12;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000100E0ull + (offset) * 16 - 16 * 12;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000280E0ull + (offset) * 16 - 16 * 12;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000280E0ull + (offset) * 16 - 16 * 12;
	}
	return 0x00011F00000280E0ull + (offset) * 16 - 16 * 12;
}

#define CVMX_PEXP_SLI_MEM_CTL CVMX_PEXP_SLI_MEM_CTL_FUNC()
static inline u64 CVMX_PEXP_SLI_MEM_CTL_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000105E0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000285E0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000285E0ull;
	}
	return 0x00011F00000285E0ull;
}

#define CVMX_PEXP_SLI_MEM_INT_SUM CVMX_PEXP_SLI_MEM_INT_SUM_FUNC()
static inline u64 CVMX_PEXP_SLI_MEM_INT_SUM_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000105D0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000285D0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000285D0ull;
	}
	return 0x00011F00000285D0ull;
}

static inline u64 CVMX_PEXP_SLI_MSIXX_TABLE_ADDR(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000016000ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000000000ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000000000ull + (offset) * 16;
	}
	return 0x00011F0000000000ull + (offset) * 16;
}

static inline u64 CVMX_PEXP_SLI_MSIXX_TABLE_DATA(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000016008ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000000008ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000000008ull + (offset) * 16;
	}
	return 0x00011F0000000008ull + (offset) * 16;
}

#define CVMX_PEXP_SLI_MSIX_MACX_PF_TABLE_ADDR(offset) (0x00011F0000017C00ull + ((offset) & 3) * 16)
#define CVMX_PEXP_SLI_MSIX_MACX_PF_TABLE_DATA(offset) (0x00011F0000017C08ull + ((offset) & 3) * 16)
#define CVMX_PEXP_SLI_MSIX_PBA0			      CVMX_PEXP_SLI_MSIX_PBA0_FUNC()
static inline u64 CVMX_PEXP_SLI_MSIX_PBA0_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000017000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000001000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000001000ull;
	}
	return 0x00011F0000001000ull;
}

#define CVMX_PEXP_SLI_MSIX_PBA1 CVMX_PEXP_SLI_MSIX_PBA1_FUNC()
static inline u64 CVMX_PEXP_SLI_MSIX_PBA1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000017010ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000001008ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000001008ull;
	}
	return 0x00011F0000001008ull;
}

#define CVMX_PEXP_SLI_MSI_ENB0 (0x00011F0000013C50ull)
#define CVMX_PEXP_SLI_MSI_ENB1 (0x00011F0000013C60ull)
#define CVMX_PEXP_SLI_MSI_ENB2 (0x00011F0000013C70ull)
#define CVMX_PEXP_SLI_MSI_ENB3 (0x00011F0000013C80ull)
#define CVMX_PEXP_SLI_MSI_RCV0 CVMX_PEXP_SLI_MSI_RCV0_FUNC()
static inline u64 CVMX_PEXP_SLI_MSI_RCV0_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013C10ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013C10ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023C10ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023C10ull;
	}
	return 0x00011F0000023C10ull;
}

#define CVMX_PEXP_SLI_MSI_RCV1 CVMX_PEXP_SLI_MSI_RCV1_FUNC()
static inline u64 CVMX_PEXP_SLI_MSI_RCV1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013C20ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013C20ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023C20ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023C20ull;
	}
	return 0x00011F0000023C20ull;
}

#define CVMX_PEXP_SLI_MSI_RCV2 CVMX_PEXP_SLI_MSI_RCV2_FUNC()
static inline u64 CVMX_PEXP_SLI_MSI_RCV2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013C30ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013C30ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023C30ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023C30ull;
	}
	return 0x00011F0000023C30ull;
}

#define CVMX_PEXP_SLI_MSI_RCV3 CVMX_PEXP_SLI_MSI_RCV3_FUNC()
static inline u64 CVMX_PEXP_SLI_MSI_RCV3_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013C40ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013C40ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023C40ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023C40ull;
	}
	return 0x00011F0000023C40ull;
}

#define CVMX_PEXP_SLI_MSI_RD_MAP CVMX_PEXP_SLI_MSI_RD_MAP_FUNC()
static inline u64 CVMX_PEXP_SLI_MSI_RD_MAP_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013CA0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013CA0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023CA0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023CA0ull;
	}
	return 0x00011F0000023CA0ull;
}

#define CVMX_PEXP_SLI_MSI_W1C_ENB0 (0x00011F0000013CF0ull)
#define CVMX_PEXP_SLI_MSI_W1C_ENB1 (0x00011F0000013D00ull)
#define CVMX_PEXP_SLI_MSI_W1C_ENB2 (0x00011F0000013D10ull)
#define CVMX_PEXP_SLI_MSI_W1C_ENB3 (0x00011F0000013D20ull)
#define CVMX_PEXP_SLI_MSI_W1S_ENB0 (0x00011F0000013D30ull)
#define CVMX_PEXP_SLI_MSI_W1S_ENB1 (0x00011F0000013D40ull)
#define CVMX_PEXP_SLI_MSI_W1S_ENB2 (0x00011F0000013D50ull)
#define CVMX_PEXP_SLI_MSI_W1S_ENB3 (0x00011F0000013D60ull)
#define CVMX_PEXP_SLI_MSI_WR_MAP   CVMX_PEXP_SLI_MSI_WR_MAP_FUNC()
static inline u64 CVMX_PEXP_SLI_MSI_WR_MAP_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013C90ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013C90ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023C90ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023C90ull;
	}
	return 0x00011F0000023C90ull;
}

#define CVMX_PEXP_SLI_PCIE_MSI_RCV CVMX_PEXP_SLI_PCIE_MSI_RCV_FUNC()
static inline u64 CVMX_PEXP_SLI_PCIE_MSI_RCV_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013CB0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013CB0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023CB0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023CB0ull;
	}
	return 0x00011F0000023CB0ull;
}

#define CVMX_PEXP_SLI_PCIE_MSI_RCV_B1 CVMX_PEXP_SLI_PCIE_MSI_RCV_B1_FUNC()
static inline u64 CVMX_PEXP_SLI_PCIE_MSI_RCV_B1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010650ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010650ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028650ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028650ull;
	}
	return 0x00011F0000028650ull;
}

#define CVMX_PEXP_SLI_PCIE_MSI_RCV_B2 CVMX_PEXP_SLI_PCIE_MSI_RCV_B2_FUNC()
static inline u64 CVMX_PEXP_SLI_PCIE_MSI_RCV_B2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010660ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010660ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028660ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028660ull;
	}
	return 0x00011F0000028660ull;
}

#define CVMX_PEXP_SLI_PCIE_MSI_RCV_B3 CVMX_PEXP_SLI_PCIE_MSI_RCV_B3_FUNC()
static inline u64 CVMX_PEXP_SLI_PCIE_MSI_RCV_B3_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010670ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010670ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028670ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028670ull;
	}
	return 0x00011F0000028670ull;
}

static inline u64 CVMX_PEXP_SLI_PKTX_CNTS(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000012400ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000012400ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000100B0ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000100B0ull + (offset) * 0x20000ull;
	}
	return 0x00011F00000100B0ull + (offset) * 0x20000ull;
}

#define CVMX_PEXP_SLI_PKTX_ERROR_INFO(offset) (0x00011F00000100C0ull + ((offset) & 63) * 0x20000ull)
static inline u64 CVMX_PEXP_SLI_PKTX_INPUT_CONTROL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000014000ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010000ull + (offset) * 0x20000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010000ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010000ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_PEXP_SLI_PKTX_INSTR_BADDR(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000012800ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000012800ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010010ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010010ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010010ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_PEXP_SLI_PKTX_INSTR_BAOFF_DBELL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000012C00ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000012C00ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010020ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010020ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010020ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_PEXP_SLI_PKTX_INSTR_FIFO_RSIZE(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013000ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013000ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010030ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010030ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010030ull + (offset) * 0x20000ull;
}

#define CVMX_PEXP_SLI_PKTX_INSTR_HEADER(offset) (0x00011F0000013400ull + ((offset) & 31) * 16)
static inline u64 CVMX_PEXP_SLI_PKTX_INT_LEVELS(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000014400ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000100A0ull + (offset) * 0x20000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000100A0ull + (offset) * 0x20000ull;
	}
	return 0x00011F00000100A0ull + (offset) * 0x20000ull;
}

#define CVMX_PEXP_SLI_PKTX_IN_BP(offset)    (0x00011F0000013800ull + ((offset) & 31) * 16)
#define CVMX_PEXP_SLI_PKTX_MBOX_INT(offset) (0x00011F0000010210ull + ((offset) & 63) * 0x20000ull)
static inline u64 CVMX_PEXP_SLI_PKTX_OUTPUT_CONTROL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000014800ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010050ull + (offset) * 0x20000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010050ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010050ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_PEXP_SLI_PKTX_OUT_SIZE(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010C00ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010C00ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010060ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010060ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010060ull + (offset) * 0x20000ull;
}

#define CVMX_PEXP_SLI_PKTX_PF_VF_MBOX_SIGX(offset, block_id)                                       \
	(0x00011F0000010200ull + (((offset) & 1) + ((block_id) & 63) * 0x4000ull) * 8)
static inline u64 CVMX_PEXP_SLI_PKTX_SLIST_BADDR(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000011400ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011400ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010070ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010070ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010070ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_PEXP_SLI_PKTX_SLIST_BAOFF_DBELL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000011800ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011800ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010080ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010080ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010080ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_PEXP_SLI_PKTX_SLIST_FIFO_RSIZE(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000011C00ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011C00ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010090ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010090ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010090ull + (offset) * 0x20000ull;
}

#define CVMX_PEXP_SLI_PKTX_VF_INT_SUM(offset) (0x00011F00000100D0ull + ((offset) & 63) * 0x20000ull)
#define CVMX_PEXP_SLI_PKTX_VF_SIG(offset)     (0x00011F0000014C00ull + ((offset) & 63) * 16)
#define CVMX_PEXP_SLI_PKT_BIST_STATUS	      (0x00011F0000029220ull)
#define CVMX_PEXP_SLI_PKT_CNT_INT	      CVMX_PEXP_SLI_PKT_CNT_INT_FUNC()
static inline u64 CVMX_PEXP_SLI_PKT_CNT_INT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000011130ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011130ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000029130ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000029130ull;
	}
	return 0x00011F0000029130ull;
}

#define CVMX_PEXP_SLI_PKT_CNT_INT_ENB	(0x00011F0000011150ull)
#define CVMX_PEXP_SLI_PKT_CTL		(0x00011F0000011220ull)
#define CVMX_PEXP_SLI_PKT_DATA_OUT_ES	(0x00011F00000110B0ull)
#define CVMX_PEXP_SLI_PKT_DATA_OUT_NS	(0x00011F00000110A0ull)
#define CVMX_PEXP_SLI_PKT_DATA_OUT_ROR	(0x00011F0000011090ull)
#define CVMX_PEXP_SLI_PKT_DPADDR	(0x00011F0000011080ull)
#define CVMX_PEXP_SLI_PKT_GBL_CONTROL	(0x00011F0000029210ull)
#define CVMX_PEXP_SLI_PKT_INPUT_CONTROL (0x00011F0000011170ull)
#define CVMX_PEXP_SLI_PKT_INSTR_ENB	(0x00011F0000011000ull)
#define CVMX_PEXP_SLI_PKT_INSTR_RD_SIZE (0x00011F00000111A0ull)
#define CVMX_PEXP_SLI_PKT_INSTR_SIZE	(0x00011F0000011020ull)
#define CVMX_PEXP_SLI_PKT_INT		CVMX_PEXP_SLI_PKT_INT_FUNC()
static inline u64 CVMX_PEXP_SLI_PKT_INT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011160ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000029160ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000029160ull;
	}
	return 0x00011F0000029160ull;
}

#define CVMX_PEXP_SLI_PKT_INT_LEVELS (0x00011F0000011120ull)
#define CVMX_PEXP_SLI_PKT_IN_BP	     (0x00011F0000011210ull)
static inline u64 CVMX_PEXP_SLI_PKT_IN_DONEX_CNTS(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000012000ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000012000ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000010040ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010040ull + (offset) * 0x20000ull;
	}
	return 0x00011F0000010040ull + (offset) * 0x20000ull;
}

#define CVMX_PEXP_SLI_PKT_IN_INSTR_COUNTS CVMX_PEXP_SLI_PKT_IN_INSTR_COUNTS_FUNC()
static inline u64 CVMX_PEXP_SLI_PKT_IN_INSTR_COUNTS_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000011200ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011200ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000029200ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000029200ull;
	}
	return 0x00011F0000029200ull;
}

#define CVMX_PEXP_SLI_PKT_IN_INT CVMX_PEXP_SLI_PKT_IN_INT_FUNC()
static inline u64 CVMX_PEXP_SLI_PKT_IN_INT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011150ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000029150ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000029150ull;
	}
	return 0x00011F0000029150ull;
}

#define CVMX_PEXP_SLI_PKT_IN_JABBER    (0x00011F0000029170ull)
#define CVMX_PEXP_SLI_PKT_IN_PCIE_PORT (0x00011F00000111B0ull)
#define CVMX_PEXP_SLI_PKT_IPTR	       (0x00011F0000011070ull)
#define CVMX_PEXP_SLI_PKT_MAC0_SIG0    (0x00011F0000011300ull)
#define CVMX_PEXP_SLI_PKT_MAC0_SIG1    (0x00011F0000011310ull)
#define CVMX_PEXP_SLI_PKT_MAC1_SIG0    (0x00011F0000011320ull)
#define CVMX_PEXP_SLI_PKT_MAC1_SIG1    (0x00011F0000011330ull)
#define CVMX_PEXP_SLI_PKT_MACX_PFX_RINFO(offset, block_id)                                         \
	(0x00011F0000029030ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_PEXP_SLI_PKT_MACX_RINFO(offset) (0x00011F0000011030ull + ((offset) & 3) * 16)
#define CVMX_PEXP_SLI_PKT_MEM_CTL	     CVMX_PEXP_SLI_PKT_MEM_CTL_FUNC()
static inline u64 CVMX_PEXP_SLI_PKT_MEM_CTL_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011120ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000029120ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000029120ull;
	}
	return 0x00011F0000029120ull;
}

#define CVMX_PEXP_SLI_PKT_OUTPUT_WMARK CVMX_PEXP_SLI_PKT_OUTPUT_WMARK_FUNC()
static inline u64 CVMX_PEXP_SLI_PKT_OUTPUT_WMARK_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000011180ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011180ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000029180ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000029180ull;
	}
	return 0x00011F0000029180ull;
}

#define CVMX_PEXP_SLI_PKT_OUT_BMODE	 (0x00011F00000110D0ull)
#define CVMX_PEXP_SLI_PKT_OUT_BP_EN	 (0x00011F0000011240ull)
#define CVMX_PEXP_SLI_PKT_OUT_BP_EN2_W1C (0x00011F0000029290ull)
#define CVMX_PEXP_SLI_PKT_OUT_BP_EN2_W1S (0x00011F0000029270ull)
#define CVMX_PEXP_SLI_PKT_OUT_BP_EN_W1C	 (0x00011F0000029280ull)
#define CVMX_PEXP_SLI_PKT_OUT_BP_EN_W1S	 (0x00011F0000029260ull)
#define CVMX_PEXP_SLI_PKT_OUT_ENB	 (0x00011F0000011010ull)
#define CVMX_PEXP_SLI_PKT_PCIE_PORT	 (0x00011F00000110E0ull)
#define CVMX_PEXP_SLI_PKT_PKIND_VALID	 (0x00011F0000029190ull)
#define CVMX_PEXP_SLI_PKT_PORT_IN_RST	 (0x00011F00000111F0ull)
#define CVMX_PEXP_SLI_PKT_RING_RST	 CVMX_PEXP_SLI_PKT_RING_RST_FUNC()
static inline u64 CVMX_PEXP_SLI_PKT_RING_RST_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000111E0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000291E0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000291E0ull;
	}
	return 0x00011F00000291E0ull;
}

#define CVMX_PEXP_SLI_PKT_SLIST_ES  (0x00011F0000011050ull)
#define CVMX_PEXP_SLI_PKT_SLIST_NS  (0x00011F0000011040ull)
#define CVMX_PEXP_SLI_PKT_SLIST_ROR (0x00011F0000011030ull)
#define CVMX_PEXP_SLI_PKT_TIME_INT  CVMX_PEXP_SLI_PKT_TIME_INT_FUNC()
static inline u64 CVMX_PEXP_SLI_PKT_TIME_INT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000011140ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000011140ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000029140ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000029140ull;
	}
	return 0x00011F0000029140ull;
}

#define CVMX_PEXP_SLI_PKT_TIME_INT_ENB	  (0x00011F0000011160ull)
#define CVMX_PEXP_SLI_PORTX_PKIND(offset) (0x00011F0000010800ull + ((offset) & 31) * 16)
static inline u64 CVMX_PEXP_SLI_S2M_PORTX_CTL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013D80ull + (offset) * 16;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013D80ull + (offset) * 16;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000013D80ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000013D80ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000023D80ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000023D80ull + (offset) * 16;
	}
	return 0x00011F0000023D80ull + (offset) * 16;
}

#define CVMX_PEXP_SLI_SCRATCH_1 CVMX_PEXP_SLI_SCRATCH_1_FUNC()
static inline u64 CVMX_PEXP_SLI_SCRATCH_1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000103C0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000103C0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000283C0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000283C0ull;
	}
	return 0x00011F00000283C0ull;
}

#define CVMX_PEXP_SLI_SCRATCH_2 CVMX_PEXP_SLI_SCRATCH_2_FUNC()
static inline u64 CVMX_PEXP_SLI_SCRATCH_2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000103D0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000103D0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000283D0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000283D0ull;
	}
	return 0x00011F00000283D0ull;
}

#define CVMX_PEXP_SLI_STATE1 CVMX_PEXP_SLI_STATE1_FUNC()
static inline u64 CVMX_PEXP_SLI_STATE1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010620ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010620ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028620ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028620ull;
	}
	return 0x00011F0000028620ull;
}

#define CVMX_PEXP_SLI_STATE2 CVMX_PEXP_SLI_STATE2_FUNC()
static inline u64 CVMX_PEXP_SLI_STATE2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010630ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010630ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028630ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028630ull;
	}
	return 0x00011F0000028630ull;
}

#define CVMX_PEXP_SLI_STATE3 CVMX_PEXP_SLI_STATE3_FUNC()
static inline u64 CVMX_PEXP_SLI_STATE3_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000010640ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000010640ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000028640ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000028640ull;
	}
	return 0x00011F0000028640ull;
}

#define CVMX_PEXP_SLI_TX_PIPE	 (0x00011F0000011230ull)
#define CVMX_PEXP_SLI_WINDOW_CTL CVMX_PEXP_SLI_WINDOW_CTL_FUNC()
static inline u64 CVMX_PEXP_SLI_WINDOW_CTL_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000102E0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F00000102E0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F00000282E0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F00000282E0ull;
	}
	return 0x00011F00000282E0ull;
}

#endif
