/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package jdk.test.lib.cli;

import jdk.test.lib.cli.predicate.CPUSpecificPredicate;

/**
 * Base class for command line options tests that
 * requires specific CPU arch or specific CPU features.
 */
public abstract class CPUSpecificCommandLineOptionTest
        extends CommandLineOptionTest {
    /**
     * Creates new CPU specific test instance that does not
     * require any CPU features.
     *
     * @param cpuArchPattern Regular expression that should
     *                       match os.arch.
     */
    public CPUSpecificCommandLineOptionTest(String cpuArchPattern) {
        this(cpuArchPattern, null, null);
    }

    /**
     * Creates new CPU specific test instance that does not
     * require from CPU support of {@code supportedCPUFeatures} features
     * and no support of {@code unsupportedCPUFeatures}.
     *
     * @param cpuArchPattern Regular expression that should
     *                       match os.arch.
     * @param supportedCPUFeatures Array with names of features that
     *                             should be supported by CPU. If {@code null},
     *                             then no features have to be supported.
     * @param unsupportedCPUFeatures Array with names of features that
     *                               should not be supported by CPU.
     *                               If {@code null}, then CPU may support any
     *                               features.
     */
    public CPUSpecificCommandLineOptionTest(String cpuArchPattern,
            String supportedCPUFeatures[], String unsupportedCPUFeatures[]) {
        super(new CPUSpecificPredicate(cpuArchPattern, supportedCPUFeatures,
                unsupportedCPUFeatures));
    }
}
