---
layout: default
title: Dual-Screen PDF Viewer
---

This website aims to provide some documentation for the dspdfviewer
project. Its main purpose is to decouple installation instructions
from the primary sourcecode tree.
You can [inspect the sourcecode on github.][sourcecode]

It is a work-in-progress, and accepting suggestions and help.
Read further down on how to get involved.

## What is dspdfviewer?
dspdfviewer is a pre-rendering and caching (read: *fast*) full-screen pdf
viewer specifically designed for latex-beamer presentations,
that were created with the `show notes on second screen=right` option.

It will take your double-width PDF file, split it in half, render the
left half to the audience (via a beamer) and the right half - which will
contain the notes you entered in your LaTeX source - on your laptop screen.

In addition, your laptop screen will contain some counters and a wall-clock,
which may help you time your presentation right.

Both screens will be rendered and scaled completely independent of each other,
so you can use two screens with different resolutions and/or aspect ratios,
such as your 16:10 laptop screen and a 4:3 beamer, or the other way around.
Please use both devices' native resolutions for maximum image quality.

## How do I use it?

First of all: You should have a pdf generated by `latex-beamer` with
the `show notes on second screen=right` option.
While you can leave the `=right` part out (is the default if not specified)
dspdfviewer will not work correctly if you specify any other direction;
It always assumes the left half is for the audience and the right half
is for the presenter.

Simply call `dspdfviewer /path/to/your/presentation.pdf` to start.
If you start `dspdfviewer` without a command-line parameter,
it will use a file-open-dialog-window to ask you for a PDF file.

Once its loaded, try the following commands:

* Swap Screens (If the audience sees the clock and the note page)
  * Keyboard: `S`, `F12`
* Advance one frame
  * Mouse: `Left-Click`, `Wheel-Down`
  * Keyboard: `Right`, `Down`
* Back one frame
  * Mouse: `Right-Click`, `Wheel-Up`
  * Keyboard: `Left`, `Up`
* Keybindings popup
  * Keyboard: `F1` or `?`
* Quit program
  * Keyboard: `Q`

For a more complete list, please read the program's manual page.
With dspdfviewer installed, a manual page corresponding to your installed version
should be available as `man dspdfviewer`.

In addition, you can [access the manpage online]. Note that the online version
is generated from git and may contain commands not yet in your installation.
You can also read the [release manpage] from version v1.14.

[access the manpage online]: manpage.html
[release manpage]: manpage-release.html

If the manual doesn't answer your question, feel free to open a ticket in
the [issues system] requesting help or clarification.

## How do I install it?

This varies depending on your operating system.
Please follow the specific instructions:

* Linux and other Unixes
  * [Debian](installation/debian.html)
  * [Ubuntu](installation/ubuntu.html)
  * [Gentoo](installation/gentoo.html)
  * [Arch](installation/arch.html)
  * [Generic (from source)](installation/)
  * [Mac OS](installation/macos.html)
* [Windows](installation/windows.html)

If your system isn't listed here, please try the Generic instructions.
Feel free to open a ticket in the [issues system] asking for help if something goes wrong.

[issues system]: https://github.com/dannyedel/dspdfviewer/issues

## How do I contribute?

First, you help a lot if you use the software and report any problems or
missing features in the [issues system].

If you want to help on development, please use github's
amazing [pull request] feature.

The full [sourcecode], which includes [this website], is available
to view and improve,
and any help is greatly appreciated!

[sourcecode]: https://github.com/dannyedel/dspdfviewer
[this website]: https://github.com/dannyedel/dspdfviewer/tree/master/docs/
[pull request]: https://help.github.com/articles/using-pull-requests/

## Who built this program?

Github maintains a [contributors] list for the sourcecode.

[contributors]: https://github.com/dannyedel/dspdfviewer/graphs/contributors

## Contact information

If you have any questions that don't fit the [issues system],
you can contact me ([@dannyedel]) by e-mail at `mail@danny-edel.de`.

Since e-mails on the internet are everything but secure,
please use my [gpg key] to send encrypted.

[@dannyedel]: https://github.com/dannyedel
[gpg key]: https://sks-keyservers.net/pks/lookup?op=get&search=0xF132F84C7183343C
