# -*- coding: iso-8859-1 -*-
# Copyright (C) 2013-2014 Bastian Kleineidam
"""
Comicfury comic strips
"""
from re import compile
from ..scraper import make_scraper
from ..util import tagre
from ..helpers import bounceStarter


_imageSearch = compile(tagre("img", "src", r'([^"]+)', after='comicimage'))
_prevSearch = compile(tagre("a", "href", r'(/comics/\d+)', after='prev'))
_nextSearch = compile(tagre("a", "href", r'(/comics/\d+)', after='next'))

def add(name, url, description):
    classname = 'ComicFury_%s' % name

    @classmethod
    def namer(cls, imageUrl, pageUrl):
        parts = pageUrl.split('/')
        num = parts[-1]
        return "%s_%s" % (name, num)

    globals()[classname] = make_scraper(classname,
        name='ComicFury/' + name,
        description = description,
        url = url,
        stripUrl = url + '%s',
        starter = bounceStarter(url, _nextSearch),
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        help = 'Index format: none',
        namer = namer,
    )

# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('12yearslater', 'http://12yearslater.webcomic.ws/', u'This is a strip comic about two different moments. One of them happens a certain number of years after the other- I bet you can guess how many.')
add('30years', 'http://30years.webcomic.ws/', u"a life and time of a cartoon's named miss j and the am and the it long hard road to be a webcomic named jenffer's show")
add('6colorstories', 'http://6colorstories.webcomic.ws/', u'')
add('933dollars', 'http://933dollars.webcomic.ws/', u'')
add('AAB', 'http://AAB.webcomic.ws/', u"This is where I plan on sticking all my non-cannon Frostbound, and miscellaneous art for your enjoyment. Any fan art that get's draw for Frostbound will also end up here.")
add('Abrickishspacecomic', 'http://Abrickishspacecomic.webcomic.ws/', u'A photographic comic made with LEGO space.')
add('AccidentallyonPurpose', 'http://Accidentally-on-Purpose.webcomic.ws/', u'A Warlock, a Guitarist, and a Host for a demon live under the same roof and are in a three way relationship. As things go upside down and right side up again, there seems to be quite a few issues in their lives, even though the three of them seem to still make it through okay, minus the huge bills they have to pay to their landlord...')
add('Acroalis', 'http://acroalis.webcomic.ws/', u'Acroalis its a fantasy world wich has been in peace with every one on its side, that wasant when everything changed after 2 meteors collided into the ground, never knowing what that was the villagers and others citizens of acroalis ignored it thinking it was just a natural phenomena, when actually the 2 meteors conteined a much more secred source , one that will change all acroalis.')
add('Actingout', 'http://actingout.webcomic.ws/', u"When a bunch of kids with very different personalities come together in their school's drama club, a lot more goes on in the auditorium than you may think! Follow the dramatic lives of Clinton, Ollie, Tasha, and the rest of the gang as they set the scene and put on a heck of a performance, both on and off the stage! Updates are on Sundays and Thursdays!")
add('AdventuresofMaggie', 'http://AdventuresofMaggie.webcomic.ws/', u'Follow the Adventures of Captain Maggie Armond Averel the Fourth and her Crew as they go on fantastical adventures aboard the mighty airship THE DAMP BROAD! Girls, Magic, Laughs(?), Poor choices! All of these things and more! Updates Saturdays.')
add('Aether', 'http://aether.webcomic.ws/', u'')
add('Afairtrade', 'http://afairtrade.webcomic.ws/', u'')
add('Aforeverquest', 'http://aforeverquest.webcomic.ws/', u'hi this is like my life but it is drawn like a cartoon it is ok sometimes my friends say i should make it better. i talk about girls and dating and relationships and jobs and millennials in it.')
add('Afrodays', 'http://afrodays.webcomic.ws/', u'Inspired By Life Nope, nope turkeys')
add('Ahappierkindofsad', 'http://ahappierkindofsad.webcomic.ws/', u'A Happier Kind Of Sad is a weekly photocomic about hoping things will seem better in the morning. Updates Mondays and Wednesdays!')
add('Albinobros', 'http://albinobros.webcomic.ws/', u'Two guys at work shoot the breeze and do their best to not break the fourth wall.')
add('Alexanderandlucas', 'http://alexanderandlucas.webcomic.ws/', u'Alex and Lucas are roomies and old friends. Follow their lives as they try to make it through the life of high school graduates. Hilarity, and mainly drama, ensues! This is a reboot of a previous comic I had on Drunk Duck.')
add('Alignment', 'http://Alignment.webcomic.ws/', u"In a world that could only exist in a table top RPG, follow Goredamn the to-be Dungeon Master as he stumbles into trouble, blurring the lines of heroes and villains, changing the \u201ccore rules\u201d of reality, and discovering a plot that's way more threatening than he'll ever be! Roll for initiative and read the next critical hit in fantasy adventure: Alignment!")
add('Alittlebitofeverything', 'http://alittlebitofeverything.webcomic.ws/', u"Gag-a-day comic featuring the adventures of Lucky, Swifty, their friends & family. Expect laughs, classic muscle cars, and stuff blowing up... but hopefully not the muscle cars. We don't have the budget to replace them.")
add('Allthebbqsauce', 'http://allthebbqsauce.webcomic.ws/', u'A comedy strip about antics and semantics.')
add('Alone', 'http://Alone.webcomic.ws/', u'One day when Arianna wakes up, something\xb4s different... The entire world is gone, she sets out on an exciting adventure to find out what\xb4s going on.')
add('Alya', 'http://Alya.webcomic.ws/', u'"Alya The Last Child of Light," is the story of a young woman born of a star and her fight to save all life from an ancient race who seeks to destroy it.')
add('AmericanNerd', 'http://AmericanNerd.webcomic.ws/', u"The adventures of the epynonymous nerd in Japan, going through the usual JRPG motions alongside a blonde amnesiac protagonist, a nature spirit, a Digital monster, a Sonic the Hedgehog cosplayer, and a few characters I haven't gotten around to yet. Whacky shennanigans ensue.")
add('Americanextremists', 'http://americanextremists.webcomic.ws/', u"Politics 'n stuff")
add('Amtheatre', 'http://amtheatre.webcomic.ws/', u"Do you like mid-low fantasy? Do you like comedy? Are you not offended by characters who are missing important appendages? Maybe you should read this. Or maybe not. Is this another DnD comic? No. But is it filled with cheap pop culture references? Hell no. Why is the main character a girl with no legs or right arm? Because I'm a sick human being, okay???")
add('AnK', 'http://AnK.webcomic.ws/', u"Synopsis: For the first time in millennia, Arecace is on the brink of war. Cyden, an Esarian rebel looking to achieve equal rights for his race conspires to overthrow the world's central government through violence and attrition. His nephew, Drake, may be the only one who can stop him. Both want to enlist the help of an young Esarian, Mathaeis who has only just learned what he is, and may be the key to either one's success by his association to a once formidable Esarian, Azrisar. Themes: power, betrayal, civil rights, liability Genre: fantasy, political thriller, action Written Summary of completed chapters here: sta.sh/08f2dfrpf8u")
add('Angryfaerie', 'http://angryfaerie.webcomic.ws/', u"Not all faeries are happy, cheerful little forest creatures. One, in fact, is downright ornery. She's mean-spirited, violent.. and ANGRY. Welcome to the twisted world of Angry Faerie.")
add('Angstcomic', 'http://angstcomic.com/', u'Full of self pity and demotivational occurrences, Angst is a comic that follows the life of it\'s author Christian A. Set primarily during his final years at highschool, but continues on past that into his early years at university (and possibly even further). Not every comic presented here has a punch line. Heck! Very few of them have a punch line. The comic is more of a cathartic exercise for Christian A. to get his worries off his mind. You may find some ironic, poignant, or maybe, at the very least, relatable. If not, then you can always laugh at the bad, crudely drawn characters. Angst can be described as the Catcher in the Rye of webcomics mixed with a bit of American Splendor... but not as good. You probably won\'t like. Nobody will probably like it. But that\'s okay. Nobody ever seems to like things anymore. Updates Tuesday, Thursday, Saturday. Why? Because we\'re such INDIE kids here and can\'t - just CAN\'T - update like everyone else on Mon, Wed, Fri! That just aint right! You may have noticed that this description is longer than most that you\'d find for other webcomics... Think of it what you will. Whether it be that other comics don\'t need such a long description because they\'re just THAT GOOD, and this one isn\'t... or maybe this comic is more for people who like to read a lot (you must be if you\'re willing to read through the walls of text in the comics)... To remedy such a long, probably boring description, here\'s a quick line that will likely appeal to the masses, and send this comic into webcomic stardom! "SEX! BEER! BOOBS! Politically Incorrect humour? We got that! We\'re great and you know it!"')
add('Antarcticbroadcasting', 'http://antarcticbroadcasting.webcomic.ws/', u'Stickmen and their shenanigans-- inspired by life and other disasters.')
add('Anthrosanddungeons', 'http://Anthrosanddungeons.webcomic.ws/', u'Welcome to the Inn of the Anthros and Dungeons. Pull up a bar stool and order a pint. Listen to the tales told by the owners of this fine establishment of their years as adventurers and how they escaped their births in bondage. They have many tales to tell, and are always seeking an ear to listen to their tales.')
add('Applepine', 'http://Applepine.webcomic.ws/', u'Follow Applepine as he experiences life one problem at a time, with help from his friends of course! Each with their own way of solving the enigma of life, they help Applepine find his way through trouble, girls, and adventure in this ongoing series.')
add('ArachnidGoddess', 'http://ArachnidGoddess.webcomic.ws/', u"Dark modern fantasy! Born of a severe stroke of individuality & nihilism, 'Ahab' relates more to vermin & outcasts. Join the narrative as she abandons her humanity & finds herself in the gloom. Features peril, BDSM, & disturbing scenes.")
#add('ArchportCityChronicles', 'http://ArchportCityChronicles.webcomic.ws/', u"The best guessed center of the universe has an adventure for everyone...It's amazing what you can stumble into... Dissatisfied on what was supposed to be a fun trip it was only a matter of time until adventure lured Joe in. Now a group of discredited bounty hunters with a dangerous target have dragged him along for the ride.. Updates Tu and Thr... IF THE PAGES GO UP SIDE WAYS LET ME KNOW THE FILES SEEM TO BE MESSING UP FOR SOME REASON SOMETIMES!!! New opening is UP!!")
add('AreYouDoneYet', 'http://AreYouDoneYet.webcomic.ws/', u'A series of cartoons about raising a large family in the traditional three panel format.')
add('Area42', 'http://area42.webcomic.ws/', u'Area 42 is the story of an amateur paranormal investigator and the alien he\'s been forced to room with. Watch as they tackle the tough issues, like why that one cosplayer is such a jerk and why "Who would win?" questions are inherently flawed.')
add('Armybrat', 'http://armybrat.webcomic.ws/', u'')
add('Asperchu', 'http://asperchu.webcomic.ws/', u"Welcome to the grand world of ASPERCHU, the electric/aspergers type hedgehog pokemon! Join ASPERCHU in his adventures to save Albville from the evils of evil villains of the PVCC and more. I am so greatful to have my TRUE and LOYAL fanbase, which I would never have had if not for the leadership and artistic genius shown to guide me by Christian Weston Chandler. I welcome all fans who wish to contribute to ASPERCHU'S adventures, as without them my power would be none!")
add('Astralaves', 'http://astralaves.webcomic.ws/', u'a comic I am working on. Sort of a fantasy thing.')
add('Atm', 'http://atm.webcomic.ws/', u'')
add('Atomicmonkey', 'http://atomicmonkey.webcomic.ws/', u'Welcome to Pandora City where monsters, demons, and mechanical menaces roam. Who can stand before this onslaught? Are the citizens doomed? Will heroes like the Killer Bee, Arcane, and the Wildborn be enough to prevent the forces of evil from finally gaining control of the city and its secrets?')
add('Atowncalledalandale', 'http://atowncalledalandale.webcomic.ws/', u'Welcome to the town called Alandale. Home to the supernatural and the bizarre. Follow the misadventures of a group of young people as they navigate everyday life and deal with their own strange and unique problems.')
add('Augustosclassic', 'http://augustos-classic.webcomic.ws/', u'When three kids escape from a shady research facility, where humans are being experimented on and dark deeds are happening unnoticed by the rest of the world, they find themselves in the middle of the desert, with no food, no water, and barely able to get along with each other. When their only friend in the world, Emily, is "kidnapped" by government officials, they boldly and stubbornly chase after her, hoping to find her as well as some clues about their past. But Emily is not all that she seems... On the way, they run into several strange and bizarre characters who rarely help and often cause more trouble for them. Augustos is a purely adventurous story with a bit of action and humor squeezed into it!')
add('Awkwardshelby', 'http://awkwardshelby.webcomic.ws/', u"Awkward Shelby is a slice-of-life comic that follows the author closely in the way that she speaks, thinks, and acts in certain situations as well as some journal-like comic strips of real-life occurences. Shelby started her webcomic, Awkward Shelby, in June of 2012 as a means of fulfilling time the summer after she graduated from high school. Since then, she has gained thousands of followers from 12 different countries and has received a 4.91 (148 votes) on Comicfury. The webcomic in its run so far, already has over 200 strips and is currently featured as a weekly comic in The Santa Fe University of Art and Design's oncampus magazine, The Jackalope. *NEW* Awkward Shelby now updates everyday except Sundays at 10AM (unless otherwise stated) Visit the online store: http://skreened.com/awkwardshelby")
add('BASO', 'http://BASO.webcomic.ws/', u'An epic space opera')
add('BATB', 'http://BATB.webcomic.ws/', u'A lushly conceived and meticulously researched retelling of the classic Fairy Tale, Beauty and The Beast.')
add('BTTF', 'http://BTTF.webcomic.ws/', u'A man is residing in his home when he discovers that his fridge has vanished under mysterious circumstances. Updating Mondays, Wednesdays and Fridays.')
add('Baby001', 'http://baby001.webcomic.ws/', u'Parenthood hangs over me like a pukey sword of Damocles. This is a web comic about nervously looking up.')
add('BabyBatman', 'http://BabyBatman.webcomic.ws/', u"It's Batman, but as a baby. Well technically he's more of a small child but that doesn't have the same ring to it. Updates whenever")
#add('Ballandchain', 'http://ballandchain.webcomic.ws/', u'Sliver is as a modern-day gladiator who fights with a ball and chain. Her life takes an unexpected turn after she meets Dorioth, a scatter-brained pick pocket thief. The story takes place in the wake of a nuclear disaster, which has brought forth the generation known as "Nuclear Babies" (people born with strange mutations). Updates irregularly!')
#add('Barkingcrayon', 'http://barkingcrayon.webcomic.ws/', u'Comics with a Conservative slant.')
add('Baseballcapsandtiaras', 'http://Baseballcapsandtiaras.webcomic.ws/', u'A tomboy, 16 year old Paige, and a girly girl, 8 year old Katie, discover a portal to a magical world in their house. The magical world is fraught with political dangers.')
add('BattleoftheRobofemoids', 'http://Battle-of-the-Robofemoids.webcomic.ws/', u'Robofemoids rocket off into space and meet up with lots of people who prove difficult to live with. Along the way they strip more for conversion and lovingly create more robofemoids and introduce the robohomoid.')
add('Beebleville', 'http://Beebleville.webcomic.ws/', u"A cheesy webcomic following the odd perspective of one man's journey through work, marriage, fatherhood, life, death, and dealing with his wifes' damn cats interwoven with the strange happenings of the world we all inhabit.")
add('Beepclub', 'http://beepclub.webcomic.ws/', u'"Will giant robots ever be in vogue?" Join Phoebe Rivet as she desperately attempts to recruit more members for the designer robot club house, Beep Club. A chick-lit webcomic with giant robots!')
add('Beepolice', 'http://beepolice.webcomic.ws/', u'Bee Police is a comic about government conspiracies, mutant bees, mountain gods, ancient aliens, random monsters, and some aggies living in an out of the way town named Podunk.')
add('BeforeAndAfter', 'http://BeforeAndAfter.webcomic.ws/', u'A group of friends just graduated from high school and have to face what comes next... real life.')
add('Bentelbows', 'http://bentelbows.webcomic.ws/', u"You got some kind of skeleton bag man on hallucinogens, a mummy that's tired of life, and a crocodile that truly appreciates alcohol.")
#add('Bestbrosforever', 'http://bestbrosforever.webcomic.ws/', u'We follow the two main character Glenn and Ted on their journey on a distant planet.')
add('BetaParticles', 'http://BetaParticles.webcomic.ws/', u"This is where things go that don't go elsewhere. For those more curious as to my motives or rationale, see here: [url=http://betaparticles.thecomicseries.com/about/]Click this[/url]")
add('BetweenRounds', 'http://Between-Rounds.webcomic.ws/', u'')
#add('Beyondtheordinary', 'http://Beyondtheordinary.webcomic.ws/', u'')
add('Biblebelt', 'http://biblebelt.webcomic.ws/', u"I'm balancing a 3 1/2 year old on my head as I type this. Truly one of God's miracles. (The simultaneous balancing and typing, not my ability to reproduce.) Feel free to point out my spelling and grammar mistakes. Amen.")
add('Bimorphon', 'http://bimorphon.webcomic.ws/', u'The humans are not alone in the universe, as two small androids travel from planet to planet, attempting to defend them from annihilation. After reaching Earth, they meet their human hosts and defend it from an evil that\u2019s been unstoppable. Can the humans help the androids protect Earth? Or will they only postpone the inevitable?')
add('Biosyte', 'http://biosyte.webcomic.ws/', u'Michael Treble, an everyday man who seems to answer any question thrown at him with ease. Explaining things is a jiffy for him. Or so it would seem. He will receive a rather... gross awakening from his "high and mighty" persona when a biological weapon-a prototype parasitic virus- is suddenly introduced into his system. And what do you know?! This thing has been granted the power of sentience! (Occasional Updates)')
add('Birdman', 'http://Birdman.webcomic.ws/', u"While filming a comeback series of Birdman, a 'real' vesion seems to be out and in action")
add('Blessings', 'http://Blessings.webcomic.ws/', u'')
add('BlueBloodHeroes', 'http://BlueBloodHeroes.webcomic.ws/', u'Six children possess a genetic irregularity that grants them super-human powers and turns their blood blue. As criminals and injustice begin to rise in their hometown, they decide to form a superhero team.')
add('Boatcrash', 'http://boatcrash.webcomic.ws/', u'An outlandishly distorted interpretation of the life of a guy that plays a lot of video games.')
add('Bobbythefetus', 'http://bobbythefetus.webcomic.ws/', u"A fetal adventures of a fetus (which is not an e!). It features a Svalbardian/Swedish fetus(which might be a fetus, but isn't) named Bobby located somewhere in Iceland, adjustment disordered narrator who hates being seen, Roberta the fetus (who is not an e!) who is Bobby's girlfriend, the author himself, a sock puppet and a minor deity destined to ruin the world... This is a mirror of the DrunkDuck comic with the same name and author...")
add('Booksdontworkhere', 'http://booksdontworkhere.webcomic.ws/', u'A meta flavored webcomic with no 4th wall and a plot about a webcomic actress and the challenges she has to face. You know imaginary scripts, unreliable narrators, plot holes, meta walls, wacky physics, mad science, and budget cuts. Updates Monday, Wednesday, and Friday.')
add('Boritom', 'http://boritom.webcomic.ws/', u'The scintillating adventures of an alien, a redneck and a floating orb of death in the bucolic setting of fictional "Utopia Dell, Arizona." The strips currently running are all of the "classic Boritom" adventures from the strip\'s original run from 2000 to 2006. In all, there were about 325 strips, so I am currently updating 5 days a week in order to get people caught up. As we get closer to the "Big Day," where brand new strips start coming up, there will be lots of information and ballyhoo letting everyone know what to expect... to an extent. Spoilers, Doctor... Spoilers... Once new strips start coming out, however, the updates will probably scale back to once or twice a week.')
add('BrokenReality', 'http://BrokenReality.webcomic.ws/', u'This story revolves around two teenage boys who suddenly find themselves living in japan for no apparent reason. Joined by twin Japanese girls, The four of them now seem to be living their lives in a world where the rules of reality are constantly being broken in one way or another.')
add('Bulletproof', 'http://bulletproof.webcomic.ws/', u'In Junction City, there are men and women with strange powers and abilities, the Omega Humans. Ostracized by society, many turn to crime, while a few are employed by JCORP to keep the city safe. But can a corporation be trusted with law enforcement? Bulletproof is a B&W superhero comic set in a dystopian near-future city.')
add('Bustysolar', 'http://bustysolar.webcomic.ws/', u'The space adventures of Busty Solar and her space police team. Lots of strange jokes and naughty fun.')
add('Cannonadeofhogwash', 'http://cannonadeofhogwash.webcomic.ws/', u'As the title suggests, this is a cannonade of hogwash. Updated almost daily.')
add('CatHero', 'http://CatHero.webcomic.ws/', u"Cat Hero's epic Catventures as an Hero, starring Cat Hero as Cat Hero, by Cat Hero; is a graphical representation of the (mis)adventures of a cat-person named Cat Hero, whose arch-nemesis is CatoreH, a life-sized cardboard cutout of a (very) badly drawn cat-person. Half a quick comic, half an experiment to see if single-panel gag-a-day style can actually convey a story, and be good doing it.")
#add('Cataclysm', 'http://cataclysm.webcomic.ws/', u'Set on the last remaining hospitable island on a frozen world, a covert faction known as Militia attempts to overthrow a utopian civilization and their benevolent rulers, The Council.')
add('Catwithgoggles', 'http://catwithgoggles.webcomic.ws/', u'Cat with Goggles is a collection of daily musing, interesting stuff, encounters of Elisha and her friends (real and imaginary) in the form of comics.')
add('Cautionarytales', 'http://cautionarytales.webcomic.ws/', u'A webcomic, caution sign style.')
add('Chocolava', 'http://chocolava.webcomic.ws/', u'An awesome webcomic by The BIG Four (email: chocolavacomics[at]gmail[dot]com)')
add('ChristianHumberReloaded', 'http://ChristianHumberReloaded.webcomic.ws/', u"Once upon a time, an unpopular kid in a boarding school had his anime taken away and he turned to writing. He created what is simultaneously the worst and the best story ever created. This is that story's comic-book interpretation. You have been warned. Christian Humber Reloaded rips off/steals from every video game and anime ever made. Yes, even that one. It also has Bionicles. And Hitler. And it's supposed to be serious.")
add('ChronoRedux', 'http://ChronoRedux.webcomic.ws/', u'Chrono Redux is a retelling of the classic Chrono Trigger game, except that it makes fun of it. Truthfully, I mock it because I love it.')
add('CityOfDream', 'http://CityOfDream.webcomic.ws/', u'Taking the mixture of Fantasy, Modern and slice of life (with a ton of details on philosophy) is what composes this work. Also the idea is not going for the heroic epic side, for this is made to work with the view of the sidelines not the "hero". You have been warned... Updates Saturday or Sunday')
#add('Clockworkatrium', 'http://clockworkatrium.webcomic.ws/', u'In a misguided attempt to develop their full potential for success, students at a German university are forced to participate in a campus chess "game" in which they are the pieces and the captures could consist of murder. (This is a mirror. Visit the main site at www.clockwork-atrium.com)')
add('ClydenOwen', 'http://ClydenOwen.webcomic.ws/', u'"Clyde n Owen" is a comic strip with a love for randomness.')
add('Cockeyed', 'http://cockeyed.webcomic.ws/', u'A weekly comic of cartoons strips, spoofs etc.')
add('CoftheA', 'http://CoftheA.webcomic.ws/', u'It is a fantasy comic that is loosely about philosophy. It features real pictures and a disturbing amount of software effects to create a drawn feel. Sadly I think it would be less work to just draw it. The main character, Jim Towers" is played by me and represents some sort of mental condition as the majority of the humour in the comic is the character played by me, calling out snarky remarks to me... the author/narrator. Hope you enjoy. Updates are every Friday for now.')
add('Comingapartments', 'http://comingapartments.webcomic.ws/', u'Apartment life is never an adventures. But J.B. and Diri are sure as hell gonna try to make it one.')
add('CompanyMan', 'http://CompanyMan.webcomic.ws/', u"Company Man is about the lives of the employees of the F.R.J. Media Group and the celebrities they represent. The antics at the office are silly but it makes you laugh. It's much funnier than your last team meeting!")
add('Complicatedd', 'http://Complicatedd.webcomic.ws/', u'After years of torment and hardship, Ciz, Sora, and Adri fall into a sense of normalcy as their lives begin to stabilize. Their short peace is shattered, however, when a familiar face surmounts a violent takeover of the planet. Humans fall victim to the tyranny which once plagued their past as the world collapses around them and life becomes a brutal race just to survive. Ciz and Adri are forced to reunite with old enemies, but can they put aside their differences to mount a successful defense against the looming war? In the end, who will stay alive when THEY come? (An Invader Zim Fan Comic)')
add('Conplicated', 'http://Conplicated.webcomic.ws/', u'When sarcastic but charitable Amber Pennicastle follows a handsome panhandler to his secret hideaway, her life turns upside-down in this action/romantic comedy. (Revised and color version of Geode Corner).')
add('Contestedterritory', 'http://contestedterritory.webcomic.ws/', u'What happens when two small girls from either side of the war meet? What happens when they become best friends? Contested Territory is a story about just that; a young Orc named Thook and a rescued Night Elf with no memories named Kithra. Instantly inseparable, the girls face Azeroth together, testing the boundaries of friendship, family and faction as they learn what makes them so similar, yet so different. Raised by loving but cautious Auntie and Uncle, Aguul and Kross, as well as a dear tauren friend, Winthir, Thook and Kithra learn what happens when two enemies meet before they are old enough to understand hatred. This is a fan-based comic set in Azeroth, home of World of Warcraft. This comic was originally written in 2008, with the prologue, and chapters one and two taking place during Vanilla. The comic is done entirely by hand: pencil, pen, colored pencil, and scan. Currently, it uploads regularly on Tuesday mornings and Friday mornings. If you do not play WoW, the main thing that you need to know is the hatred between the two factions: the Horde, made up of Orcs, Tauren, Trolls, Undead and later Blood Elves and Goblins, and the Alliance, comprised of Humans, Dwarves, Night Elves, Gnomes and later Draenei and Worgen. Thank you for viewing and feel free to leave a comment or two!')
add('Copypasteandmrbenjy', 'http://copypasteandmrbenjy.webcomic.ws/', u'Copying and pasting characters with wacky hijinks! HI-LARTY ENSUES!')
#add('Cosmicdash', 'http://cosmicdash.webcomic.ws/', u'Follow the adventures of the crew of the Lucky Strike, a cargo-ship exploring a shifting galactic landscape.')
add('Cowtoon', 'http://cowtoon.webcomic.ws/', u'A crazy look into the lives of insane farm animals.')
add('Crawlers', 'http://crawlers.webcomic.ws/', u"Their fate is determined by dice and a set of laws they have become the masters of manipulating. Updated every Tuesday and Thursday at 10AM central time (except during campaign season because I'm running for the Missouri House of Representatives).")
add('Crimsonpixel', 'http://crimsonpixel.webcomic.ws/', u"this is just going to be a series of comics pertaining to things in video games my daily life that i find funny. i'll be updating often (at least once a week), so please enjoy, comment, and share! |m|>.<|m|")
add('Crowbar', 'http://crowbar.webcomic.ws/', u'A curious boy befriends a robot inside an alien pyramid on a distant planet! Together they must solve a puzzling mystery before dark forces overwhelm them.')
add('Crowbars', 'http://Crowbars.webcomic.ws/', u'T-Shirts and other pointless merchandise also available on website.')
add('Cubecows', 'http://cubecows.webcomic.ws/', u'Cube Cows for everyone! Merely shout something out and I, your ever faithful servant, shall warp and twist it into a cube cow. Be it a character, idea, game, object, or even yourself, once put into the cube-cowifier, it shall be done! All suggestions are put on a list, and then selected randomly off of that list. If you or one of your characters are used, you have equal rights, and may use the drawing for personal purposes (eg. Avatar, displaying in webcomic...)')
add('Cupcakegraffiti', 'http://cupcakegraffiti.webcomic.ws/', u'The many adventures of Mr. Cupcake. Shop for Cupcake Graffiti on ETSY!! http://www.etsy.com/shop/sodapopcomics')
add('Curvyboneyosis', 'http://curvyboneyosis.webcomic.ws/', u'"This comic is TERRIBLE, its not even a real comic, its just shit this Robin thing drew while it was drunk, and it laughs at it till it cries!" Quote from one of Robin Jevics basement prisoners.')
#add('DEMENTED', 'http://DEMENTED.webcomic.ws/', u"\u2606 [b]Updates[/b] - Every Saturday Karma is a bitch. We're all going to Hell eventually. But what happens if you've taken a visit to it and a certain little someone followed you back on Earth..? CHAOS ensues. Take a ride with Slayne, a killer-for-hire where everyday is the worst day of his life~ Tags: LGBT, Incubus, Demons, Angels, Hell, Heaven, Cute, Chibi, Anime, Sci-Fi")
add('DRouggs', 'http://dRouggs.webcomic.ws/', u'Dark and wierd comic, but sometimes quite funny. [No storyline]')
add('Dailydoodle', 'http://dailydoodle.webcomic.ws/', u'A collection of doodles and drawings')
add('Damnhipsters', 'http://damnhipsters.webcomic.ws/', u"There's some in every generation... those that are so obsessed with being cool they'll do anything to keep ahead of the mainstream no matter how stupid it makes them look. These are their stories.")
add('Dandk', 'http://d-and-k.webcomic.ws/', u'The adventures of a group of friends as they try to live the sex, drugs and rock and roll lifestyle. Nobody said it was going to be easy. Updates every Monday and Wednesday')
add('Darksisters', 'http://darksisters.webcomic.ws/', u'Follow the adventures of the witches of the Dark Sisters Coven as they use their wits, magic, and mostly their sexual charms against the demonic and mortal forces that oppose them.')
#add('Dasien', 'http://dasien.webcomic.ws/', u'Publishing the entire run of Dasien daily! Superhero girly goodness!')
add('Datachasers', 'http://Datachasers.webcomic.ws/', u'Data Chasers is set in the distant future, in a world still recovering from an apocalypse. In it, humans and androids live side-by-side and face the hazards of their dangerous environment. Though set far into our future, it reflects our past and our present, dealing with the politics and cultures of different people, along with touching on the very fundamentals of humanity. ( Updates Monday though Friday ) ( Description by Ranger_Brian_New! )')
add('Davidandtherobot', 'http://davidandtherobot.webcomic.ws/', u'A sarcastic group of four ban together to stop the mysterious Resternic Science and find out the truth of the New Future Project.')
add('Ddsr', 'http://ddsr.webcomic.ws/', u'A sprite comic that has no Sonic sprites! Seriously, all custom done. Join two friends and there crazy adventures involving demons, robots, explosions and shiny things.')
add('Dead', 'http://dead.webcomic.ws/', u'"Today a young man on acid realized that all matter is merely energy condensed to a slow vibration, that we are all one consciousness experiencing itself subjectively, there is no such thing as death, life is only a dream, and we are the imagination of ourselves... Here\'s Tom with the Weather!"')
add('DeadFingers', 'http://DeadFingers.webcomic.ws/', u"Deadfingers is a story about an indigenous girl and her tribe, struggling to salvage its independence from the imperialistic mainland. Features magic, knife fights, guns, robots and everything else you'll find in the alternate universe. To read the entire comic (over 200 pages long and counting) Please visit http://www.drunkduck.com/DeadFingers/. DeadFingers updates with new pages every M T W TH F and S.")
add('Deadducks', 'http://deadducks.webcomic.ws/', u'Danny duck and his two brothers just moved in with their uncle in a small town full of ghost monsters and serial killers')
add('Definehero', 'http://definehero.webcomic.ws/', u"Part fairy tale parody, part comedy, part adventure...all chaos A pair of roaming thieves accidentally awaken the mightiest hero of all time...too bad he has no idea what's going on. Mistaking the two bandits as his fated guides, he follows them oblivious to the fact that he's being molded into their perfect weapon. Though the thieves' brilliant plan seems flawless, the hero's instinct to do good deeds gets in the way and leads the trio into a series of epic...and often hilarious adventures Set in a world crafted by a dragon's hand, the trio encounter magic beings, terrifying shape-shifting monsters and bizarre spirits and gods. Violence/gore and strong language-(PG-13) Updates once or twice a week! Illustrated by me Written by a group of not-so sane people including your's truly")
#add('Demoneater', 'http://Demoneater.webcomic.ws/', u'The grotesque life story of Saturno, a demon that eats other demons to get stronger.')
add('Demonwings', 'http://demonwings.webcomic.ws/', u'')
add('DenizensAttentionComic', 'http://DenizensAttentionComic.webcomic.ws/', u'Alicka and her little brother Winston are sent to Winterkill Boarding School. The number one dumping ground of unwanted troubled teens. A miniature Gormenghast filled with bad seeds and black sheep.')
add('Dictatorship', 'http://dictatorship.webcomic.ws/', u'Meet mr. President and his wacky lackeys who rule the Republic of Syrania with an iron fist.')
add('Dierabbitdie', 'http://dierabbitdie.webcomic.ws/', u'Born in the backwoods of Oklahoma, Daisy Dew Mummolo lived a life of mystery her first few years. She was found in an abandoned house and spent some time at a rescue before Burt responded to her get-rich-quick scheme on Craigslist. She felt pity for him after cleaning out his bank account and decided to move in with him to console his constant spats of crying. Soon, they became friends, and Daisy allowed Burt to chronicle her daily life in exchange for baked chicken dinners, trips to the dog park, and custom made collars. Daisy loves children, tolerates adults, and absolutely hates rabbits. It\'s in her blood. Since the 1500\'s her breed has been raised to find rabbits. Unfortunately, Daisy has somehow twisted this tracking talent into a personal vendetta. She earnestly feels that rabbits are evil and must be hunted down and destroyed. As such, many in the rabbit community have taken exception to this attitude. Several restraining orders have been taken out against Daisy, but she simply chews them up the moment they\'re served. Each morning, she awakes with a smile on her face, a spring in her step, and a singular phrase in her mind, "Die Rabbit, Die!"')
#add('Diexemor', 'http://diexemor.webcomic.ws/', u"diexemor is the about a gambler named mephena trying to deliver her special friend from prison, veremor. this story has lesbians...so don't read if you hate them. It will be updated every week.")
add('Disturbingcomics', 'http://Disturbingcomics.webcomic.ws/', u'Dark dumb luck hero finds super female.')
add('Docapoc', 'http://docapoc.webcomic.ws/', u'A useful* resource for surviving** and thriving during*** the end of life as we know it at the "hands"**** of zombies, aliens, robots, boredom, plague, asteroids, the weather, ninjas, clowns, [redacted by National Security], war, global warming, giant creatures from the deep or vampire enslavement. *No "actual" usefulness, either real or implied, is guaranteed. **No "actual" survival, either real or implied, is guaranteed. ***No "actual" thriving, either real or implied, is guaranteed. ****Many forms of apocalyptic doom do not have hands.')
add('Doffeellende', 'http://doffeellende.webcomic.ws/', u'')
add('Domain', 'http://Domain.webcomic.ws/', u'Emily Quarters returns to her hometown Gateway to see her mother however things go south when she gets teleported to a strange and weird world that is Domain... once she finds herself in this weird fantasy-based world she gets attacked by a Dark elf and gets transformed into a naga... now she must find a way to return to normal and return home and learning everything about this strange world!')
add('DotX', 'http://DotX.webcomic.ws/', u"Dot X is a comic based off characters that my friends and I created in elementary school. They were originally Sonic fan-characters, but that has been entirely eliminated from their world, with the exception of their appearance! This is not intended to be a furry comic. More info on me and the things I make, click my 'about' page from the comic!")
add('Doublejump', 'http://doublejump.webcomic.ws/', u'Every day, I have a free half hour, and what better way to spend it than to sketch up some Videogame Comics super-quick for you guys?')
add('Draginbeard', 'http://draginbeard.webcomic.ws/', u'The world has grown dark and dangerous. A dwarf named Jolly Draginbeard has spent 10 years trying to get home only to find everything has changed. Dragons roam the skies, and shadowy creatures stalk the land. Is there no safe place left? Can one wise-cracking dwarf make a difference in a world full of monsters? Updates every Monday.')
add('Dragoncity', 'http://dragoncity.webcomic.ws/', u'Millions of years ago, a comet wiped out the dinosaurs, but the dragons who were living along side them went underground and stayed there. And now we see the civilization that has come about from those refuges in a current day story.')
#add('Dragonet', 'http://dragonet.webcomic.ws/', u'A wizard tries to raise an orphaned dragon in an age of war, evil, and magic. He soon finds out a dragon does whatever it wants...and he may make all the difference.')
add('Drettaville', 'http://drettaville.webcomic.ws/', u"Rook's life is thrown into chaos when he's suddenly put in charge of raising a seven-year-old daughter he never knew he had. A daily family-friendly comic strip!")
add('Drifting', 'http://Drifting.webcomic.ws/', u'A story of a Young "Drifter" named Venture and the mysteries of Auncen and Novossa.')
add('Dueeast', 'http://dueeast.webcomic.ws/', u"A multiracial family tries to come back together after a painful divorce and six years of separation. This is a Christian webcomic that doesn't beat you over the head with its message.")
add('DuelingHeroes', 'http://DuelingHeroes.webcomic.ws/', u'Cetacion City is in dire straits- the darkness surrounding it going beyond the natural pale. Something is wrong with the city- but two heroes have risen to fight back the darkness- if they can get past each other.')
#add('Dungeonhordes', 'http://dungeonhordes.webcomic.ws/', u'In 1986 Dungeon Hordes was released on the Playtendo and moved 1 million units world wide which is way more successful than its previous release on the Batari 2200 in 1979. Now in 2011 Dungeon Hordes has returned bigger and better than ever with mind numbing graphics and all new enemies to fight. So how do the characters in game feel about this? Only time will tell. Enter the lives of Tiggz and Tomes, two level 5 bosses tired of being easily killed by player 1 and wanting the glory of finally becoming more than just petty bandits. Will they survive the new creatures that the mighty programmers have added to the game? Will they ever kill player 1 and move up the mob boss ladder? Will they ever get a raise from their uptight dungeon boss Kalakis and finally pay off their ale tabs at the Stinky Dragon Inn? Stay tuned and find out..... Will be updated Every Day!')
add('EMT', 'http://eMT.webcomic.ws/', u"an experiment in Mental Theatre, externalized in comic form. Currently Featuring: MAD SCIENCE! with Dr. Nick - steampunk fantasy adventure into the strange! Now updating 3 times weekly, every M-W-F. [i]It doesn't serve the 3 fetish as well as every 3rd day on dates divisible by 3 did, but you get more story for your money - with 3 more strips every month![/i]")
add('Eclipselegend', 'http://eclipselegend.webcomic.ws/', u"In 1948 the course of history was changed when the war with the Celerans began. In order to survive mankind had to evolve and adapt. This quantum leap in human potential takes the form of artificially-created superhumans known as \u201calpha-humans.\u201d Created by EON Industries, the Alpha-human Project holds the keys to once again, change mankind's fate.")
add('Educomix', 'http://educomix.webcomic.ws/', u'A parody educational comic about a young man called Dave and his crazy adventures. "Good. I\'ll make toast."')
add('Elektroanthology', 'http://elektroanthology.webcomic.ws/', u'These are various unrelated comics I have worked on. Everything\'s tagged just in case. They\'re mostly short stories I\'ve done for different anthologies (Copyright also for "Various" because some of these I worked on with someone else as well). Updates whenever.')
add('Elementsofeve', 'http://elementsofeve.webcomic.ws/', u"Being fifteen years old brings up many issues in the life of Eve Thomas: a new home, new school, new emotions, and a multiple personality disorder she thought she had under control. And when each of her personalities is empowered with a different elemental force, you can be sure her life won't be getting easier any time soon. Updates Mondays and Thursdays")
add('Elfcomic', 'http://elf-comic.webcomic.ws/', u'Elf is a humorous fantasy comic. I will post new content every Thursday. Feel free to post comments. Welcome!')
add('Elsewhere', 'http://elsewhere.webcomic.ws/', u'Elsewhere is A Slice of Life with Sci-Fi Pie for Dessert! Butch, a small black dog, is way out of this depth. Walter, a burly walrus, is his roommate. It deals with humorous typical and wild adventures they have with their freinds. Somedays it can be as mundane as dealing with laundry and classes other weeks they could be trying to stop an alien invasion and a time space continuum loop. Give this long running, award winning comic a try.')
#add('Equsopia', 'http://equsopia.webcomic.ws/', u'Because of black magic, a king and his loyal knight were sent to another world. Now they must find their way home.')
add('EternityC', 'http://EternityC.webcomic.ws/', u'When a compulsion is so strong that it runs your life, you have a complex. When that complex centers around Eternity, you have an adventure. Join Fae as she searches for Eternity and all that it might bring her.')
add('Everydayabnormal', 'http://everydayabnormal.webcomic.ws/', u"When supernatural, technological, or mythic threats endanger human lives, only the Agency of the Unnatural can rise up to stop them -- but it's the ordinary people who are caught in the crossfire. Jon Grasseschi's ongoing saga explores how people react, live, and just survive when the unexplainable, the impossible, and the just plain weird intrude on their lives.")
add('Fairydust', 'http://fairydust.webcomic.ws/', u"A world where fantasy creatures are real ought to feel a little complicated. Should you want to visit it, start with the cities, they're full of humans and modern comfort, if you don't mind having a leprechaun for neighbour or a troll driver. But you're not a racist, right?")
add('Fathead', 'http://fathead.webcomic.ws/', u'A comic about wacky adventures, talking fruit and pointless conversations!')
add('Fexpression', 'http://fexpression.webcomic.ws/', u'This comic updates every Saturday and every Sunday. Sometimes the art changes to very pixely, but hopefully it is just generally improving anyway.')
add('Fiendishfellowship', 'http://fiendishfellowship.webcomic.ws/', u"Follow Shai'tan's forces as they attempt to conquer the myriad universes. This is for the crossover project Crossover Melee.")
add('FingerPuppetShow', 'http://FingerPuppetShow.webcomic.ws/', u'A webcomic for all ages following the adventures of Colin the Cow, Girlock Holmes, Gary and Paul, Gabby and Buster and many more... Updates: Wednesday and Friday (All finger puppets featured in these strips were created by Fiesta Crafts and can be bought here: http://www.fiestacrafts.co.uk/)')
add('FireBorn2', 'http://FireBorn2.webcomic.ws/', u'The King of the Dead, The Lord of the Shadows, and the Devourer of Souls are amassing their armies to take revenge against the world and the gods that have shunned them. Men and women from different walks of life will join forces to fight them.')
add('Flickwit', 'http://flickwit.webcomic.ws/', u"What's to know? A ragtag bunch of adventurers are embroiled in an Illithid's nefarious plot, and have to fight their way through hordes of monsters, escape the dungeon and save the local peasantry before the lot of them get vaporised in a dimensional cataclysm. You know-- the usual fare. Thrills, spills and fun for the whole family! Warning: Art quality varies wildly.")
add('Foxtales', 'http://Foxtales.webcomic.ws/', u'A manga based on faerie folklore. After encountering a man who can change into a fox, a girl finds herself mixed up in a world of faeries and mythical creatures.')
add('Fpk', 'http://fpk.webcomic.ws/', u'Formerly Frighteningly Pretentious Komix! FPK! is a bunch of funny stories with strange characters. Or strange stories with funny characters. One of those.')
add('Fracturedtea', 'http://fracturedtea.webcomic.ws/', u"This is the story of one woman's quest for balance as she learns about love, loss, and friendship. It is also the story of the people who who help and hinder her along the way. If you like tea shops, cellos, art criticism, and queer romance, this is the tale for you. Updates Monday, Tuesday, Wednesday, and Thursday at some point before 11 am EST. As my art and writing skills have improved drastically over the 200+ strips, I encourage new readers to have a look at the most recent strip first, to see the eventual reward of slogging through my old art. ^^")
add('Fraternit', 'http://fraterni-t.webcomic.ws/', u"A comic strip about life, love, long-lost brothers, and everything else a high school girl has to deal with! THIS COMIC STRIP IS SEMI-AUTOBIOGRAPHICAL, WHICH MEANS MOST OF IT IS BASED ON THE IMAGINATION OF THE AUTHOR. ANY CHARACTERS THAT MAY BE BASED ON REAL PEOPLE HAVE HAD THEIR NAMES CHANGED. Special thanks to Jimmy Gownley, author of Amelia Rules! and cofounder of Kids Love Comics. Also, thanks to Bill Wahl, Nikki, my parents and friends. I couldn't have done it without you!")
add('Friendshipisdragons', 'http://friendshipisdragons.webcomic.ws/', u"A screencap comic of My Little Pony: Friendship is Magic. Equestria is a custom campaign setting for Dungeons and Dragons, and the mane six are Player Characters. How will a party of six roleplayers fare in a world where the usual hack-'n'-slash high fantasy has been replaced by pastel-colored ponies?")
add('Frontier2170', 'http://frontier2170.webcomic.ws/', u"Life as an independent spaceship crew isn't easy. In addition to the astronomical cost of fuel, supplies and repairs, it seems like the big corporate outfits get all the well-paying jobs, leaving the petty runs they don't want to people like you. Those jobs don't pay well enough to make ends meet, and there never seem to be enough of them, so sometimes you have to break the law to put fuel in the tanks and food on the table. If that wasn't bad enough, there's a war going on, and that means cargo inspections and surveillance...")
add('Fullmetalbrothers', 'http://fullmetalbrothers.webcomic.ws/', u'')
add('Fusion', 'http://fusion.webcomic.ws/', u"What's inside the pages of this little book isn't so much a comic as it is a viewport into another dimension where you can follow Savunn's hectic life as a Cambodian teen (and superhero fan-gal) as she tries her best to make her mark as her world's newest superhero, Fusion! As reader, you will serve as her confidant as you watch the reality show of her life unfold with each turn of the page.")
add('Fuzzballandscuzzball', 'http://fuzzballandscuzzball.webcomic.ws/', u'Fuzzball and Scuzzball are brothers who live in the gritty urban hell that is Happy City, New Jersey. In theory, they are private investigators. They have wacky misadventures.')
add('Galbertofbruges', 'http://galbertofbruges.webcomic.ws/', u'A comic based on the book "The Murder of Charles the Good, Count of Flanders"')
add('Ghostassassin', 'http://ghostassassin.webcomic.ws/', u'Daniel is a civil servant for the Department of Pediatric Spirituality. He hunts the ghosts that prey on children. But now things have changed...')
add('Gillimurphy', 'http://gillimurphy.webcomic.ws/', u"Gillimurphy Stories - A turn-of-the-century multi-storied apartment building, nestled in the city of Lockdale. Revel in its charm, discover its secrets, and meet its unwittingly affable occupants. (If you're enjoying this strip, take a gander at the original GS series which predates the current edition, found here: http://gillimurphy-orig.thecomicseries.com/)")
add('Glomshire', 'http://Glomshire.webcomic.ws/', u"The misadventures of the inhabitants of Glomshire, a medieval(ish)land of undetermined origin. LEGO\xae is a trademark of the LEGO Group, which does not sponsor, authorize or endorse this comic (and we don't blame them!)")
add('Glorianna', 'http://glorianna.webcomic.ws/', u'After the collapse of civilization, humanity is thrown back to a medieval state. Into this fragmented world comes Glorianna, a sword-for-hire seeking her fortune. She travels the world, finding danger, intrigue, and romance.')
add('Godgames', 'http://Godgames.webcomic.ws/', u'Story about an ex Olympian with an ambition of taking vengeance on the other gods')
add('Godhatesdads', 'http://godhatesdads.webcomic.ws/', u'my journal comic or something. showing the good times and the bad times of being a weirdo in my mid 20s.')
add('Goldrushdynllewcomics', 'http://goldrush-dynllewcomics.webcomic.ws/', u"Short weekly strips about the adventures of Alistair and Sam as they try to get rich quick from War-time relics buried around the Forest of Dean. There's gunna be blood, sweat and a bit of sex. Just for the mature factor! Requests on story will now be accepted! Written and artwork by Alex 'Dyn Llew' Thomas.")
add('Grandfatherstale', 'http://grandfatherstale.webcomic.ws/', u"Marcel of Flamond is an ordinary soldier in the King's service when all the forces of evil descend on the Kingdom and he finds himself one of the few heroes left.")
add('Grandify', 'http://grandify.webcomic.ws/', u"Your name is Arran. You want some lunch money from your mom, but she tells you to get a job. So you do. And in the process become the hero that the world of Unnamed needs. Along with shenanigans that nobody really wants to talk about. But let's start at the beginning; the beginning of a story, and continual art shifts.")
add('Grandline3point5', 'http://grandline3point5.webcomic.ws/', u"So... yeah. Some time ago, I went on an archive binge on Darths & Droids. If you know what I'm talkin about, then you probably know what's coming up. I decided to give it a shot and here's what I came up with: One Piece if it were a roleplaying campaign. :p")
add('GreenEyes', 'http://GreenEyes.webcomic.ws/', u'One page comics on the simple things in life.')
add('GreenerGrass', 'http://GreenerGrass.webcomic.ws/', u'This is the story of three strangers (and their pets), who for unknown reasons get dragged into a different dimension, named by them as the Grass-Green-Land. Whatever will await them there? Warning: This comic involves a lot of swearing. Updates whenever I have the time for it.')
add('GrippsBrain', 'http://GrippsBrain.webcomic.ws/', u'These are People and Critters I have butted heads with, and are mostly single pages. (HOW do some toonists do all that Drawing and Writing? With you know Conversations and PLOTS?) PS: Please also look at the archives, moving earlier stuff over there.')
add('HIRI', 'http://HIRI.webcomic.ws/', u"Autobiographical comic that's at least 80% true")
add('Halloween2012', 'http://halloween2012.webcomic.ws/', u'This is the Webcomic Hub for the multi-webcomic event known as The Halloween Cameo Caper 2012. The strips will be posted here as they appear on the main sites by the various authors participating in the event, however, here a sense of continuity will hopefully appear as the strips are being rearranged along the way.')
add('Halloween2013', 'http://halloween2013.webcomic.ws/', u'This is the Webcomic Hub for the multi-webcomic event known as The Halloween Cameo Caper 2013. The strips will be posted here as they appear on the main sites by the various authors participating in the event, however, here a sense of continuity will hopefully appear as the strips are being rearranged along the way.')
add('Hazardswake', 'http://hazardswake.webcomic.ws/', u"A fantasy webcomic in an J-RPG-like world. The fates of many characters intertwine as their quests converge in a setting that's inspired by old console RPGs and is more than a little silly.")
add('HeadWound', 'http://HeadWound.webcomic.ws/', u'After a traumatic head injury, Young Chris finds himself in an insane world crafted by his own mind. As things start to crumble, can Chris find the will to save this world and in turn, save himself?')
add('Heavylittlepeople', 'http://heavylittlepeople.webcomic.ws/', u'A (mostly) daily snapshot of the lives of these odd Heavy Little People')
add('Hellowanderingstar', 'http://hello-wandering-star.webcomic.ws/', u'Muse is a superhero in a world without superheroes. Things ensue!')
add('HitmanPiranha', 'http://HitmanPiranha.webcomic.ws/', u'')
add('Hitmen', 'http://hitmen.webcomic.ws/', u'A fantasy action drama comedy. Contains a magic sword, lots of monsters, lots of guns and weird evolution. 586 pages. Completed.')
add('Hodgemosh', 'http://hodgemosh.webcomic.ws/', u"It's just kind of stuff. And then there's other stuff, and that's pretty much how it goes.")
add('Holon', 'http://holon.webcomic.ws/', u'In 3013, mankind has been driven to the edge of extinction in an intergalactic war. The lifeline of their endangered civilization are HOLONs, space stations established to harvest omnipotent and extremely destructive particles...')
add('Holybibble', 'http://holy-bibble.webcomic.ws/', u'From out of the ashes.')
add('Honeyvenom', 'http://honeyvenom.webcomic.ws/', u'Honey Venom, the sweetest poison, the daughter of darkness. Honey is an adventurer with an obscure past. She is an assassin and a witch. This comic is about her adventures in mysterious lands, about her loves and her fights against revenants, vampires, evil priests, corrupted zealots, depraved ogres and other revolting villains. Feel you free to contact me at my email address: I like to talk about my comics and to make friends with those who read my works, as well with other comic makers.')
add('Housepets1x', 'http://housepets1x.webcomic.ws/', u'A new weird family approach! Primo is a talented actor, Spike is an avenger. Together they form the most caotic and crazy squad ever! Updates on Monday, Wednesday and Friday')
add('HumanCookies', 'http://HumanCookies.webcomic.ws/', u"My toys get bored when I leave the room, so they come to life and make these comics. Sometimes they do things that cause worldwide issues, sometimes they burn the toast, it's all just a roll of the dice with them! Watch this cast of now just over a 1000 characters do their stuff!")
add('Idget', 'http://idget.webcomic.ws/', u'No description necessary! Usually.')
add('Ignitionzero', 'http://ignitionzero.webcomic.ws/', u"Four years ago, Robbie Finch met his best friend on the Internet. Now he's off to college in that very friend's home town--well, city. Big city. Orson and his friends are exactly the kind of people Robbie wants to meet: punks, hipsters, queers, and artists like himself. It's their exploits that push him headfirst into a new kind of reality, one where the Fair Folk and humanity meet. The city of Glory is full of well-kept secrets, but they might just unravel them all.")
add('Immigrant', 'http://immigrant.webcomic.ws/', u'A grizzled nomad hunts down his past mistakes, one at a time.')
add('Insanitycorp', 'http://insanitycorp.webcomic.ws/', u'[[ ENDED ]] The new and improved--yet still not corporate--Insanity Corp is back with more panels and fewer sticks! :D [Reality not included, offer not available in the Neptunian quadrant, see inside for details.]')
add('Inviziblecomixgroup', 'http://inviziblecomixgroup.webcomic.ws/', u'Invizible Comix Groups omnibus of online comix. A wide range of stories done over the years, from noir and sci-fi to pro wrestling and superheroes, and many other strange things inbetween. These comix are for mature readers because they have occasionally explicit language, a wee bit of nudity, and a fair amount of graphic violence. Updates are every single day.')
add('Isaacandfriends', 'http://Isaacandfriends.webcomic.ws/', u'Isaac and his friends Gerald, the headless chicken and corspeboy are here to make you laugh. and do extraordinary feats in on ordinary world! enjoy!')
add('Isb', 'http://isb.webcomic.ws/', u"Internet Superbuddies is an experiment in chaos theory, pixels, and utter fucking boredom. It features five protagonists who basically swear and hate each other and are in some kind of bizarre and unclear living situation, to where they also break the fourth wall and realize they're part of a grander machination of being in an experiment in chaos theory, pixels, and utter fucking boredom. It used to be based on real life. Then people started getting killed and orcs with intent to rape started showing up. Then things got wacky.")
add('Isonacia', 'http://Isonacia.webcomic.ws/', u'On a series of hidden islands in the pacific, science has evolved well beyond the modern world. Now a select few are being introduced to the strange land of Isonacia')
add('Its', 'http://its.webcomic.ws/', u'The year is 2180. Immortality is now a commonly-available genetic modification, but complete unkillability has yet to be achieved... Or so the universe thinks. A single batch of military-grade prototype GELFs (Genetically Engineered Life Forms) has exhibited this ability, but at the cost of being rendered mentally unfit for military life. Cooped up for a year, the GELFs manage to escape from the facility that made them. Being a terrible pilot, one GELF, codenamed "Yellow", crash-lands its escape craft on the swamp planet of Bloogis V. After getting stuck in the swamp, Yellow is rescued by two employees from a refueling station orbiting Bloogis. With no ship, no money, and nowhere to turn, Yellow makes up a new name and a gender for itself, re-dyes its fur, and asks for a job on board the station. A couple weeks later, and Yellow, now known as Chaz, is already getting the hang of his job, mixing drinks, talking with customers, the works. What kinds of weird and wonderful customers will he meet while working at the Intergalactic Truckstop? (The comic doesn\'t have a lot of mature language, but there\'s a swear here and there so I figured I\'d play it safe!)')
add('Itscomplicated', 'http://itscomplicated.webcomic.ws/', u'The exploits of a city girl as she gets through her late teenage years')
add('Jakebone', 'http://jakebone.webcomic.ws/', u"Agent Jake Bone, Whatever-oh Zeta, of Her Majesty's Foreign UK Intelligence secret service. Drunk on vodka and his own self-worth, utterly convinced of a conservative British male's uncontested superiority over all others. Racist, narcissistic, sexist, and just generally rude, Jake Bone is a true hero for our times. Yes, this is yet another James Bond parody in a world over-crowded with the things. The difference: thoroughness! As much as feasible, this is an UNABRIDGED parody, doing EVERY official film in-depth and unexpurgated. All done Airplane!-style. Enjoy.")
add('Jamiejupiter', 'http://jamiejupiter.webcomic.ws/', u'Jamie Jupiter is a member of the Galactic Squadron-a team of intergalactic "space cops" who help protect the galaxy. After tracking a villain to Earth, she saves the lives of two teenagers and shares her secret with them. She now vows to use her cosmic superpowers to protect her new friends and her new home, while learning what planet Earth is all about. Monsters of all shapes and sizes threaten our way of life, but with a brave and determined alien; a deadpan snarker photographer, and her comic book-loving geeky boyfriend, no task is simple, and every day is an adventure.')
add('JaysInternetFightClub', 'http://JaysInternetFightClub.webcomic.ws/', u"A Bus Driver starts a female fight club in his basement, with his wife, and his wife's girl pals. They broadcast the fights over the internet, and sell the dvds of the matches.The cast goes through adventures outside of the club as well.")
add('Jenfferscartoonphotomanipulaion', 'http://jenfferscartoonphotomanipulaion.webcomic.ws/', u"where old , unanted lost photos gets a new life as a cartoon pin up for the cast of jenffer's show")
add('Jenffersshow', 'http://jenffersshow.webcomic.ws/', u'Welcome to New Wolf Creek in Yukon Canada. The new home of "Miss J and the AM." This strip is about Miss J and her rock band called "Miss J and the AM" and their life in New Wolf Creek. See, Miss J is a lesbian and just married Jenffer Jay, her friend . And that\'s only the start. Please note: There is some frontal nudity now')
add('Jericho', 'http://Jericho.webcomic.ws/', u"Jerry, a young women with depression and self esteem issues has had a rough time growing up, and all seems to be going well while she is at Bournemouth University studying Medical Science. However, after putting her fellow students health at risk while testing her new ultra sound glove in an attempt to find an alternative treatment for cancer patients, she is threatened with expulsion. Her tutor, Doctor Foster is soon to be threatened with similar actions after he is accused of having an intimate relation with one of his students. But Jerry's world is pushed to it's limits when her best friend Carl is diagnosed with an inoperable and very aggressive brain tumour. On top of all this, the media is constantly running a story about a serial killer who targets terminally ill patients. The odds are against Jerry, and she has to make a choice. Does she become the bad guy in order to save her friends life? Will she be able to help him before the killer strikes? And what has Doctor Foster done with her invention? 'Jericho' is due for release as a published/printed comic later this year, and this is your chance to read it first! Rather than going out and finding a test audience, we decided that the best test audience is the readers of Comicfury.com! Please rate and comment so that you can help us make a better comic reading experience for you! Thank you! Jericho is registered with the UK Copyright service. Registration No. 324507")
#add('JillpokeBohemia', 'http://JillpokeBohemia.webcomic.ws/', u"Jillpoke Bohemia is a meta-comic about Darby and Kieran, a country-punk musical duo (and on-again, off-again lovers) based in Portland, Maine. In the tradition of the Hernandez brothers' Love and Rockets and other indie comics, Jillpoke is an edgy feature that does not shy from sexual situations or topical/political issues.")
add('Jix', 'http://Jix.webcomic.ws/', u'An alien sent to survey Earth for conquering crash lands on Earth and an alternate personality takes over and moves in with a 20-something year old woman. These are their stories. BOM BOM!')
add('Joysworldcomic', 'http://joysworldcomic.webcomic.ws/', u'Meet Joy Fulbright, an 11 year old tomboy. Joy for the most part, is smarter than the world around her. Shes an angry only child who lives with her divorced mother and is does video blogs, films, and other mischievous activities. Joy ends up living in her own little world with her friends Kimmy and Neil, her schoolyard antagonists Gary and Joanna, and her arch-nemesis...boredom. Updates Sunday and Thursday weekly! http://www.joyslittleworld.com/')
add('Judgedred', 'http://judgedred.webcomic.ws/', u"A Modern Day Re-imaging of a Syndicated Comic Strip You've Likely Never Heard of. All Original Artwork by Alex Graham/Michael Martin.")
add('Jump2', 'http://Jump2.webcomic.ws/', u'A demon possessed killer gets a glimpse of what life could be like free from his Master...but freedom, like all things in life, is difficult to attain and even more difficult to maintain. (This is the remake of the original.)')
add('JustPeachy', 'http://JustPeachy.webcomic.ws/', u'"Just Peachy" is a cheeky serial comic strip featuring a small college town\'s generation of college alums who aren\'t giving up and growing old without a fight. Kids: don\'t let your parents fool you, this is exactly how they behave when they think you\'re not looking. Parents: don\'t try to act all dignified and deny it. Liar, liar, pants on fire. In fact, you\'re probably worse than this.')
add('Kachingcomic', 'http://kachingcomic.webcomic.ws/', u"An ongoing tale of magic, monsters, and morons, Ka-Ching follows greedy escaped prisoners Mort and Tab, who stumble into the last remnants of a magical war and get dragged kicking and screaming into adventure. Here we'll post each 14-page issue as we finish it. If you want to follow us update-by-update, check out our full site at www.kachingcomic.com! There, you'll also be able to check out the mini-comics we release in between each issue, as well as our concept art, character dossier, and tons of other fun stuff!")
add('Karensedge', 'http://karensedge.webcomic.ws/', u'Karen Banks must rescue her friends when they are swept into a portal that connects this world to other, more violent and crazy alternate earths. To make matters worse, she comes into possession of a powerful weapon that curses its carrier.')
add('Kayandp', 'http://kayandp.webcomic.ws/', u"Kay is a college student who's passions are music and the arts, which probably makes her wacky enough... but also there is her best friend - a skeleton no one else can see, named P.")
add('Kazaandgwenna', 'http://Kaza-and-gwenna.webcomic.ws/', u'Gwendolyn Davis, once a bored socialite from the big city, found her life changed forever after meeting Kaza The Jungle Lord. Leaving behind trappings of civilization, she\'s found a life of adventure in the wild natural beauty of the wilderness as Kaza\'s Mate Gwenna. "Best comicfury comic EVER!" -The5thFromElbow2Wrist')
add('Keepingthepeace', 'http://keepingthepeace.webcomic.ws/', u"Four universes are combined into one. Three exist as a fictional franchise in another universe far away. Mortals from there are hired to reincarnate into the four worlds to use their knowledge, acquired power, and training undergone to keep the peace between these three worlds they knew of in their first life. Now a new recruit has been hired to manage all three of them and she's not sure if she can handle it. And what about that fourth world?")
add('Kevinzombie', 'http://kevinzombie.webcomic.ws/', u'')
add('KiasComic', 'http://KiasComic.webcomic.ws/', u'')
add('Kindergardencrisis', 'http://kindergardencrisis.webcomic.ws/', u'Rejecting adulthood never felt so good.')
add('Kirahitogame', 'http://kirahitogame.webcomic.ws/', u"A simple game that started with Kira and mine OC's. Every even page is mine, and every odd is hers.")
add('Knavesend', 'http://knavesend.webcomic.ws/', u"Knave's End is a port town in a fantasy world, peopled by humans, orcs, elves, dwarves, halflings, and some odd types of goblins. It's a center of political and criminal intrigue where the criminals are nasty and some of the guards are even worse.")
add('LORDDARKE', 'http://LORDDARKE.webcomic.ws/', u'The adventures of a middle aged black widow spider and her friends. Updates Every three days. NEW Q&A Updates three days after that.')
add('Laceyinvestigations', 'http://lacey-investigations.webcomic.ws/', u'Online Detective comic')
add('Ladyspectra', 'http://ladyspectra.webcomic.ws/', u'Schoolteacher Paula Carson and her daughter Jill lead a double life! When danger threatens Apollo City, they don the costumes of LADY SPECTRA & SPARKY! With brains, brawn, and laser bracelets, they battle the nefarious villains who threaten the innocent!')
add('Laserbrigade', 'http://laserbrigade.webcomic.ws/', u'An experimental comic about cyborgs, robots, and aliens. With lasers!')
add('Lastcallcomic', 'http://lastcallcomic.webcomic.ws/', u'Last Call, a Slice-of-life and Humor webcomic, focuses on a woman in her thirties, the antics of her husband and friends, and her conversations with her best friend at a local bar, who happens to be an alcoholic succubus.')
add('Lasttaxi', 'http://lasttaxi.webcomic.ws/', u"Charon has always ferried the souls of the departed to Hades. Now, he's using a taxi; It's easier on the arms. Updated every Monday.")
add('Latchkey', 'http://latchkey.webcomic.ws/', u"Latchkey is a daily comic strip, and takes its cue from strips such as The Perishers, Calvin and Hobbes, and Peanuts. It's about a group of eccentric and vaguely defective kids who spend most of their time together.")
add('Lauras24hourcomics', 'http://lauras24hourcomics.webcomic.ws/', u'Stuff that Laura\'s drawn for 24 Hour comic events. At such an event you usually try and draw 24 pages of comics in 24 hours. The two main events entered are "The Comikaze Challenge" in June of each year, and "24 Hour Comic Day" in October of each year. It changes, but recently I\'ve always drawn via the computer for the former, and by hand for the latter. This also includes comics drawn as a substitute for an entry (such as "Floods and Storms") and to complete the storyline of an unfinished entry (like "Part Three"). I usually try and draw one page a day for those.')
#add('Lavenderlegend', 'http://lavenderlegend.webcomic.ws/', u'Princess Lavender is banished from the sight of all men, but one of her servants has a dangerous secret. Well, more than one.')
add('Lazy', 'http://lazy.webcomic.ws/', u'')
add('LeahClearwaterFancomic', 'http://LeahClearwaterFancomic.webcomic.ws/', u"The continuing adventure of La Push's fastest and only female shape shifter, Leah Clearwater, as she battles vampires, idiot pack members and demi gods.")
add('Lena', 'http://lena.webcomic.ws/', u'The story of a girl and her interdimensional "friend".')
add('Lethargicmisanthropy', 'http://lethargicmisanthropy.webcomic.ws/', u'Please, do not get depressed after reading this comic. That is my job.')
add('Letitride', 'http://letitride.webcomic.ws/', u'An Iraq War veteran, a promiscuous journalism professor, and a delusional drifter commit felony vandalism at a variety of low-rent locales throughout the US. Featuring stolen cars, beautiful women, and bad pickup lines, LET IT RIDE is updated daily whether you like it or not.')
add('Lifeexplained', 'http://lifeexplained.webcomic.ws/', u'What started as a humorous attempt to participate in "Everyone Draw Mohammed" day resulted in a weekly comic in which things are observed.')
add('Lightbulbs', 'http://lightbulbs.webcomic.ws/', u"A wizard from the 10th century is summoned into the 22nd century to act as a teacher. Sadly the wizard can barely conjure magic thanks to a total global lack of other wizards. To restore magic to the world first the world must be restored it's self.")
add('Lilheroartists', 'http://lilheroartists.webcomic.ws/', u'')
add('Lint', 'http://lint.webcomic.ws/', u'')
add('LiquidLunch', 'http://LiquidLunch.webcomic.ws/', u'"Infected" by an organism, which saves him, then changes him...into a "symbiote" who feeds almost exclusively on liquids...particularly blood !')
add('Littleblackdress', 'http://little-black-dress.webcomic.ws/', u'They say a "little black dress" will get you anywhere. Dress it up\' dress it down. This one is very special. It will do a lot for you, even if it\'s not always exactly what you wanted.')
add('Littlejacquie', 'http://littlejacquie.webcomic.ws/', u'Life as seen through the eyes of Little Jacquie')
add('Littleredrobo', 'http://littleredrobo.webcomic.ws/', u'A little robot tries to make her way in the future.')
add('Lola2', 'http://Lola2.webcomic.ws/', u'Lola is the story of a sad, sad 13 (now 14) year old girl, who lives with her eccentric grandmother. After just entering junior high school, Lola begins to make new friends and go about life like every other normal kid...of course "normal" is relative.')
add('Longhike', 'http://Longhike.webcomic.ws/', u'Seven people, one dog, one long hike. By Isaac Glovinsky')
add('Lookstraightahead', 'http://lookstraightahead.webcomic.ws/', u"One teen boy's journey through depression and mental illness.")
add('Lp', 'http://lp.webcomic.ws/', u"It's a manga about a college student gets drafted into the Spiritual War for souls as a Prophetess of God. She battles demons, devils,and still manages to make it to class on time. Has action, adventure, and shoujo humor with a Christian theme.")
add('LucidsDream', 'http://LucidsDream.webcomic.ws/', u'Lucid, a new born kitten, is dragged into a dark world where felines called "Maus" are agents of ancient Egyptian Gods, assigned to hunt and eradicate demon spawns known as "Nightmares". Lucid quickly realizes that the world he was born in are filled with cats that have magical powers, rats can talk and where "Nightmares" are not the only thing that wants him dead.')
add('LunaStar', 'http://LunaStar.webcomic.ws/', u'Sister comic to Datachasers. covering events that occured in the past...Updates are "scheduled" for tues and thur... maybe the occasional bonus :D')
add('Lvl30psy', 'http://lvl30psy.webcomic.ws/', u'In a world where video game characters co-exist one Pokemon has to sort out all the problems. Join Dr. Gardevoir and the other staff of the MM Memorial hospital as they keep the heroes, villains and NPCs of the world in good health.')
add('Maddog', 'http://maddog.webcomic.ws/', u"Mad Dog and Spot are just a couple of cool cats, even though they're dogs. When ever they get together fate always serves them a side dish of adventure with a cup of heart and just a pinch of high fives! Follow along as they encounter mad scientists, alternate dimensions, evil sandwiches and who knows what else! Mad Dog! Every Saturday at 8 o'clock - 7 central! (Or whenever you feel like reading it)")
add('Madgirl', 'http://madgirl.webcomic.ws/', u"Who she is: Lee Steiner: sexy secret agent and habitual wearer of skintight flame-red zip-up leather catsuits with a white racing stripe down the side. Who she works for: The Organisation: fighting for what\u2019s right and proper, and battling anything that\u2019s jolly unsportsmanlike. They\u2019re the good guys with the biggest guns, the maddest, battiest cars and the best costumes. Headed by Grandfather, who smokes a pipe and generally knows what\u2019s best for the glorious British Empire. What\u2019s the strip about? Mad Girl is unashamedly and unapologetically 1960\u2032s in its outlook. Inspired by subjects as diverse as Wacky Races, Our Man Flint, Barbarella, Doctor Who, Danger Diabolik and any number of spoof sexy spy movies, the strip is intended to be funny, risqu\xe9, exciting and broadly smutty. It also features an almost entirely female cast, and our heroines will be doing all the fighting. Because of my own limits art-wise and the weekly nature of the strip, don\u2019t expect deep storylines \u2013 instead it\u2019s likely to be fast, ridiculous, slightly filthy and hopefully always funny. I usually post two pages a week, as close to a Thursday as I can manage. So sometimes it's Friday ;) You'll find the 'official' Mad girl blog right here: [url=http://madgirlcomic.wordpress.com]http://madgirlcomic.wordpress.com[/url] - with full-resolution artwork, extra pin-ups, news, ongoing projects and fan art - drop by and say hello! Feel free to add me on Facebook here: [url=https://www.facebook.com/roggibson]facebook.com/roggibson[/url] And on Twitter here: [url=https://www.twitter.com/roggibson]twitter.com/roggibson[/url]")
add('Magisa', 'http://mag-isa.webcomic.ws/', u'A comic about a loner, an angel, and a psycho cult that shoots up a school.')
add('Magnacomica', 'http://magnacomica.webcomic.ws/', u'A collection of short and somewhat longer stories that range from comedy, romance, adventure, and sci-fi. Not every story is graphic but when it gets graphic, it gets graphic.')
#add('Mascara', 'http://Mascara.webcomic.ws/', u"Addison Walker is a girl with natural style. She doesn't even wear makeup because she feels that brains are more important than looks. In fact, one of her closest friends is the smartest boy in school. But she has no clue that he has a strange alter ego\u2014as a makeup artist. When they meet, will it be a makeover disaster?")
#add('MayTheRainCome', 'http://MayTheRainCome.webcomic.ws/', u'William Weasel returns home after seven years of war only to find his hometown deep in a drought, and his life eerily empty and devoid of meaning. May the Rain Come is rated PG-13 (for depictions of PTSD and scary moments).')
add('Mayonakadensha', 'http://mayonakadensha.webcomic.ws/', u'Hatsune Rondo a Japanese-British teenager, living in Japan of 2010, disenchanted by her uneventful life and neglecting mother. But when Hatsune accidentally misses the last train home and boards a mysterious train that arrives on the dot of midnight she finds herself whisked back to London of 1888. Here she meets an orphan named Tom, who reveals to her that he is a member of the Baker Street Irregulars, a group of street urchins hired to assist Sherlock Holmes where needed in his investigations. Hatsune joins Tom and his friends in the Irregulars to tackle the many criminals that London houses. But one criminal in particular has Hatsune and the whole of London in a stranglehold of terror. Jack the Ripper. Contains some moderate gore and blood, a few uses of strong language, non-explicit nudity and some mild sexual scenes Updates a volume (70-90 pages) a month.')
add('Megamancomic', 'http://megamancomic.webcomic.ws/', u'A comic. About Megaman. What else?')
add('Melancholygoround', 'http://melancholygoround.webcomic.ws/', u'Welcome to the Academy! Enjoy life, study hard, avoid getting killed...')
add('Merelymortal', 'http://merelymortal.webcomic.ws/', u'A comic about life, death, and futility. Currently on indefinite hiatus. =(')
add('MichellesUniverseScrapbook', 'http://MichellesUniverseScrapbook.webcomic.ws/', u'Before the Michelle LaFemme in "Pop Culture\'s Kids", the character starred in a few other stories that were condensed and expanded upon in a (currently unpublished) graphic novel called "Michelle\'s Universe". This Michelle was born in 1962, and the novel is her biography. This webcomic is made up of additional material to that story, told in the form of comic strips, comic book pages, editorial cartoons, illustrations, etc.')
add('Midnightpeanutbutter', 'http://midnightpeanutbutter.webcomic.ws/', u"Arthur, Johnny, Renee and Fiona met online and have stayed friends ever since, Arthur and Johnny especially after finding out they were put in the same class. Arthur likes Fiona, Fiona met someone else, Johnny's on the brink of failing, Renee's too manipulative for her own good and their whole friendship starts to come crashing down around them in a chain reaction of events, staring from one night when Johnny felt like a midnight snack.")
add('Mildlyamusing', 'http://mildlyamusing.webcomic.ws/', u'A comic about life, happiness, and flights of fantasy.')
add('Minarga', 'http://minarga.webcomic.ws/', u"My longer-than-ever-anticipated Mass Effect fancomic, originally posted on deviantART, also available here. At the present time, I'm still working on the script, and will be posting first drafts of every chapter as I sketch them out. Finished pages will come when I've written the entire script and have layouts/rough drafts of all the pages. Again, just to cover all my bases, I do not own the Mass Effect universe; it's the creation of Bioware, and they own all the rights. I don't own a damn thing. More of my art is viewable at http://amethystsadachbia.deviantart.com/")
add('Mirroredconversations', 'http://mirroredconversations.webcomic.ws/', u"There are things in life that often don't make sense. This comic highlights them.")
add('MissionMars', 'http://MissionMars.webcomic.ws/', u'Martians: mankind\'s term for the super humans living amongst them. Feared by humanity, their only choice is to hide or face exile to a mysterious place called "Hell." High School student Fukui Shun\'s secret has been discovered but rather than report him, the lovely Tengan Toki is determined to be his friend. Made with ComiPo. Updates on Monday, Wednesday, & Friday.')
add('MoizmadComix', 'http://MoizmadComix.webcomic.ws/', u"Crack detective Riddick Q. Loss' never-ending quest to catch the villainous Sir Dimswitch in 1950's Vancouver.")
add('Monstersoup', 'http://monstersoup.webcomic.ws/', u'A group of misfit monsters are sentenced to live under the same roof--a castle belonging to mad scientist, who is serving his own sentence for unethical experiments. The real question is, can a hodgepodge group of monsters live under the same roof? (Some comedy, horror, and a little bit of everything else.)')
#add('Moonvalley', 'http://moonvalley.webcomic.ws/', u'Her old school was a nightmare because of him, the school bully Demian... So Kaia is anything but happy to go back there in her last year. Besides she wants to learn virtual creating and there is no virtual net in that small town, where she grew up... Or at least that is what she thinks... For there is a new boy in her class and he is the reason why nothing is the same as before... A story about a beautiful virtual world, a sleeping queen, demons and first love.')
add('Morningsquirtz', 'http://Morningsquirtz.webcomic.ws/', u'A filthy Taffy swirl of gooey pun drenched fun.')
add('Moths', 'http://moths.webcomic.ws/', u'In an alternate American past, Aram and his family must cope with the tightening grip of cynical political forces, while trying to understand the threat of the mysterious giant moths.')
add('Mushroomgo', 'http://mushroomgo.webcomic.ws/', u'Go is a Toad that wakes up in a desert, and is picked up by sand pirates. Describing the rest of the plot would take too long. Basically, a drawn Super Mario comic with original characters, disconnected from any particular game.')
add('MyHorribleSite', 'http://MyHorribleSite.webcomic.ws/', u'In a time and place unknown to us, noble magicians known as Seekers use their talents and instincts to find and destroy The Darkest Objects. Coupled with the brave Warriors, born to protect them, twelve young heroes must look deep inside themselves for the strength they never knew they had. They become Heroes of Power, and train to one day defeat The Greatest Evil... Yeah, awesomeness ensues. *To Start the Adventure, Click the "Heroes Of Power" Button above! See it? Riiight there? Look, I\'m making arrows. ^^ By The Always Unbearable: AU')
add('Namcowars', 'http://namcowars.webcomic.ws/', u'A battle of non-epic proportions! Andore has assembled five classic Namco armies to fight in a competition to prove which is the most powerful! Updates Tuesdays.')
add('NatureDEEP', 'http://NatureDEEP.webcomic.ws/', u'Nature DEEP, is a comedy, porn spoof. It mocks a YouTube short video series hosted by the brainless Max Tugger who is trying to create a sexual documentary on how animals have sex.')
#add('Negligence', 'http://negligence.webcomic.ws/', u'Drannik and Lizzep are two kids who are not very well supervised. This leads them into some very crazy adventures. They and the people they meet also deal with their own personal demons along the way. Updated Mondays, Wednesdays, and Fridays (concluded)')
add('Neighborscomic', 'http://neighborscomic.webcomic.ws/', u'it revolves around three characters, each one representing the three great countries of north america. george (a bald eagle)represents the usa, paco(a golden eagle)represents mexico and nashie(a beaver)represents canada. together they will have many adventures.')
add('Newheimburg', 'http://newheimburg.webcomic.ws/', u'Newheimburg is the story of Jack, Mort, and Sarah; three young people from two separate families. They spend their days in the city of Newheimburg, trying to sort their lives out before what remains of their childhood comes to an end.')
add('NoSongs', 'http://NoSongs.webcomic.ws/', u'Neil Gaiman meets H.P. Lovecraft meets The Bold And The Beautiful! Join Hector, our undead hero, as he attempts to make some sense out his recent death and resurrection. Magic, mystery and mayhem! Updates Sat-Sun.')
add('Nojetpack', 'http://nojetpack.webcomic.ws/', u"My Life Without A Jetpack is a biographical webcomic about MaGnUs' life, written by him, with art by Taibox (and sometimes colored by Mindy Lopkin). Published weekly in English and Spanish.")
add('Nostalgiaofeden', 'http://nostalgiaofeden.webcomic.ws/', u'The future. A colonized planet, Neo-Earth, is our new home. But all would not be well. Our sins have manifested into a being of such pure avarice, pure evil, and of such great size. And it is now heading to the world where its many creators dwells, to consume all of the Universe... Humans have the capacity to fight back, however. To resist. Across the globe, select humans of extraordinary traits will rise and face this threat to our world. From the strangest to the strongest, from the silliest to the serious, everyone\'s struggles become One. The battle for the fate of Creation itself begins! "Sir, put down the microphone." (Occasional Updates)')
add('Notsinceyou', 'http://notsinceyou.webcomic.ws/', u"Your Mirror is an indie rock band in crisis. Zoe, the band leader, isn't sure about her year-old relationship with the band's guitarist, Jenny. Jenny isn't sure if she loves Zoe, but she knows she loves playing in the band. And then tensions rise when the band's tour lands in the backyard of Zoe's high school boyfriend, Rex. Will the band survive one more concert, let alone the rest of the tour? NOT SINCE YOU is a photo webcomic written by Daniel Barlow and Keith Moriarty and starring Vermont's most exciting cartoonists. About the authors: - Daniel Barlow is the co-founder (with Colin Tedford) of the Trees & Hills comic group, a social cartooning organization in New England. With Trees & Hills, Barlow has co-published dozens of comics, including the anthologies SEEDS, SHELTER and WOODS. Barlow lives in Vermont, works in politics and photographs cemeteries. www.danielbarlow.com - Keith Moriarty is a musician and writer living in New Hampshire. That's all you need to know.")
add('Ocarinaoftim', 'http://ocarinaoftim.webcomic.ws/', u"Welcome to our world! It's strange, but a lot of fun! This reads right to left, in traditional manga style. We should warn you: if you are looking for a serious adventure..you may want to pick something else to read. Also...there is a bit of language. Not a lot of harsh language, but it is there.")
add('Oceanlabyrinth', 'http://oceanlabyrinth.webcomic.ws/', u'A day at the beach turns into a desperate escape back to her family, when Karen falls down a sand cliff. She meets a bat in a sea cave and comes out to an apocalyptic version of her world. She must find her way home and battle her inner demons. Nothing will ever be the same. Story and characters by sawyerLUVSyou, illustrated by Blaeringr. http://blaeringr.deviantart.com/ Also on SmackJeeves: http://www.smackjeeves.com/comicprofile.php?id=140030 Buy Volume 1: http://www.indyplanet.com/store/product_info.php?products_id=9111')
add('Offhours', 'http://offhours.webcomic.ws/', u"Imagine that all of these webcomics are like television shows and all of the characters are like actors. Now, what would those actors be like off the set? Then throw in a disaster or two, and you've got Off Hours!")
add('OldHumanCookies', 'http://OldHumanCookies.webcomic.ws/', u"These are the older comics in my Human Cookies series. I've been asked by a few people to upload them, so here they are (well once they're all up anyway) I know some of them look bad, the focuses are terrible, the lighting is...well...yuck, but this is where I started, so they bring back some smiley memories for me, so enjoy the tackiness!")
add('Onepagecomiccollection', 'http://onepagecomiccollection.webcomic.ws/', u'A large number of one page comics on topics that range from teapots to a-bomb tests.')
add('Organizedmess', 'http://organizedmess.webcomic.ws/', u"Organized Mess documents the everyday lives of 4 oddly familiar characters. Sometime's it's humorous...most of the time it's not.")
add('Outferasmoke', 'http://outferasmoke.webcomic.ws/', u'The long and rambling story of Joss, a snarky young woman, her confused and abused buddy Lee and their perky housemate, Carrie. Contains drug use, sex, mild violence, profanity and, occasionally, boobies. Updates Sundays and Thursdays.')
add('Outletting', 'http://outletting.webcomic.ws/', u"OutLetting is the first webcomic of Feeny, a professional writing student at York University. starting out as random peeks into Feeny's mind and everyday life as she percieves it, the webcomic has much potential. Names have been changed for the protection of prudey and privacy-loving friends.")
add('Pandemonium', 'http://Pandemonium.webcomic.ws/', u'The random spewage of my mind')
add('Paperstreamer', 'http://paperstreamer.webcomic.ws/', u'A science fiction web comic loosely based on ongoing research and speculation regarding space elevators and alternative space launch methods. The story and images are composed in pulp fiction and noir styles, with some use of 3D models, but with informative sections regarding the related technologies and concepts. The author and artist is an active reader of related technical research papers and hopes to entertain the audience while learning about the space elevator and its related physics concepts.')
add('ParaFrenic', 'http://ParaFrenic.webcomic.ws/', u'ParaFrenic is an 18 year old half-man/half monster who holds down a daytime job as a video comic actor and spends the rest of his days trying to survive the tough avenues of Vagrant Street.')
add('ParasiteGalaxy', 'http://ParasiteGalaxy.webcomic.ws/', u"Matt, a seemingly average boy lives a boring average life. Until one day, with a single bite into a burger, his destiny crossed with something beyond the scope of his comprehension.... No longer will he eat the fast food of boredom, for something unnatural has slipped into dinner today....todays dinner will be accompanied by an emmisary from beyond the cold void! Get ready, Ragnarok is about to begin! Parasite Galaxy: Coming soon to a theater near you! Not yet rated, but it better be ARRR, because that's what pirates say!")
add('Parmeshen', 'http://parmeshen.webcomic.ws/', u"A story of gypsies, rovers and ramblers, of secrets and stories so old they're in the blood and bone of the people who tell them. This is a tale as wild as the wind and the roads. Come, and learn where it leads.")
add('Peepsnperks', 'http://peepsnperks.webcomic.ws/', u"A Trio of friends decide to combine their two favorite things - sex and coffee. who doesn't love sex and coffee?! NSFW, unless you work in porn, in which case, call me!")
add('Pegwarmers', 'http://Pegwarmers.webcomic.ws/', u"Pegwarmers is basically a rip off of Twisted Kaiju Theater, but with superhero action figures. Occasionally, Transformers, Godzilla, and Star Trek characters will make an appearance, but it's predominantly superhero based. The main three characters are Deadpool, Spider-Man, and Batman.")
add('PersonaFTW', 'http://PersonaFTW.webcomic.ws/', u'Finally, all of the Persona for the Win series in one convenient location. Containing the works of Persona Won, Persona 2 Win, Persona 3 FTW, and Persona 4TW. Now obviously as parody comics, all of the works do contain spoilers of their respective games. Read at your own risk.')
add('Perspectives', 'http://perspectives.webcomic.ws/', u'The dark twin of humor. A webcomic all about points of view. I write this in my spare time at work to stay sane, and wanted to share it with the world. I update every Monday, Wednesday, and Friday.')
add('Phantomstrail', 'http://phantomstrail.webcomic.ws/', u"The king of Mindon has died. His heir, Princess Jacquilyn, is expected to succeed to the throne, but Duke Medrick makes his own plans to take control of the kingdom. High Councilor Vasquez discovers Medrick's plan to usurp power. He, along with his son and the princess' bodyguard, take the princess away from the kingdom, to protect her. (Please look at the Synopsis page for a detailed description.) This webcomic currently updates sporadically on Mondays at noon Central time zone.")
add('Pilgrimenespanol', 'http://pilgrimenespanol.webcomic.ws/', u'')
add('Pilgrimsprogress', 'http://pilgrimsprogress.webcomic.ws/', u'Two brothers in the Guatemalan highlands befriend a lost traveller.')
add('PiratesLife', 'http://PiratesLife.webcomic.ws/', u'A story about a Merchant and his crew who find themselves travelling all around the LEGO world.')
add('Pitchblack', 'http://pitchblack.webcomic.ws/', u'A black comedy webcomic with a particular tendency to make little kids cry.')
add('PlanetChaser', 'http://PlanetChaser.webcomic.ws/', u'All Clarissa wanted to do was have fun and travel around the galaxy. Her wish came true when she turned eighteen and inherited a space ship and a robot. She also inherited more than she bargained for.')
add('PlasticBulletsMayhemUnloaded', 'http://PlasticBulletsMayhemUnloaded.webcomic.ws/', u"Andrew Cross was going nowhere fast. It seemed that he couldn't stick to anything that he tried. However after several deaths in the family, Cross realized just how short life truly is. Determined to leave his mark on the world before he dies, Cross and his friends enter the Mayhem Unloaded tournament. A brutal combat simulator, where there can only be one victor.")
add('PobrePucho', 'http://PobrePucho.webcomic.ws/', u'There is a place far underground you have no idea it exists, with Lycanthropes, giant bugs, weird politics and NINJA BUNNIES. And poor Pucho just has to suck it up and join the party as the new Lycan in Paws Den!')
add('Poharex', 'http://poharex.webcomic.ws/', u'In a prehistoric world, Poharex rises up to become the defender of all dinosaurs.')
add('Popcultureskids', 'http://pop-cultures-kids.webcomic.ws/', u'A small group of kids, including a relative newcomer to the town, create a club for their mutual love of TV, music, movies, etc. My influences include Krazy Kat, Pogo, Bloom County and Calvin & Hobbes.')
add('Poussiere', 'http://poussiere.webcomic.ws/', u"Un monde o\xf9 les cr\xe9atures fantastiques existent ne peut qu'\xeatre un peu compliqu\xe9. Si vous voulez le visiter, commencez donc par les villes, c'est plein d'humains et de confort moderne, tant que \xe7a ne vous d\xe9range pas d'avoir un lutin pour voisin ou un troll pour chauffeur. Mais vous n'\xeates pas racistes, n'est-ce pas?")
#add('Princesschroma', 'http://princesschroma.webcomic.ws/', u"The earth is under attack! Dark forces have come to blot out color and cast the world into a chaotic void. It's up to June Summer, a rambunctious, violent schoolgirl to put an end to the madness. With friends, frenemies, and a oft-abused magical bunny by her side, June must wield the potent magic of Princess Chroma and battle horrible monsters--all while wearing a cute, frilly dress. There just had to be a catch, didn't there?")
add('ProjectGTH', 'http://ProjectGTH.webcomic.ws/', u'A story about a genetically engineered girl made to be a killing machine. Who now tries to live a normal life after escaping her creators, but is still haunted by her past')
add('Projectjikoku', 'http://projectjikoku.webcomic.ws/', u'A strange disturbance from a distant land has caught the interest of two young siblings. Their father had been lost for years and because of this anomaly, they may finally have hope that he is still alive deep in the darker regions of the universe. Fighting well-known foes, the two young Maracans set out to rescue their father from the clutches from the tyrants that are the Jikoku.')
add('Proportionalexcitability', 'http://proportionalexcitability.webcomic.ws/', u'The mostly real life adventures of two sisters. Updates Mondays.')
add('Pt', 'http://pt.webcomic.ws/', u'When a father and son disappear the worst is thought. Only when they return 5 days later with powers and aged does the true horror of their disappearance reveals itself.')
add('Pulse', 'http://pulse.webcomic.ws/', u'Annie "Pulse" Chang, and Tabitha "Bolt" Greene, two female human batteries become armored super-heroines.')
add('Punch', 'http://Punch.webcomic.ws/', u'The adventures of Mr Punch')
add('Purehavoc', 'http://pure-havoc.webcomic.ws/', u"Aaron Kidway is a 20 year old pizza delivery boy who hasn't had much luck in life...But Aaron's luck changes when Aaron meets a mysterious girl during a delivery!")
add('RPS', 'http://RPS.webcomic.ws/', u'RPS follows the near asylum-level misadventures of the Role-Play Saturday LARP game. Updates Wednesdays!')
add('RPT', 'http://RPT.webcomic.ws/', u'This webcomic has no amount of roleplaying (as of now or in the near future), and does NOT occur in a roleplaying-game universe with roleplaying-game rules. This webccomic DOES contain the story of a bunch of people living together or whatever, and there\'s supposed to be guns and explosions too. Centered around a main cast of characters, everyone with their perks and peculiarities, who just want to live a "normal" life, even when the destiny (script) pits them into battles where they might fight for more than their lives. And this webcomic also contains a (maybe not so) lenghty description describing in detail things that may or may not be true, depending on how do you interpret "normal".')
add('Randomlyassembled', 'http://randomlyassembled.webcomic.ws/', u'')
add('Randomthoughts', 'http://randomthoughts.webcomic.ws/', u"Yeah so this really is random thoughts. I woke up one morning thinking about a duck-sausage and I figured I might as well start doing a webcomic about things. Yes..Things. Stuff and junk and stuff that happens to me. And things. It's mostly sort of an online diary, except also not. It's just random thoughts. I apologize for dry humor, bad puns and possible injuries you suffer from facepalming. However, I hope you enjoy :D")
add('Rangerrandom', 'http://rangerrandom.webcomic.ws/', u"Basically, where I put my unrelated art, or art not important enough to be mentioned. In spite of the nudity tag, is mostly safe for work unless specifically warned otherwise. It's art, so not all art is SFW.")
add('Raspcat', 'http://raspcat.webcomic.ws/', u"The story of Upir's Mark, the most shocking band in Siberia and possibly the Universe.")
#add('Ravenwolf', 'http://ravenwolf.webcomic.ws/', u'Due to human negligence the world as we know it has ended and been reborn. The animal spirits that guide man giving them the forms of animals so that they would be able to survive in this new wilderness. Though now carrying the form of beasts man has not forgotten the place they once had, as an existence greater then just what nature wanted of them, an existence above all. Those that worked to gain their humanity are known as domestics, while those who wished to follow the rolls the spirits had given them were known as wilds. Both groups grew arrogant and hateful of one another, the wilds saw the domestics as selfish monsters, for they were returning to the ways that had once destroyed the world, while the domestics saw the wilds as primitive beings afraid of progress, they no better than wild animals. The raven and the wolf spirits grew tired of the destruction and fighting, and sided with the wilds in their ideals, the domestics only capable of further destroying nature. In their anger they marked a tribe of wilds with a curse, they being removed from the sacred circle of life, unable to hunt or grow their own food, their souls never able to move on while their bodies are unable to return to the earth when they died. The curse upon them only broken once the domestics are gone once and for all. The cursed tribe now known to all by the name of the spirits whom cursed them. \u2018Raven Wolf\u2019')
add('RealLifeTrips', 'http://RealLifeTrips.webcomic.ws/', u'A "fictionalised" collection of biographical accounts, each of taken from real trips I\'ve made in the past (I kept detailed journals of each). The names of people and places will be cosmetically changed, partly because the content involves transsexual and transgender elements. For example, Sydney will become "Emerald City\u201d, and the main character Edgar / Elsie are based on me. Style and format change each chapter. To be collected and published in paper format when finished.')
add('RebelYell', 'http://RebelYell.webcomic.ws/', u"A middle aged space jockey and his happy go lucky partner decide it's time for a change in careers and find themselves involved in a solar system wide conspiracy. The comic is actually a by product of an animation project being developed for television. Genre: Sci-Fi/Comedy/Action/Drama Visit our official website. http://ricomcarlos.wix.com/rebelyell")
add('RecklessComix', 'http://RecklessComix.webcomic.ws/', u'We are a couple of guys (or a few sometimes) With a camera and too much free time at work... Enjoy us')
add('Remedy', 'http://Remedy.webcomic.ws/', u'Historical fantasy based in 5th century Roman empire. Even folklore has a beginning. Dark powers are stirring and only one band of outcasts stands between the world and oblivion. Whether for revenge,loyalty, curiosity, hope, despair, or love a curse brought them together and somewhere out there is the remedy. Updates often.(Any comments, questions, or criticisms would help greatly.)')
add('Requiemsgate', 'http://requiemsgate.webcomic.ws/', u'')
add('Residentweirdo', 'http://residentweirdo.webcomic.ws/', u'Some games, some life, some randomness. Whenever updates')
add('Rockgardencomics', 'http://rockgardencomics.webcomic.ws/', u'Rock Garden Comics rotates four recurring themes: 1. The adventures of Rose and her family and friends, 2. mummies and zombies and their kin, 3. geezers in all their glory, and 4. Tales from the Rocculture.')
add('Romanjack', 'http://romanjack.webcomic.ws/', u'Mankind is on its last leg. Earth has fallen. All hope rests on one myth. The legend of a mystical Ark lost in space and time. Said to have the power to kill the alien invaders. Is it real? Can it be found in time? No one knows, but Captain Roman Jack and the crew of the "Hawk" must try. Before it is too late. Roman Jack is a sci fi action adventure that will take you where you have never gone before. A 3D Comic.')
add('RumfAdventures', 'http://RumfAdventures.webcomic.ws/', u"Hello! It is my pleasure to welcome you to the site of my beloved comic strip Rumf Adventures! In the event that you have not become acquainted with my tiny strip,allow me to give you a quick rundown.This is an action-packed adventure strip with a dash of humor.It features a cast of thousands, starring the mighty adventurer Rumfus! That's it.I don't want to spoil the rest for you,just start reading! Onward to Adventures!")
#add('Runespark', 'http://runespark.webcomic.ws/', u'Ever have your house crash-landed on by time-travelling aliens? Ever been put on trial by interdimensional magical princesses? Then you and Li have a lot in common! Pull up a seat and check out RuneSpark, an adventure spanning three worlds. Currently updated Monday-Friday.')
add('Rvr', 'http://rvr.webcomic.ws/', u'Alexandra Carter lived with only one focus in life, loyalty to her lord and country. Unfortunately for her, other members of her country did not see it that way. Framed for murder and treason, she endured unspeakable tortures and waited for her time to strike. What will she find before the crawling darkness consumes her and the land?')
add('SailorMoonTheEnemyNextDoor', 'http://SailorMoonTheEnemyNextDoor.webcomic.ws/', u'This is a fan manga inspired, written, and drawn by the original author of Sailor Moon: Ms. Naoko Takeuchi. Karolina Romanska and John Smith do not wish in any way to claim, usurp, or abuse property rights of Ms Naoko Takeuchi and the other authors of images used in this fan-based manga. This is a NON-PROFIT project, done strictly in our leisure time for sheer enjoyment.')
#add('SakuraDAY', 'http://SakuraDAY.webcomic.ws/', u'Follow the adventures of Meija as she begins a second chance in life after a fatal accident. She finds truth, love, friendship, trials, self-revelation, and PURPOSE. P.S. The comic is read the traditional manga-style: right-to-left. UPDATES WEEKLY {Saturday || Sunday} Merci Beaucoup. Enjoy!')
add('Sarakleeyo', 'http://sarakleeyo.webcomic.ws/', u"A World of Warcraft themed web comic starring the Argent Crusade's unusual misfits. The crusade allowed heroes of the Alliance and Horde to become partners. Sara & Kleeyo set the example...provided they can survive their friendship. Updated Mondays.")
add('Savemegebus', 'http://savemegebus.webcomic.ws/', u"Gebus considers himself the True Saviour of Humanity, though he rarely does anything about that. The comic revolves around him and his adventures which are often written as multiple-strip fabricated stories in order to explain changes in Gebus' appearance. As a comic straight out of the minds of the authors with little or no forethought, what plot or general continuity there is exists largely as an excuse for the authors to keep making comic strips. The fourth wall is broken regularly, and characters are taken directly from the authors' real life, though the storylines are not. The comic's style is taken from the comic it was spun from, Pixel-Sapiens, which features blocky characters with little to no curves or movement, and simple or absent backgrounds.")
add('Sawbladersblacknuzlocke', 'http://sawbladersblacknuzlocke.webcomic.ws/', u'*SADLY, THIS COMIC HAS BEEN ABANDONED. NO FURTHER UPDATES ARE BEING MADE TO THIS RUN.* A hand-drawn Nuzlocke comic detailing one crazy adventure in Pokemon: Black Version! Trust me, the art gets better as it goes along! Original Thread on the Offical Nuzlocke Forums: http://s7.zetaboards.com/Nuzlocke_Forum/topic/8520848/')
add('Schizmatic', 'http://schizmatic.webcomic.ws/', u'Schizmatic is a webcomic based on blueprint schematics applied to actual life. It puts the cosmos under a microscope, and reality under analysis.')
add('Scoundrels', 'http://scoundrels.webcomic.ws/', u'"Scoundrels" is a collaborative comics project featuring stories from all corners of a dangerous futuristic world. Updates every Monday and Friday!')
add('Scrubdiving', 'http://scrubdiving.webcomic.ws/', u"It's a comic about scuba diving. And cyborgs. The color/shading will be rough until I figure Manga Studio out.")
add('Seconds', 'http://Seconds.webcomic.ws/', u'All the comics here are primarily made in [i]Second Life[/i] and other virtual worlds, using crews of avatars to pose for and shoot the images used in each panel. It follows different stories with different characters over time. The initial story, [i]Return to Second Life[/i], is about what happens when avatars meet their owner in-world. General schedule is one page a day when reprinting , and about one page every two days when in production.')
add('Secretsanta2013', 'http://secretsanta2013.webcomic.ws/', u'Fan art trade for 2013')
add('SeeYourFeels', 'http://SeeYourFeels.webcomic.ws/', u'Comic is storyline-less, jump in anytime and hit the "random" button! Update Schedule: Every business day (Monday through Friday, excluding holidays) www.facebook.com/ICanSeeYourFeels')
add('Seed', 'http://Seed.webcomic.ws/', u'Raised in a land where magic is as common as breathing and where natural wonders abound, Dominique has always known that she was different. Longing to know more about who she really is, Dominique travels to the city of Celastin where she believes she can find the answers that she seeks. Unbeknownst to her, magic is strictly forbidden in this mighty city, a fact that will soon lead Dominique into great danger, new friends and onto an adventure that will span this vast and fantastical world. - Description written by Orian Johnson (Editor for Seed)')
add('Serengetti', 'http://serengetti.webcomic.ws/', u"Serengetti Dreams, as you may have inferred from the title, is a webcomic by Shane Itram. It updates daily, Monday through Friday. First time here? Kind of lost? Check out Dr. Bolton's welcome to new readers!")
add('Serpamiaflare', 'http://serpamiaflare.webcomic.ws/', u"Seeking meaning in a series of strange dreams involving her mother who died years ago, Kylie journeys to Raswen to find Madame Zinala, a fortune teller who has been known to interpret dreams with great accuracy. On the way, she meets Cain, a seemingly hapless cleric who, coincidentally, is also trying to meet Madame Zinala in hopes of learning how to break the curse of chains on his body. Together, they reach Raswen and go to find Madame Zinala. Unfortunately, their timing couldn't be worse...")
add('Shades', 'http://shades.webcomic.ws/', u'A WW2 fighter pilot, a First Century warrior queen and a prehistoric mystic. Oh, and their tailor. These are not your common-or-garden heroes!')
add('ShamanQuest', 'http://ShamanQuest.webcomic.ws/', u'A Nomad, a young runaway, a psychic on the verge of madness and other characters band together to reach New Babel, one of the last cities on Earth. On their way stands the Wastelands, huge desert filled with mad prophets, power-hunger mafias, bizarre creatures and the looming threat of a World-scale conspiracy...')
#add('Shameless', 'http://Shameless.webcomic.ws/', u'The story of a 14 year old girl who suddenly wakes up with the duty to create a region on a barren world known as Origen, alongside six other "Cosmos" that are alien in appearance. Join her as she faces the hardships of unrequited love, friendship, jealousy, and the inevitable...')
add('Shatterrealm', 'http://shatterrealm.webcomic.ws/', u'Iconoclasts clash as wanderers from parallel worlds fight for survival, meaning, and a way to get home. Through tehcnological or supernatural means, a random few have managed to move back and forth between worlds. Some are lost. Some are searching. Some are hunters and exterminators. An exploration of the human heart.')
add('Shonenpunkremix', 'http://shonenpunkremix.webcomic.ws/', u'an entire evil space empire wants his blood! but all Chiitsu wants is to build an epic space harem!')
#add('Signifikat', 'http://signifikat.webcomic.ws/', u'While on the run from the Cinnamon City authorities, robotic girl Sunhra meets her match at the outskirts of the information highway: a young man with the ability to bend machinery to his will...')
add('Silvernights', 'http://silvernights.webcomic.ws/', u"Wilson Jones is a retired, rich and bored man. So he decides to become a detective, although it seems he doesn't know what he's doing. In fact, he doesn't have the slightest idea of what he's doing.")
#add('SimplySarah', 'http://SimplySarah.webcomic.ws/', u'Follow Sarah through her life as she deals with her own personal relationship issues and those of the people around her. Lesbian themed with one trans character and lots of other varied relationship issues.')
add('Sinjetpack', 'http://sinjetpack.webcomic.ws/', u'Mi Vida Sin Un Jetpack es un comic autobiogr\xe1fico sobre la vida de MaGnUs, escrito por \xe9l, con arte de Taibox (ocasionalmente coloreado por Mindy Lopkin). Publicado semanalmente en ingl\xe9s y espa\xf1ol.')
add('Spf1337', 'http://spf1337.webcomic.ws/', u'A webcomic about the little things in life that let you get through the hard times. With groan-inducing puns and hilarious antics, SPF is here to entertain you. Or is it the other way around...?')
add('Sscomic', 'http://ss-comic.webcomic.ws/', u'')
add('Teenagedragon', 'http://teenagedragon.webcomic.ws/', u"Meet one Zeke Fahrenheit, film critic extraordinaire, and also father to a dragon. He's (sometimes) better at one of those jobs than the other. Follow along with him as he tries to raise his green, four-armed daughter Snapdragon, woo the exotic cat-girl Princess Acinonyx, avoid his evil ex-girlfriend Dr. Abby Mars, and just try to survive a world where pop culture is not to be embraced but feared.")
add('TheButterflyEffect', 'http://TheButterflyEffect.webcomic.ws/', u'Sun, Sand, Surfing, Sex. Kombis, Karma, Kindness. Life, Love, Loss. ...and gender issues. Includes an intersex main character, nudity, sex..."real life" in fact. O.K., so it\'s a SOAPIE, I admit ! B-)')
add('Theashes', 'http://theashes.webcomic.ws/', u'Wolf and Fox have already lived through a lot of disasters - the death of their parents, the end of the world to name a couple - and come out of them stronger. With their lives already in ashes, what could the future possibly hold worse than this?')
add('Thecrease', 'http://thecrease.webcomic.ws/', u'These vast distances of space are only traversed by the benefit of massive star bases that generate the extensive amounts of energy needed to fold space. These star bases have been in use for almost a century and are now considered a common sight in the galaxy. But there was a time when it wasn\u2019t as safe to travel the folds and ships were lost. It was rumored that when a ship disappeared it fell in to an unknown area of space...a place halfway between the origin and destination... a place known as \u201cThe Crease\u201d.')
add('TwentyQuidAmusements', 'http://TwentyQuidAmusements.webcomic.ws/', u"This webcomic dedicates itself to parodying the funny and illogical parts of games. It also sometimes dabbles in the problematic lives of the average (or rather extreme) gamer. You'll probably need an acquired taste, but give it a try, you might just like it.")
add('Wowwithatwistdamaclesandkejallcomic', 'http://Wowwithatwist-damaclesandkejallcomic.webcomic.ws/', u'Follow the dangerous adventures of Damacles , the human warrior and kenjall a worgen')
