#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sherlock Holmes: The Case of the Silver Earring
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250115.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='sherlock-holmes-2-the-case-of-the-silver-earring'
GAME_NAME='Sherlock Holmes: The Case of the Silver Earring'

ARCHIVE_BASE_0_NAME='setup_sherlock_holmes_secret_of_the_silver_earring_2.1.0.9.exe'
ARCHIVE_BASE_0_MD5='877e21a4e439793df05acb06bcd27817'
## Do not convert the paths to lowercase, to avoid breaking a puzzle
## cf. https://forge.dotslashplay.it/play.it/games-adventure/-/issues/3
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS=' '
ARCHIVE_BASE_0_SIZE='1500000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.9'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/sherlock_holmes_secret_of_the_silver_earring'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
binkw32.dll
game.exe
setup.ini'
CONTENT_GAME_DATA_FILES='
characters
fonts
graphics
movies
scenes
script
text
sound.0000
textures.0000'
CONTENT_DOC_DATA_FILES='
manual.pdf'

USER_PERSISTENT_DIRECTORIES='
save'
USER_PERSISTENT_FILES='
setup.ini'

APP_MAIN_EXE='game.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101 --language=1049'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
