#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Chook & Sosig: Walk the Plank
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250826.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='chook-and-sosig-walk-the-plank'
GAME_NAME='Chook & Sosig: Walk the Plank'

ARCHIVE_BASE_ITCH_0_NAME='Windows.zip'
ARCHIVE_BASE_ITCH_0_MD5='176ccce8f5af056a8247f0cfef1f2d1e'
ARCHIVE_BASE_ITCH_0_SIZE='5154279'
ARCHIVE_BASE_ITCH_0_VERSION='2.03b-itch1'
ARCHIVE_BASE_ITCH_0_URL='https://tookipalooki.itch.io/chook-sosig-walk-the-plank'

ARCHIVE_BASE_GOG_0_NAME='setup_chook__sosig_walk_the_plank_v2.03b_(30724).exe'
ARCHIVE_BASE_GOG_0_MD5='e66cdecc51060a98325297d7f9039307'
ARCHIVE_BASE_GOG_0_TYPE='innosetup'
ARCHIVE_BASE_GOG_0_SIZE='5200000'
ARCHIVE_BASE_GOG_0_VERSION='2.03b-gog30724'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/chook_sosig_walk_the_plank'

UNITY3D_NAME='walktheplank'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/TookiPalooki/WalkthePlank'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'
## Easier upgrades from pre-20241211.1 packages
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
chook-and-sosig"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20241211.1 packages
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
chook-and-sosig-data"

## convmv is used to convert file paths to lower case.
REQUIREMENTS_LIST='
convmv'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

## itch.io build - Ignore some errors during extraction from the archive
## warning:  stripped absolute path spec from /
## mapname:  conversion of  failed
case "$(current_archive)" in
	('ARCHIVE_BASE_ITCH_'*)
		archive_extraction_default 2>/dev/null || true
	;;
	(*)
		archive_extraction_default
	;;
esac
## itch.io build - Convert all file paths to lower case.
case "$(current_archive)" in
	('ARCHIVE_BASE_ITCH_'*)
		rmdir \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/Mono/etc" \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/Mono/EmbedRuntime" \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/Mono"
		cp --link --recursive \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/WalkthePlank_Data"/* \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/walktheplank_data"
		rm --recursive \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/WalkthePlank_Data"
		tolower "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	;;
esac

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
